import type { BrowserProxy } from './contextual_tasks_browser_proxy.js';
/**
 * A proxy class to control post messages sent to the webview.
 */
export declare class PostMessageHandler {
    private readonly maxHandshakeAttempts_;
    private webview_;
    private targetOrigin_;
    private eventTracker_;
    private browserProxy_;
    private handshakeComplete_;
    private handshakeAttempts_;
    private handshakeIntervalId_;
    private pendingMessages_;
    private handshakeMessage_;
    constructor(webview: chrome.webviewTag.WebView, browserProxy: BrowserProxy, maxHandshakeAttempts_?: number);
    /**
     * Sends a message to the webview. If the handshake has not yet been
     * acknowledged, the message will be queued and sent after the handshake is
     * complete.
     * @param message The serialized message to send.
     */
    sendMessage(message: Uint8Array): void;
    detach(): void;
    private onLoadStop_;
    private resetHandshake_;
    private startHandshake_;
    private stopHandshake_;
    private onMessageReceived_;
    completeHandshake(): void;
    getPendingMessagesLengthForTesting(): number;
    isHandshakeCompleteForTesting(): boolean;
    private postMessage_;
}
