import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_slider/cr_slider.js';
import '//resources/cr_elements/cr_textarea/cr_textarea.js';
import '/strings.m.js';
import type { CrSliderElement } from '//resources/cr_elements/cr_slider/cr_slider.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { Time } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import type { Tab } from '../contextual_tasks_internals.mojom-webui.js';
export declare class EventLogMessage {
    eventTime: Date;
    sourceLinkText: string;
    sourceLinkURL: string;
    message: string;
    constructor(eventTime: Time, sourceFile: string, sourceLine: number, message: string);
    setSourceLink(sourceFile: string, sourceLine: number): void;
    /**
     * Returns a string for dumping the message to logs.
     */
    toLogDump(): string;
}
export interface ContextualTasksInternalsAppElement {
    $: {
        tabSelectionModeSelect: HTMLSelectElement;
        minModelScoreSlider: CrSliderElement;
    };
}
export declare class ContextualTasksInternalsAppElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        relevantTabs_: {
            type: ArrayConstructor;
        };
        query_: {
            type: StringConstructor;
        };
        isQueryPending_: {
            type: BooleanConstructor;
        };
        tabSelectionMode_: {
            type: StringConstructor;
        };
        minModelScore_: {
            type: NumberConstructor;
        };
        minModelScoreTicks_: {
            type: ArrayConstructor;
        };
        eventLogMessages_: {
            type: ArrayConstructor;
        };
    };
    protected accessor relevantTabs_: Tab[];
    protected accessor query_: string;
    protected accessor isQueryPending_: boolean;
    protected accessor tabSelectionMode_: string;
    protected accessor minModelScore_: number;
    protected accessor eventLogMessages_: EventLogMessage[];
    private proxy_;
    connectedCallback(): void;
    protected onTabSelectionModeChanged_(): void;
    protected onMinModelScoreChanged_(): void;
    protected onQueryChanged_(e: CustomEvent<{
        value: string;
    }>): void;
    protected onSubmitClick_(): Promise<void>;
    private onLogMessageAdded_;
}
declare global {
    interface HTMLElementTagNameMap {
        'contextual-tasks-internals-app': ContextualTasksInternalsAppElement;
    }
}
