// chrome/browser/contextual_tasks/contextual_tasks.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UuidSpec as mojoBase_mojom_UuidSpec } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'contextual_tasks.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getThreadUrl() {
        return this.proxy.sendMessage(0, PageHandler_GetThreadUrl_ParamsSpec.$, PageHandler_GetThreadUrl_ResponseParamsSpec.$, [], false);
    }
    getUrlForTask(uuid) {
        return this.proxy.sendMessage(1, PageHandler_GetUrlForTask_ParamsSpec.$, PageHandler_GetUrlForTask_ResponseParamsSpec.$, [
            uuid
        ], false);
    }
    setTaskId(uuid) {
        this.proxy.sendMessage(2, PageHandler_SetTaskId_ParamsSpec.$, null, [
            uuid
        ], false);
    }
    isZeroState(url) {
        return this.proxy.sendMessage(3, PageHandler_IsZeroState_ParamsSpec.$, PageHandler_IsZeroState_ResponseParamsSpec.$, [
            url
        ], false);
    }
    setThreadTitle(title) {
        this.proxy.sendMessage(4, PageHandler_SetThreadTitle_ParamsSpec.$, null, [
            title
        ], false);
    }
    closeSidePanel() {
        this.proxy.sendMessage(5, PageHandler_CloseSidePanel_ParamsSpec.$, null, [], false);
    }
    showThreadHistory() {
        this.proxy.sendMessage(6, PageHandler_ShowThreadHistory_ParamsSpec.$, null, [], false);
    }
    isShownInTab() {
        return this.proxy.sendMessage(7, PageHandler_IsShownInTab_ParamsSpec.$, PageHandler_IsShownInTab_ResponseParamsSpec.$, [], false);
    }
    openMyActivityUi() {
        this.proxy.sendMessage(8, PageHandler_OpenMyActivityUi_ParamsSpec.$, null, [], false);
    }
    openHelpUi() {
        this.proxy.sendMessage(9, PageHandler_OpenHelpUi_ParamsSpec.$, null, [], false);
    }
    openOnboardingHelpUi() {
        this.proxy.sendMessage(10, PageHandler_OpenOnboardingHelpUi_ParamsSpec.$, null, [], false);
    }
    moveTaskUiToNewTab() {
        this.proxy.sendMessage(11, PageHandler_MoveTaskUiToNewTab_ParamsSpec.$, null, [], false);
    }
    onTabClickedFromSourcesMenu(tabId, url) {
        this.proxy.sendMessage(12, PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$, null, [
            tabId,
            url
        ], false);
    }
    onWebviewMessage(message) {
        this.proxy.sendMessage(13, PageHandler_OnWebviewMessage_ParamsSpec.$, null, [
            message
        ], false);
    }
    getCommonSearchParams(isDarkMode, isSidePanel) {
        return this.proxy.sendMessage(14, PageHandler_GetCommonSearchParams_ParamsSpec.$, PageHandler_GetCommonSearchParams_ResponseParamsSpec.$, [
            isDarkMode,
            isSidePanel
        ], false);
    }
    onboardingTooltipDismissed() {
        this.proxy.sendMessage(15, PageHandler_OnboardingTooltipDismissed_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetThreadUrl_ParamsSpec.$, PageHandler_GetThreadUrl_ResponseParamsSpec.$, impl.getThreadUrl.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetUrlForTask_ParamsSpec.$, PageHandler_GetUrlForTask_ResponseParamsSpec.$, impl.getUrlForTask.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_SetTaskId_ParamsSpec.$, null, impl.setTaskId.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_IsZeroState_ParamsSpec.$, PageHandler_IsZeroState_ResponseParamsSpec.$, impl.isZeroState.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_SetThreadTitle_ParamsSpec.$, null, impl.setThreadTitle.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_CloseSidePanel_ParamsSpec.$, null, impl.closeSidePanel.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_ShowThreadHistory_ParamsSpec.$, null, impl.showThreadHistory.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_IsShownInTab_ParamsSpec.$, PageHandler_IsShownInTab_ResponseParamsSpec.$, impl.isShownInTab.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_OpenMyActivityUi_ParamsSpec.$, null, impl.openMyActivityUi.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_OpenHelpUi_ParamsSpec.$, null, impl.openHelpUi.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_OpenOnboardingHelpUi_ParamsSpec.$, null, impl.openOnboardingHelpUi.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_MoveTaskUiToNewTab_ParamsSpec.$, null, impl.moveTaskUiToNewTab.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$, null, impl.onTabClickedFromSourcesMenu.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_OnWebviewMessage_ParamsSpec.$, null, impl.onWebviewMessage.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_GetCommonSearchParams_ParamsSpec.$, PageHandler_GetCommonSearchParams_ResponseParamsSpec.$, impl.getCommonSearchParams.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_OnboardingTooltipDismissed_ParamsSpec.$, null, impl.onboardingTooltipDismissed.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "contextual_tasks.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getThreadUrl;
    getUrlForTask;
    setTaskId;
    isZeroState;
    setThreadTitle;
    closeSidePanel;
    showThreadHistory;
    isShownInTab;
    openMyActivityUi;
    openHelpUi;
    openOnboardingHelpUi;
    moveTaskUiToNewTab;
    onTabClickedFromSourcesMenu;
    onWebviewMessage;
    getCommonSearchParams;
    onboardingTooltipDismissed;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getThreadUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetThreadUrl_ParamsSpec.$, PageHandler_GetThreadUrl_ResponseParamsSpec.$, this.getThreadUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.getUrlForTask =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetUrlForTask_ParamsSpec.$, PageHandler_GetUrlForTask_ResponseParamsSpec.$, this.getUrlForTask.createReceiverHandler(true /* expectsResponse */), false);
        this.setTaskId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_SetTaskId_ParamsSpec.$, null, this.setTaskId.createReceiverHandler(false /* expectsResponse */), false);
        this.isZeroState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_IsZeroState_ParamsSpec.$, PageHandler_IsZeroState_ResponseParamsSpec.$, this.isZeroState.createReceiverHandler(true /* expectsResponse */), false);
        this.setThreadTitle =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_SetThreadTitle_ParamsSpec.$, null, this.setThreadTitle.createReceiverHandler(false /* expectsResponse */), false);
        this.closeSidePanel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_CloseSidePanel_ParamsSpec.$, null, this.closeSidePanel.createReceiverHandler(false /* expectsResponse */), false);
        this.showThreadHistory =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_ShowThreadHistory_ParamsSpec.$, null, this.showThreadHistory.createReceiverHandler(false /* expectsResponse */), false);
        this.isShownInTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_IsShownInTab_ParamsSpec.$, PageHandler_IsShownInTab_ResponseParamsSpec.$, this.isShownInTab.createReceiverHandler(true /* expectsResponse */), false);
        this.openMyActivityUi =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_OpenMyActivityUi_ParamsSpec.$, null, this.openMyActivityUi.createReceiverHandler(false /* expectsResponse */), false);
        this.openHelpUi =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_OpenHelpUi_ParamsSpec.$, null, this.openHelpUi.createReceiverHandler(false /* expectsResponse */), false);
        this.openOnboardingHelpUi =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_OpenOnboardingHelpUi_ParamsSpec.$, null, this.openOnboardingHelpUi.createReceiverHandler(false /* expectsResponse */), false);
        this.moveTaskUiToNewTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_MoveTaskUiToNewTab_ParamsSpec.$, null, this.moveTaskUiToNewTab.createReceiverHandler(false /* expectsResponse */), false);
        this.onTabClickedFromSourcesMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$, null, this.onTabClickedFromSourcesMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.onWebviewMessage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_OnWebviewMessage_ParamsSpec.$, null, this.onWebviewMessage.createReceiverHandler(false /* expectsResponse */), false);
        this.getCommonSearchParams =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_GetCommonSearchParams_ParamsSpec.$, PageHandler_GetCommonSearchParams_ResponseParamsSpec.$, this.getCommonSearchParams.createReceiverHandler(true /* expectsResponse */), false);
        this.onboardingTooltipDismissed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_OnboardingTooltipDismissed_ParamsSpec.$, null, this.onboardingTooltipDismissed.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'contextual_tasks.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setThreadTitle(title) {
        this.proxy.sendMessage(0, Page_SetThreadTitle_ParamsSpec.$, null, [
            title
        ], false);
    }
    setTaskDetails(uuid, threadId, turnId) {
        this.proxy.sendMessage(1, Page_SetTaskDetails_ParamsSpec.$, null, [
            uuid,
            threadId,
            turnId
        ], false);
    }
    onSidePanelStateChanged() {
        this.proxy.sendMessage(2, Page_OnSidePanelStateChanged_ParamsSpec.$, null, [], false);
    }
    postMessageToWebview(message) {
        this.proxy.sendMessage(3, Page_PostMessageToWebview_ParamsSpec.$, null, [
            message
        ], false);
    }
    onHandshakeComplete() {
        this.proxy.sendMessage(4, Page_OnHandshakeComplete_ParamsSpec.$, null, [], false);
    }
    setOAuthToken(oauthToken) {
        this.proxy.sendMessage(5, Page_SetOAuthToken_ParamsSpec.$, null, [
            oauthToken
        ], false);
    }
    onContextUpdated(contextTabs) {
        this.proxy.sendMessage(6, Page_OnContextUpdated_ParamsSpec.$, null, [
            contextTabs
        ], false);
    }
    hideInput() {
        this.proxy.sendMessage(7, Page_HideInput_ParamsSpec.$, null, [], false);
    }
    restoreInput() {
        this.proxy.sendMessage(8, Page_RestoreInput_ParamsSpec.$, null, [], false);
    }
    onZeroStateChange(isZeroState) {
        this.proxy.sendMessage(9, Page_OnZeroStateChange_ParamsSpec.$, null, [
            isZeroState
        ], false);
    }
    onAiPageStatusChanged(isAiPage) {
        this.proxy.sendMessage(10, Page_OnAiPageStatusChanged_ParamsSpec.$, null, [
            isAiPage
        ], false);
    }
    onLensOverlayStateChanged(isShowing) {
        this.proxy.sendMessage(11, Page_OnLensOverlayStateChanged_ParamsSpec.$, null, [
            isShowing
        ], false);
    }
    showErrorPage() {
        this.proxy.sendMessage(12, Page_ShowErrorPage_ParamsSpec.$, null, [], false);
    }
    hideErrorPage() {
        this.proxy.sendMessage(13, Page_HideErrorPage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_SetThreadTitle_ParamsSpec.$, null, impl.setThreadTitle.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_SetTaskDetails_ParamsSpec.$, null, impl.setTaskDetails.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_OnSidePanelStateChanged_ParamsSpec.$, null, impl.onSidePanelStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_PostMessageToWebview_ParamsSpec.$, null, impl.postMessageToWebview.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_OnHandshakeComplete_ParamsSpec.$, null, impl.onHandshakeComplete.bind(impl), false);
        this.helper_internal_.registerHandler(5, Page_SetOAuthToken_ParamsSpec.$, null, impl.setOAuthToken.bind(impl), false);
        this.helper_internal_.registerHandler(6, Page_OnContextUpdated_ParamsSpec.$, null, impl.onContextUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(7, Page_HideInput_ParamsSpec.$, null, impl.hideInput.bind(impl), false);
        this.helper_internal_.registerHandler(8, Page_RestoreInput_ParamsSpec.$, null, impl.restoreInput.bind(impl), false);
        this.helper_internal_.registerHandler(9, Page_OnZeroStateChange_ParamsSpec.$, null, impl.onZeroStateChange.bind(impl), false);
        this.helper_internal_.registerHandler(10, Page_OnAiPageStatusChanged_ParamsSpec.$, null, impl.onAiPageStatusChanged.bind(impl), false);
        this.helper_internal_.registerHandler(11, Page_OnLensOverlayStateChanged_ParamsSpec.$, null, impl.onLensOverlayStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(12, Page_ShowErrorPage_ParamsSpec.$, null, impl.showErrorPage.bind(impl), false);
        this.helper_internal_.registerHandler(13, Page_HideErrorPage_ParamsSpec.$, null, impl.hideErrorPage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "contextual_tasks.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    setThreadTitle;
    setTaskDetails;
    onSidePanelStateChanged;
    postMessageToWebview;
    onHandshakeComplete;
    setOAuthToken;
    onContextUpdated;
    hideInput;
    restoreInput;
    onZeroStateChange;
    onAiPageStatusChanged;
    onLensOverlayStateChanged;
    showErrorPage;
    hideErrorPage;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setThreadTitle =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_SetThreadTitle_ParamsSpec.$, null, this.setThreadTitle.createReceiverHandler(false /* expectsResponse */), false);
        this.setTaskDetails =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_SetTaskDetails_ParamsSpec.$, null, this.setTaskDetails.createReceiverHandler(false /* expectsResponse */), false);
        this.onSidePanelStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_OnSidePanelStateChanged_ParamsSpec.$, null, this.onSidePanelStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.postMessageToWebview =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_PostMessageToWebview_ParamsSpec.$, null, this.postMessageToWebview.createReceiverHandler(false /* expectsResponse */), false);
        this.onHandshakeComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_OnHandshakeComplete_ParamsSpec.$, null, this.onHandshakeComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.setOAuthToken =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Page_SetOAuthToken_ParamsSpec.$, null, this.setOAuthToken.createReceiverHandler(false /* expectsResponse */), false);
        this.onContextUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Page_OnContextUpdated_ParamsSpec.$, null, this.onContextUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.hideInput =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Page_HideInput_ParamsSpec.$, null, this.hideInput.createReceiverHandler(false /* expectsResponse */), false);
        this.restoreInput =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Page_RestoreInput_ParamsSpec.$, null, this.restoreInput.createReceiverHandler(false /* expectsResponse */), false);
        this.onZeroStateChange =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Page_OnZeroStateChange_ParamsSpec.$, null, this.onZeroStateChange.createReceiverHandler(false /* expectsResponse */), false);
        this.onAiPageStatusChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Page_OnAiPageStatusChanged_ParamsSpec.$, null, this.onAiPageStatusChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onLensOverlayStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, Page_OnLensOverlayStateChanged_ParamsSpec.$, null, this.onLensOverlayStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.showErrorPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, Page_ShowErrorPage_ParamsSpec.$, null, this.showErrorPage.createReceiverHandler(false /* expectsResponse */), false);
        this.hideErrorPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, Page_HideErrorPage_ParamsSpec.$, null, this.hideErrorPage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'contextual_tasks.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, pageHandler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            pageHandler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "contextual_tasks.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TabSpec = { $: {} };
export const PageHandler_GetThreadUrl_ParamsSpec = { $: {} };
export const PageHandler_GetThreadUrl_ResponseParamsSpec = { $: {} };
export const PageHandler_GetUrlForTask_ParamsSpec = { $: {} };
export const PageHandler_GetUrlForTask_ResponseParamsSpec = { $: {} };
export const PageHandler_SetTaskId_ParamsSpec = { $: {} };
export const PageHandler_IsZeroState_ParamsSpec = { $: {} };
export const PageHandler_IsZeroState_ResponseParamsSpec = { $: {} };
export const PageHandler_SetThreadTitle_ParamsSpec = { $: {} };
export const PageHandler_CloseSidePanel_ParamsSpec = { $: {} };
export const PageHandler_ShowThreadHistory_ParamsSpec = { $: {} };
export const PageHandler_IsShownInTab_ParamsSpec = { $: {} };
export const PageHandler_IsShownInTab_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenMyActivityUi_ParamsSpec = { $: {} };
export const PageHandler_OpenHelpUi_ParamsSpec = { $: {} };
export const PageHandler_OpenOnboardingHelpUi_ParamsSpec = { $: {} };
export const PageHandler_MoveTaskUiToNewTab_ParamsSpec = { $: {} };
export const PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec = { $: {} };
export const PageHandler_OnWebviewMessage_ParamsSpec = { $: {} };
export const PageHandler_GetCommonSearchParams_ParamsSpec = { $: {} };
export const PageHandler_GetCommonSearchParams_ResponseParamsSpec = { $: {} };
export const PageHandler_OnboardingTooltipDismissed_ParamsSpec = { $: {} };
export const Page_SetThreadTitle_ParamsSpec = { $: {} };
export const Page_SetTaskDetails_ParamsSpec = { $: {} };
export const Page_OnSidePanelStateChanged_ParamsSpec = { $: {} };
export const Page_PostMessageToWebview_ParamsSpec = { $: {} };
export const Page_OnHandshakeComplete_ParamsSpec = { $: {} };
export const Page_SetOAuthToken_ParamsSpec = { $: {} };
export const Page_OnContextUpdated_ParamsSpec = { $: {} };
export const Page_HideInput_ParamsSpec = { $: {} };
export const Page_RestoreInput_ParamsSpec = { $: {} };
export const Page_OnZeroStateChange_ParamsSpec = { $: {} };
export const Page_OnAiPageStatusChanged_ParamsSpec = { $: {} };
export const Page_OnLensOverlayStateChanged_ParamsSpec = { $: {} };
export const Page_ShowErrorPage_ParamsSpec = { $: {} };
export const Page_HideErrorPage_ParamsSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
mojo.internal.Struct(TabSpec.$, 'Tab', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_GetThreadUrl_ParamsSpec.$, 'PageHandler_GetThreadUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetThreadUrl_ResponseParamsSpec.$, 'PageHandler_GetThreadUrl_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetUrlForTask_ParamsSpec.$, 'PageHandler_GetUrlForTask_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetUrlForTask_ResponseParamsSpec.$, 'PageHandler_GetUrlForTask_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetTaskId_ParamsSpec.$, 'PageHandler_SetTaskId_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsZeroState_ParamsSpec.$, 'PageHandler_IsZeroState_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsZeroState_ResponseParamsSpec.$, 'PageHandler_IsZeroState_ResponseParams', [
    mojo.internal.StructField('isZeroState', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetThreadTitle_ParamsSpec.$, 'PageHandler_SetThreadTitle_Params', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CloseSidePanel_ParamsSpec.$, 'PageHandler_CloseSidePanel_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ShowThreadHistory_ParamsSpec.$, 'PageHandler_ShowThreadHistory_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsShownInTab_ParamsSpec.$, 'PageHandler_IsShownInTab_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsShownInTab_ResponseParamsSpec.$, 'PageHandler_IsShownInTab_ResponseParams', [
    mojo.internal.StructField('isInTab', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenMyActivityUi_ParamsSpec.$, 'PageHandler_OpenMyActivityUi_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenHelpUi_ParamsSpec.$, 'PageHandler_OpenHelpUi_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenOnboardingHelpUi_ParamsSpec.$, 'PageHandler_OpenOnboardingHelpUi_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_MoveTaskUiToNewTab_ParamsSpec.$, 'PageHandler_MoveTaskUiToNewTab_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$, 'PageHandler_OnTabClickedFromSourcesMenu_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_OnWebviewMessage_ParamsSpec.$, 'PageHandler_OnWebviewMessage_Params', [
    mojo.internal.StructField('message', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetCommonSearchParams_ParamsSpec.$, 'PageHandler_GetCommonSearchParams_Params', [
    mojo.internal.StructField('isDarkMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSidePanel', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetCommonSearchParams_ResponseParamsSpec.$, 'PageHandler_GetCommonSearchParams_ResponseParams', [
    mojo.internal.StructField('params', 0, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnboardingTooltipDismissed_ParamsSpec.$, 'PageHandler_OnboardingTooltipDismissed_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SetThreadTitle_ParamsSpec.$, 'Page_SetThreadTitle_Params', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SetTaskDetails_ParamsSpec.$, 'Page_SetTaskDetails_Params', [
    mojo.internal.StructField('uuid', 0, 0, mojoBase_mojom_UuidSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('threadId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('turnId', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Page_OnSidePanelStateChanged_ParamsSpec.$, 'Page_OnSidePanelStateChanged_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_PostMessageToWebview_ParamsSpec.$, 'Page_PostMessageToWebview_Params', [
    mojo.internal.StructField('message', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnHandshakeComplete_ParamsSpec.$, 'Page_OnHandshakeComplete_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SetOAuthToken_ParamsSpec.$, 'Page_SetOAuthToken_Params', [
    mojo.internal.StructField('oauthToken', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnContextUpdated_ParamsSpec.$, 'Page_OnContextUpdated_Params', [
    mojo.internal.StructField('contextTabs', 0, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_HideInput_ParamsSpec.$, 'Page_HideInput_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_RestoreInput_ParamsSpec.$, 'Page_RestoreInput_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnZeroStateChange_ParamsSpec.$, 'Page_OnZeroStateChange_Params', [
    mojo.internal.StructField('isZeroState', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnAiPageStatusChanged_ParamsSpec.$, 'Page_OnAiPageStatusChanged_Params', [
    mojo.internal.StructField('isAiPage', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnLensOverlayStateChanged_ParamsSpec.$, 'Page_OnLensOverlayStateChanged_Params', [
    mojo.internal.StructField('isShowing', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ShowErrorPage_ParamsSpec.$, 'Page_ShowErrorPage_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_HideErrorPage_ParamsSpec.$, 'Page_HideErrorPage_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageHandler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
