import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { Uuid as mojoBase_mojom_Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { Url as url_mojom_Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    getThreadUrl(): Promise<{
        url: url_mojom_Url;
    }>;
    getUrlForTask(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url;
    }>;
    setTaskId(uuid: mojoBase_mojom_Uuid): void;
    isZeroState(url: url_mojom_Url): Promise<{
        isZeroState: boolean;
    }>;
    setThreadTitle(title: string): void;
    closeSidePanel(): void;
    showThreadHistory(): void;
    isShownInTab(): Promise<{
        isInTab: boolean;
    }>;
    openMyActivityUi(): void;
    openHelpUi(): void;
    openOnboardingHelpUi(): void;
    moveTaskUiToNewTab(): void;
    onTabClickedFromSourcesMenu(tabId: number, url: url_mojom_Url): void;
    onWebviewMessage(message: number[]): void;
    getCommonSearchParams(isDarkMode: boolean, isSidePanel: boolean): Promise<{
        params: {
            [key: string]: string;
        };
    }>;
    onboardingTooltipDismissed(): void;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    getThreadUrl(): Promise<{
        url: url_mojom_Url;
    }>;
    getUrlForTask(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url;
    }>;
    setTaskId(uuid: mojoBase_mojom_Uuid): void;
    isZeroState(url: url_mojom_Url): Promise<{
        isZeroState: boolean;
    }>;
    setThreadTitle(title: string): void;
    closeSidePanel(): void;
    showThreadHistory(): void;
    isShownInTab(): Promise<{
        isInTab: boolean;
    }>;
    openMyActivityUi(): void;
    openHelpUi(): void;
    openOnboardingHelpUi(): void;
    moveTaskUiToNewTab(): void;
    onTabClickedFromSourcesMenu(tabId: number, url: url_mojom_Url): void;
    onWebviewMessage(message: number[]): void;
    getCommonSearchParams(isDarkMode: boolean, isSidePanel: boolean): Promise<{
        params: {
            [key: string]: string;
        };
    }>;
    onboardingTooltipDismissed(): void;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    getThreadUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getUrlForTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setTaskId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    isZeroState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setThreadTitle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    closeSidePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showThreadHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    isShownInTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openMyActivityUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openHelpUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openOnboardingHelpUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    moveTaskUiToNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onTabClickedFromSourcesMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onWebviewMessage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getCommonSearchParams: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onboardingTooltipDismissed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
    setThreadTitle(title: string): void;
    setTaskDetails(uuid: mojoBase_mojom_Uuid, threadId: string, turnId: string): void;
    onSidePanelStateChanged(): void;
    postMessageToWebview(message: number[]): void;
    onHandshakeComplete(): void;
    setOAuthToken(oauthToken: string): void;
    onContextUpdated(contextTabs: Tab[]): void;
    hideInput(): void;
    restoreInput(): void;
    onZeroStateChange(isZeroState: boolean): void;
    onAiPageStatusChanged(isAiPage: boolean): void;
    onLensOverlayStateChanged(isShowing: boolean): void;
    showErrorPage(): void;
    hideErrorPage(): void;
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
    setThreadTitle(title: string): void;
    setTaskDetails(uuid: mojoBase_mojom_Uuid, threadId: string, turnId: string): void;
    onSidePanelStateChanged(): void;
    postMessageToWebview(message: number[]): void;
    onHandshakeComplete(): void;
    setOAuthToken(oauthToken: string): void;
    onContextUpdated(contextTabs: Tab[]): void;
    hideInput(): void;
    restoreInput(): void;
    onZeroStateChange(isZeroState: boolean): void;
    onAiPageStatusChanged(isAiPage: boolean): void;
    onLensOverlayStateChanged(isShowing: boolean): void;
    showErrorPage(): void;
    hideErrorPage(): void;
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    setThreadTitle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setTaskDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onSidePanelStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    postMessageToWebview: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onHandshakeComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setOAuthToken: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onContextUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    hideInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    restoreInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onZeroStateChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onAiPageStatusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onLensOverlayStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showErrorPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    hideErrorPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PageHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
export declare class PageHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerFactoryInterface {
    createPageHandler(page: PageRemote, pageHandler: PageHandlerPendingReceiver): void;
}
export declare class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    createPageHandler(page: PageRemote, pageHandler: PageHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerFactoryInterface);
}
export declare class PageHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const TabSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetThreadUrl_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetThreadUrl_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetUrlForTask_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetUrlForTask_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetTaskId_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_IsZeroState_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_IsZeroState_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetThreadTitle_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CloseSidePanel_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ShowThreadHistory_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_IsShownInTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_IsShownInTab_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenMyActivityUi_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenHelpUi_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenOnboardingHelpUi_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_MoveTaskUiToNewTab_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnWebviewMessage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetCommonSearchParams_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetCommonSearchParams_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnboardingTooltipDismissed_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetThreadTitle_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetTaskDetails_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnSidePanelStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_PostMessageToWebview_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnHandshakeComplete_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetOAuthToken_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnContextUpdated_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_HideInput_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_RestoreInput_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnZeroStateChange_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnAiPageStatusChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnLensOverlayStateChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_ShowErrorPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_HideErrorPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandlerFactory_CreatePageHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface TabMojoType {
    tabId: number;
    title: string;
    url: url_mojom_Url;
}
export type Tab = TabMojoType;
export interface PageHandler_GetThreadUrl_ParamsMojoType {
}
export type PageHandler_GetThreadUrl_Params = PageHandler_GetThreadUrl_ParamsMojoType;
export interface PageHandler_GetThreadUrl_ResponseParamsMojoType {
    url: url_mojom_Url;
}
export type PageHandler_GetThreadUrl_ResponseParams = PageHandler_GetThreadUrl_ResponseParamsMojoType;
export interface PageHandler_GetUrlForTask_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type PageHandler_GetUrlForTask_Params = PageHandler_GetUrlForTask_ParamsMojoType;
export interface PageHandler_GetUrlForTask_ResponseParamsMojoType {
    url: url_mojom_Url;
}
export type PageHandler_GetUrlForTask_ResponseParams = PageHandler_GetUrlForTask_ResponseParamsMojoType;
export interface PageHandler_SetTaskId_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
}
export type PageHandler_SetTaskId_Params = PageHandler_SetTaskId_ParamsMojoType;
export interface PageHandler_IsZeroState_ParamsMojoType {
    url: url_mojom_Url;
}
export type PageHandler_IsZeroState_Params = PageHandler_IsZeroState_ParamsMojoType;
export interface PageHandler_IsZeroState_ResponseParamsMojoType {
    isZeroState: boolean;
}
export type PageHandler_IsZeroState_ResponseParams = PageHandler_IsZeroState_ResponseParamsMojoType;
export interface PageHandler_SetThreadTitle_ParamsMojoType {
    title: string;
}
export type PageHandler_SetThreadTitle_Params = PageHandler_SetThreadTitle_ParamsMojoType;
export interface PageHandler_CloseSidePanel_ParamsMojoType {
}
export type PageHandler_CloseSidePanel_Params = PageHandler_CloseSidePanel_ParamsMojoType;
export interface PageHandler_ShowThreadHistory_ParamsMojoType {
}
export type PageHandler_ShowThreadHistory_Params = PageHandler_ShowThreadHistory_ParamsMojoType;
export interface PageHandler_IsShownInTab_ParamsMojoType {
}
export type PageHandler_IsShownInTab_Params = PageHandler_IsShownInTab_ParamsMojoType;
export interface PageHandler_IsShownInTab_ResponseParamsMojoType {
    isInTab: boolean;
}
export type PageHandler_IsShownInTab_ResponseParams = PageHandler_IsShownInTab_ResponseParamsMojoType;
export interface PageHandler_OpenMyActivityUi_ParamsMojoType {
}
export type PageHandler_OpenMyActivityUi_Params = PageHandler_OpenMyActivityUi_ParamsMojoType;
export interface PageHandler_OpenHelpUi_ParamsMojoType {
}
export type PageHandler_OpenHelpUi_Params = PageHandler_OpenHelpUi_ParamsMojoType;
export interface PageHandler_OpenOnboardingHelpUi_ParamsMojoType {
}
export type PageHandler_OpenOnboardingHelpUi_Params = PageHandler_OpenOnboardingHelpUi_ParamsMojoType;
export interface PageHandler_MoveTaskUiToNewTab_ParamsMojoType {
}
export type PageHandler_MoveTaskUiToNewTab_Params = PageHandler_MoveTaskUiToNewTab_ParamsMojoType;
export interface PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType {
    tabId: number;
    url: url_mojom_Url;
}
export type PageHandler_OnTabClickedFromSourcesMenu_Params = PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType;
export interface PageHandler_OnWebviewMessage_ParamsMojoType {
    message: number[];
}
export type PageHandler_OnWebviewMessage_Params = PageHandler_OnWebviewMessage_ParamsMojoType;
export interface PageHandler_GetCommonSearchParams_ParamsMojoType {
    isDarkMode: boolean;
    isSidePanel: boolean;
}
export type PageHandler_GetCommonSearchParams_Params = PageHandler_GetCommonSearchParams_ParamsMojoType;
export interface PageHandler_GetCommonSearchParams_ResponseParamsMojoType {
    params: {
        [key: string]: string;
    };
}
export type PageHandler_GetCommonSearchParams_ResponseParams = PageHandler_GetCommonSearchParams_ResponseParamsMojoType;
export interface PageHandler_OnboardingTooltipDismissed_ParamsMojoType {
}
export type PageHandler_OnboardingTooltipDismissed_Params = PageHandler_OnboardingTooltipDismissed_ParamsMojoType;
export interface Page_SetThreadTitle_ParamsMojoType {
    title: string;
}
export type Page_SetThreadTitle_Params = Page_SetThreadTitle_ParamsMojoType;
export interface Page_SetTaskDetails_ParamsMojoType {
    uuid: mojoBase_mojom_Uuid;
    threadId: string;
    turnId: string;
}
export type Page_SetTaskDetails_Params = Page_SetTaskDetails_ParamsMojoType;
export interface Page_OnSidePanelStateChanged_ParamsMojoType {
}
export type Page_OnSidePanelStateChanged_Params = Page_OnSidePanelStateChanged_ParamsMojoType;
export interface Page_PostMessageToWebview_ParamsMojoType {
    message: number[];
}
export type Page_PostMessageToWebview_Params = Page_PostMessageToWebview_ParamsMojoType;
export interface Page_OnHandshakeComplete_ParamsMojoType {
}
export type Page_OnHandshakeComplete_Params = Page_OnHandshakeComplete_ParamsMojoType;
export interface Page_SetOAuthToken_ParamsMojoType {
    oauthToken: string;
}
export type Page_SetOAuthToken_Params = Page_SetOAuthToken_ParamsMojoType;
export interface Page_OnContextUpdated_ParamsMojoType {
    contextTabs: Tab[];
}
export type Page_OnContextUpdated_Params = Page_OnContextUpdated_ParamsMojoType;
export interface Page_HideInput_ParamsMojoType {
}
export type Page_HideInput_Params = Page_HideInput_ParamsMojoType;
export interface Page_RestoreInput_ParamsMojoType {
}
export type Page_RestoreInput_Params = Page_RestoreInput_ParamsMojoType;
export interface Page_OnZeroStateChange_ParamsMojoType {
    isZeroState: boolean;
}
export type Page_OnZeroStateChange_Params = Page_OnZeroStateChange_ParamsMojoType;
export interface Page_OnAiPageStatusChanged_ParamsMojoType {
    isAiPage: boolean;
}
export type Page_OnAiPageStatusChanged_Params = Page_OnAiPageStatusChanged_ParamsMojoType;
export interface Page_OnLensOverlayStateChanged_ParamsMojoType {
    isShowing: boolean;
}
export type Page_OnLensOverlayStateChanged_Params = Page_OnLensOverlayStateChanged_ParamsMojoType;
export interface Page_ShowErrorPage_ParamsMojoType {
}
export type Page_ShowErrorPage_Params = Page_ShowErrorPage_ParamsMojoType;
export interface Page_HideErrorPage_ParamsMojoType {
}
export type Page_HideErrorPage_Params = Page_HideErrorPage_ParamsMojoType;
export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
    page: PageRemote;
    pageHandler: PageHandlerPendingReceiver;
}
export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
