import '//resources/cr_components/composebox/composebox.js';
import './onboarding_tooltip.js';
import type { ComposeboxElement } from '//resources/cr_components/composebox/composebox.js';
import type { TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ContextualTasksOnboardingTooltipElement } from './onboarding_tooltip.js';
export interface ContextualTasksComposeboxElement {
    $: {
        composebox: ComposeboxElement;
        onboardingTooltip: ContextualTasksOnboardingTooltipElement;
    };
}
export declare class ContextualTasksComposeboxElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        isZeroState: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isSidePanel: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isLensOverlayShowing: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        composeboxHeight_: {
            type: NumberConstructor;
        };
        composeboxDropdownHeight_: {
            type: NumberConstructor;
        };
        isComposeboxFocused_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        showContextMenu_: {
            type: BooleanConstructor;
            value: boolean;
        };
        tabSuggestions_: {
            type: ArrayConstructor;
        };
        showOnboardingTooltip_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    accessor isZeroState: boolean;
    accessor isSidePanel: boolean;
    accessor isLensOverlayShowing: boolean;
    protected accessor composeboxHeight_: number;
    protected accessor composeboxDropdownHeight_: number;
    protected accessor isComposeboxFocused_: boolean;
    protected accessor showContextMenu_: boolean;
    protected accessor tabSuggestions_: TabInfo[];
    protected accessor showOnboardingTooltip_: boolean;
    private eventTracker_;
    private searchboxCallbackRouter_;
    private searchboxHandler_;
    private searchboxListenerIds_;
    private onboardingTooltipIsVisible_;
    private numberOfTimesTooltipShown_;
    private readonly maximumTimesTooltipShown_;
    private isOnboardingTooltipDismissCountBelowCap_;
    private userDismissedTooltip_;
    private resizeObserver_;
    private tooltipImpressionTimer_;
    private readonly tooltipImpressionDelay_;
    constructor();
    connectedCallback(): void;
    private updateTooltipVisibility_;
    private shouldShowOnboardingTooltip;
    protected onTooltipDismissed_(): void;
    private clearTooltipImpressionTimer_;
    disconnectedCallback(): void;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected refreshTabSuggestions_(): Promise<void>;
    clearInputAndFocus(querySubmitted?: boolean): void;
    startExpandAnimation(): void;
    private startObservingResize_;
    private stopObservingResize_;
    get isComposeboxFocusedForTesting(): boolean;
    get composeboxHeightForTesting(): number;
    get numberOfTimesTooltipShownForTesting(): number;
    set numberOfTimesTooltipShownForTesting(n: number);
    set userDismissedTooltipForTesting(dismissed: boolean);
    updateTooltipVisibilityForTesting(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'contextual-tasks-composebox': ContextualTasksComposeboxElement;
    }
}
