import './composebox.js';
import './error_page.js';
import './top_toolbar.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ContextualTasksComposeboxElement } from './composebox.js';
import type { Tab } from './contextual_tasks.mojom-webui.js';
export interface ContextualTasksAppElement {
    $: {
        threadFrame: chrome.webviewTag.WebView;
        composebox: ContextualTasksComposeboxElement;
        composeboxHeaderWrapper: HTMLElement;
    };
}
export declare class ContextualTasksAppElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        isShownInTab_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        threadTitle_: {
            type: StringConstructor;
        };
        contextTabs_: {
            type: ArrayConstructor;
        };
        darkMode_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isErrorPageVisible_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isInBasicMode_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isZeroState_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isAiPage_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isLensOverlayShowing_: {
            type: BooleanConstructor;
        };
    };
    private browserProxy_;
    protected accessor isAiPage_: boolean;
    protected accessor isLensOverlayShowing_: boolean;
    protected accessor isShownInTab_: boolean;
    protected accessor darkMode_: boolean;
    private pendingUrl_;
    protected accessor threadTitle_: string;
    protected accessor contextTabs_: Tab[];
    protected accessor isInBasicMode_: boolean;
    protected accessor isErrorPageVisible_: boolean;
    protected accessor isZeroState_: boolean;
    protected friendlyZeroStateSubtitle: string;
    protected friendlyZeroStateTitle: string;
    private listenerIds_;
    private oauthToken_;
    private commonSearchParams_;
    private postMessageHandler_;
    private forcedEmbeddedPageHost;
    private signInDomains_;
    firstUpdated(): void;
    protected onNewThreadClick_(): Promise<void>;
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    private maybeUpdateThreadUrlForRestore;
    private postMessageToWebview;
    private maybeLoadPendingUrl_;
    private onHandshakeComplete;
    private updateSidePanelState;
    private updateCommonSearchParams;
    private setupWebviewRequestOverrides;
    private addCommonSearchParams;
    private onBeforeRequest;
    private onBeforeSendHeaders;
    getPendingUrlForTesting(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'contextual-tasks-app': ContextualTasksAppElement;
    }
}
