// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import '//resources/cr_elements/cr_icon/cr_iconset.js';

import {getTrustedHTML} from '//resources/js/static_types.js';

const div = document.createElement('div');
div.innerHTML = getTrustedHTML`
<cr-iconset name="contextual_tasks">
  <svg>
    <defs>
      <g id="edit_square">
        <path d="M 5.101562 20.773438 C 4.585938 20.773438 4.144531 20.589844 3.777344 20.222656 C 3.410156 19.855469 3.226562 19.414062 3.226562 18.898438 L 3.226562 5.101562 C 3.226562 4.585938 3.410156 4.144531 3.777344 3.777344 C 4.144531 3.410156 4.585938 3.226562 5.101562 3.226562 L 13.949219 3.226562 L 12.074219 5.101562 L 5.101562 5.101562 L 5.101562 18.898438 L 18.898438 18.898438 L 18.898438 11.886719 L 20.773438 10.011719 L 20.773438 18.898438 C 20.773438 19.414062 20.589844 19.855469 20.222656 20.222656 C 19.855469 20.589844 19.414062 20.773438 18.898438 20.773438 Z M 12 12 Z M 9.0625 14.9375 L 9.0625 10.773438 L 18.273438 1.5625 C 18.464844 1.371094 18.675781 1.230469 18.898438 1.144531 C 19.125 1.054688 19.355469 1.011719 19.59375 1.011719 C 19.847656 1.011719 20.085938 1.054688 20.3125 1.144531 C 20.539062 1.230469 20.746094 1.371094 20.9375 1.5625 L 22.425781 3.074219 C 22.601562 3.265625 22.734375 3.476562 22.824219 3.699219 C 22.917969 3.925781 22.960938 4.160156 22.960938 4.398438 C 22.960938 4.640625 22.921875 4.871094 22.835938 5.09375 C 22.753906 5.316406 22.617188 5.519531 22.425781 5.710938 L 13.226562 14.9375 Z M 21.113281 4.398438 L 19.613281 2.886719 Z M 10.9375 13.0625 L 12.4375 13.0625 L 18.300781 7.1875 L 17.550781 6.4375 L 16.789062 5.699219 L 10.9375 11.539062 Z M 17.550781 6.4375 L 16.789062 5.699219 L 17.550781 6.4375 L 18.300781 7.1875 Z M 17.550781 6.4375"/>
      </g>
      <g id="schedule_auto">
        <path d="M 12 12 Z M 12 2.25 C 13.347656 2.25 14.617188 2.507812 15.800781 3.019531 C 16.988281 3.53125 18.019531 4.226562 18.898438 5.105469 C 19.773438 5.984375 20.46875 7.015625 20.980469 8.203125 C 21.492188 9.386719 21.75 10.652344 21.75 12 C 21.75 13.347656 21.492188 14.617188 20.980469 15.800781 C 20.46875 16.988281 19.773438 18.019531 18.894531 18.898438 C 18.015625 19.773438 16.984375 20.46875 15.796875 20.980469 C 14.613281 21.492188 13.347656 21.75 12 21.75 L 11.789062 21.75 L 11.789062 19.875 L 12 19.875 C 14.191406 19.875 16.050781 19.109375 17.582031 17.582031 C 19.109375 16.050781 19.875 14.191406 19.875 12 C 19.875 9.808594 19.109375 7.949219 17.582031 6.417969 C 16.050781 4.890625 14.191406 4.125 12 4.125 C 9.808594 4.125 7.949219 4.890625 6.417969 6.417969 C 4.890625 7.949219 4.125 9.808594 4.125 12 L 4.125 12.210938 L 2.25 12.210938 L 2.25 12 C 2.25 10.652344 2.507812 9.382812 3.019531 8.199219 C 3.53125 7.011719 4.226562 5.980469 5.105469 5.101562 C 5.984375 4.226562 7.015625 3.53125 8.203125 3.019531 C 9.386719 2.507812 10.652344 2.25 12 2.25 Z M 5.460938 22.988281 C 5.445312 22.988281 5.378906 22.9375 5.265625 22.839844 C 5 21.832031 4.503906 20.960938 3.773438 20.226562 C 3.039062 19.492188 2.171875 18.996094 1.160156 18.734375 C 1.128906 18.714844 1.078125 18.652344 1.011719 18.535156 C 1.011719 18.503906 1.0625 18.4375 1.160156 18.339844 C 2.167969 18.078125 3.039062 17.578125 3.773438 16.847656 C 4.507812 16.117188 5.003906 15.246094 5.265625 14.238281 C 5.285156 14.203125 5.347656 14.152344 5.464844 14.085938 C 5.496094 14.085938 5.5625 14.136719 5.660156 14.234375 C 5.941406 15.242188 6.441406 16.113281 7.164062 16.847656 C 7.886719 17.582031 8.753906 18.082031 9.761719 18.34375 C 9.796875 18.34375 9.847656 18.40625 9.914062 18.539062 C 9.914062 18.554688 9.863281 18.621094 9.765625 18.734375 C 8.757812 19 7.886719 19.496094 7.152344 20.226562 C 6.417969 20.960938 5.917969 21.828125 5.65625 22.839844 C 5.65625 22.871094 5.59375 22.921875 5.460938 22.988281 Z M 15.273438 16.601562 L 16.601562 15.273438 L 12.949219 11.621094 L 12.949219 7.074219 L 11.074219 7.074219 L 11.074219 12.375 Z M 15.273438 16.601562"/>
      </g>
      <g id="open_in_full_tab" viewBox="0 -960 960 960">
        <path d="M144-144v-288h72v165l477-477H528v-72h288v288h-72v-165L267-216h165v72H144Z"/></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;

const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
  document.head.appendChild(iconset);
}
