// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import"//resources/cr_elements/cr_tooltip/cr_tooltip.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./contextual_tasks_browser_proxy.js";import{getCss}from"./onboarding_tooltip.css.js";import{getHtml}from"./onboarding_tooltip.html.js";export class ContextualTasksOnboardingTooltipElement extends CrLitElement{static get is(){return"contextual-tasks-onboarding-tooltip"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{target:{type:Object},shouldShow:{type:Boolean}}}#target_accessor_storage=null;get target(){return this.#target_accessor_storage}set target(value){this.#target_accessor_storage=value}#shouldShow_accessor_storage=false;get shouldShow(){return this.#shouldShow_accessor_storage}set shouldShow(value){this.#shouldShow_accessor_storage=value}onboardingTitle_=loadTimeData.getString("onboardingTitle");onboardingBody_=loadTimeData.getString("onboardingBody");onboardingLink_=loadTimeData.getString("onboardingLink");onboardingLinkUrl_=loadTimeData.getString("onboardingLinkUrl");get tooltip_(){return this.shadowRoot.querySelector("cr-tooltip")}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("target")&&this.target){this.tooltip_.target=this.target}}show(){if(this.tooltip_){this.tooltip_.show();this.updatePosition()}}hide(){if(this.tooltip_){this.tooltip_.hide()}}updatePosition(){if(this.tooltip_&&this.target){const targetRect=this.target.getBoundingClientRect();const MARGIN_RIGHT=24;const availableWidth=window.innerWidth-targetRect.left-MARGIN_RIGHT;this.tooltip_.style.setProperty("--onboarding-tooltip-width",`${availableWidth}px`);const parentRect=this.tooltip_.offsetParent?.getBoundingClientRect();const tooltipRect=this.tooltip_.getBoundingClientRect();if(parentRect){const left=targetRect.left-parentRect.left;const top=targetRect.top-parentRect.top-tooltipRect.height;this.tooltip_.style.left=`${left}px`;this.tooltip_.style.top=`${top}px`;this.tooltip_.style.right="auto"}}}onTooltipClose_(e){e.stopPropagation();BrowserProxyImpl.getInstance().handler.onboardingTooltipDismissed();this.hide();this.dispatchEvent(new CustomEvent("onboarding-tooltip-dismissed",{bubbles:true,composed:true}))}onHelpLinkClick_(e){e.preventDefault();BrowserProxyImpl.getInstance().handler.openOnboardingHelpUi()}}customElements.define(ContextualTasksOnboardingTooltipElement.is,ContextualTasksOnboardingTooltipElement);