// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getFaviconForPageURL}from"chrome://resources/js/icon.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./favicon_group.css.js";import{getHtml}from"./favicon_group.html.js";const MAX_DISPLAY_COUNT=3;export class ContextualTasksFaviconGroupElement extends CrLitElement{static get is(){return"contextual-tasks-favicon-group"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{urls:{type:Array},visibleUrls_:{type:Array},remainingCount_:{type:Number}}}#urls_accessor_storage=[];get urls(){return this.#urls_accessor_storage}set urls(value){this.#urls_accessor_storage=value}#visibleUrls__accessor_storage=[];get visibleUrls_(){return this.#visibleUrls__accessor_storage}set visibleUrls_(value){this.#visibleUrls__accessor_storage=value}#remainingCount__accessor_storage=0;get remainingCount_(){return this.#remainingCount__accessor_storage}set remainingCount_(value){this.#remainingCount__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("urls")){this.onUrlsChanged_()}}onUrlsChanged_(){const numToDisplay=Math.min(this.urls.length,MAX_DISPLAY_COUNT);this.visibleUrls_=this.urls.slice(0,numToDisplay);this.remainingCount_=this.urls.length-numToDisplay}getFaviconUrl_(url){return getFaviconForPageURL(url,false)}}customElements.define(ContextualTasksFaviconGroupElement.is,ContextualTasksFaviconGroupElement);