// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_components/composebox/composebox.js";import"./onboarding_tooltip.js";import{ComposeboxProxyImpl}from"//resources/cr_components/composebox/composebox_proxy.js";import{GlowAnimationState}from"//resources/cr_components/search/constants.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./composebox.css.js";import{getHtml}from"./composebox.html.js";export class ContextualTasksComposeboxElement extends CrLitElement{static get is(){return"contextual-tasks-composebox"}static get styles(){return getCss()}static get properties(){return{isZeroState:{type:Boolean,reflect:true},isSidePanel:{type:Boolean,reflect:true},isLensOverlayShowing:{type:Boolean,reflect:true},composeboxHeight_:{type:Number},composeboxDropdownHeight_:{type:Number},isComposeboxFocused_:{type:Boolean,reflect:true},showContextMenu_:{type:Boolean,value:loadTimeData.getBoolean("composeboxShowContextMenu")},tabSuggestions_:{type:Array},showOnboardingTooltip_:{type:Boolean,value:loadTimeData.getBoolean("showOnboardingTooltip")}}}#isZeroState_accessor_storage=false;get isZeroState(){return this.#isZeroState_accessor_storage}set isZeroState(value){this.#isZeroState_accessor_storage=value}#isSidePanel_accessor_storage=false;get isSidePanel(){return this.#isSidePanel_accessor_storage}set isSidePanel(value){this.#isSidePanel_accessor_storage=value}#isLensOverlayShowing_accessor_storage=false;get isLensOverlayShowing(){return this.#isLensOverlayShowing_accessor_storage}set isLensOverlayShowing(value){this.#isLensOverlayShowing_accessor_storage=value}#composeboxHeight__accessor_storage=0;get composeboxHeight_(){return this.#composeboxHeight__accessor_storage}set composeboxHeight_(value){this.#composeboxHeight__accessor_storage=value}#composeboxDropdownHeight__accessor_storage=0;get composeboxDropdownHeight_(){return this.#composeboxDropdownHeight__accessor_storage}set composeboxDropdownHeight_(value){this.#composeboxDropdownHeight__accessor_storage=value}#isComposeboxFocused__accessor_storage=false;get isComposeboxFocused_(){return this.#isComposeboxFocused__accessor_storage}set isComposeboxFocused_(value){this.#isComposeboxFocused__accessor_storage=value}#showContextMenu__accessor_storage=loadTimeData.getBoolean("composeboxShowContextMenu");get showContextMenu_(){return this.#showContextMenu__accessor_storage}set showContextMenu_(value){this.#showContextMenu__accessor_storage=value}#tabSuggestions__accessor_storage=[];get tabSuggestions_(){return this.#tabSuggestions__accessor_storage}set tabSuggestions_(value){this.#tabSuggestions__accessor_storage=value}#showOnboardingTooltip__accessor_storage=loadTimeData.getBoolean("showOnboardingTooltip");get showOnboardingTooltip_(){return this.#showOnboardingTooltip__accessor_storage}set showOnboardingTooltip_(value){this.#showOnboardingTooltip__accessor_storage=value}eventTracker_=new EventTracker;searchboxCallbackRouter_;searchboxHandler_;searchboxListenerIds_=[];onboardingTooltipIsVisible_=false;numberOfTimesTooltipShown_=0;maximumTimesTooltipShown_=loadTimeData.getInteger("composeboxShowOnboardingTooltipSessionImpressionCap");isOnboardingTooltipDismissCountBelowCap_=loadTimeData.getBoolean("isOnboardingTooltipDismissCountBelowCap");userDismissedTooltip_=false;resizeObserver_=null;tooltipImpressionTimer_=null;tooltipImpressionDelay_=loadTimeData.getInteger("composeboxShowOnboardingTooltipImpressionDelay");constructor(){super();this.searchboxCallbackRouter_=ComposeboxProxyImpl.getInstance().searchboxCallbackRouter;this.searchboxHandler_=ComposeboxProxyImpl.getInstance().searchboxHandler}connectedCallback(){super.connectedCallback();this.searchboxListenerIds_.push(this.searchboxCallbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this)));this.refreshTabSuggestions_();const composebox=this.$.composebox;if(composebox){this.eventTracker_.add(composebox,"composebox-focus-in",(()=>{this.isComposeboxFocused_=true}));this.eventTracker_.add(composebox,"composebox-focus-out",(()=>{this.isComposeboxFocused_=false;if(composebox.animationState===GlowAnimationState.SUBMITTING||composebox.animationState===GlowAnimationState.LISTENING){return}composebox.animationState=GlowAnimationState.NONE}));this.eventTracker_.add(composebox,"composebox-submit",(()=>{this.clearInputAndFocus(true)}));this.eventTracker_.add(composebox,"composebox-resize",(e=>{if(e.detail.carouselHeight!==undefined){composebox.style.setProperty("--carousel-height",`${e.detail.carouselHeight}px`);this.updateTooltipVisibility_()}if(e.detail.height!==undefined){this.composeboxHeight_=e.detail.height}}));this.eventTracker_.add(composebox.getDropTarget(),"on-context-files-changed",(()=>{this.updateTooltipVisibility_()}));this.updateTooltipVisibility_();this.resizeObserver_=new ResizeObserver((()=>{this.composeboxHeight_=composebox.offsetHeight}));this.resizeObserver_.observe(composebox)}}updateTooltipVisibility_(){if(!loadTimeData.getBoolean("showOnboardingTooltip")){return}const tooltip=this.$.onboardingTooltip;if(!tooltip){return}if(this.onboardingTooltipIsVisible_&&!this.$.composebox.getHasAutomaticActiveTabChipToken()){tooltip.hide();this.onboardingTooltipIsVisible_=false;this.stopObservingResize_();this.clearTooltipImpressionTimer_()}else if(this.$.composebox.getHasAutomaticActiveTabChipToken()){const target=this.$.composebox.getAutomaticActiveTabChipElement();if(target){tooltip.target=target}if(this.onboardingTooltipIsVisible_){tooltip.updatePosition()}else if(this.shouldShowOnboardingTooltip()){tooltip.show();this.startObservingResize_(target);this.onboardingTooltipIsVisible_=true;this.tooltipImpressionTimer_=setTimeout((()=>{this.numberOfTimesTooltipShown_++;this.tooltipImpressionTimer_=null}),this.tooltipImpressionDelay_)}}tooltip.shouldShow=this.onboardingTooltipIsVisible_}shouldShowOnboardingTooltip(){return this.showOnboardingTooltip_&&this.numberOfTimesTooltipShown_<this.maximumTimesTooltipShown_&&this.isOnboardingTooltipDismissCountBelowCap_&&!this.userDismissedTooltip_}onTooltipDismissed_(){this.userDismissedTooltip_=true;this.onboardingTooltipIsVisible_=false;this.stopObservingResize_();this.clearTooltipImpressionTimer_()}clearTooltipImpressionTimer_(){if(this.tooltipImpressionTimer_){clearTimeout(this.tooltipImpressionTimer_);this.tooltipImpressionTimer_=null}}disconnectedCallback(){super.disconnectedCallback();this.clearTooltipImpressionTimer_();this.stopObservingResize_();if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}this.eventTracker_.removeAll();this.searchboxListenerIds_.forEach((id=>assert(this.searchboxCallbackRouter_.removeListener(id))));this.searchboxListenerIds_=[]}render(){return getHtml.bind(this)()}async refreshTabSuggestions_(){const{tabs:tabs}=await this.searchboxHandler_.getRecentTabs();this.tabSuggestions_=[...tabs];this.updateTooltipVisibility_()}clearInputAndFocus(querySubmitted=false){this.$.composebox.clearAllInputs(querySubmitted);this.$.composebox.focusInput();this.$.composebox.clearAutocompleteMatches()}startExpandAnimation(){const composebox=this.$.composebox;composebox.animationState=GlowAnimationState.NONE;composebox.animationState=GlowAnimationState.EXPANDING}startObservingResize_(target){if(this.resizeObserver_){this.resizeObserver_.disconnect()}this.resizeObserver_=new ResizeObserver((()=>{const tooltip=this.$.onboardingTooltip;if(tooltip&&tooltip.target){tooltip.updatePosition()}}));this.resizeObserver_.observe(this.$.composebox);if(target){this.resizeObserver_.observe(target)}}stopObservingResize_(){if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}get isComposeboxFocusedForTesting(){return this.isComposeboxFocused_}get composeboxHeightForTesting(){return this.composeboxHeight_}get numberOfTimesTooltipShownForTesting(){return this.numberOfTimesTooltipShown_}set numberOfTimesTooltipShownForTesting(n){this.numberOfTimesTooltipShown_=n}set userDismissedTooltipForTesting(dismissed){this.userDismissedTooltip_=dismissed}updateTooltipVisibilityForTesting(){this.updateTooltipVisibility_()}}customElements.define(ContextualTasksComposeboxElement.is,ContextualTasksComposeboxElement);