// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./composebox.js";import"./error_page.js";import"./top_toolbar.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{BrowserProxyImpl}from"./contextual_tasks_browser_proxy.js";import{PostMessageHandler}from"./post_message_handler.js";const VIEWPORT_HEIGHT_KEY="bih";const VIEWPORT_WIDTH_KEY="biw";function updateTaskDetailsInUrl(taskId,threadId,turnId){const url=new URL(window.location.href);url.searchParams.set("task",taskId.value);threadId?url.searchParams.set("thread",threadId):url.searchParams.delete("thread");turnId?url.searchParams.set("turn",turnId):url.searchParams.delete("turn");window.history.replaceState({},"",url.href)}function updateTitleInUrl(title){const url=new URL(window.location.href);url.searchParams.set("title",title);window.history.replaceState({},"",url.href)}function embeddedUrlHasThreadParams(url){return url.searchParams.has("mstk")&&url.searchParams.has("mtid")&&url.searchParams.has("q")}function webUiUrlHasThreadParams(url){return url.searchParams.has("thread")&&url.searchParams.has("turn")&&url.searchParams.has("title")}function applyWebUiParamsToThreadUrl(threadUrl,webUiUrl){threadUrl.searchParams.set("mtid",webUiUrl.searchParams.get("thread")||"");threadUrl.searchParams.set("mstk",webUiUrl.searchParams.get("turn")||"");threadUrl.searchParams.set("q",webUiUrl.searchParams.get("title")||"")}export class ContextualTasksAppElement extends CrLitElement{static get is(){return"contextual-tasks-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{isShownInTab_:{type:Boolean,reflect:true},threadTitle_:{type:String},contextTabs_:{type:Array},darkMode_:{type:Boolean,reflect:true},isErrorPageVisible_:{type:Boolean,reflect:true},isInBasicMode_:{type:Boolean,reflect:true},isZeroState_:{type:Boolean,reflect:true},isAiPage_:{type:Boolean,reflect:true},isLensOverlayShowing_:{type:Boolean}}}browserProxy_=BrowserProxyImpl.getInstance();#isAiPage__accessor_storage=true;get isAiPage_(){return this.#isAiPage__accessor_storage}set isAiPage_(value){this.#isAiPage__accessor_storage=value}#isLensOverlayShowing__accessor_storage=false;get isLensOverlayShowing_(){return this.#isLensOverlayShowing__accessor_storage}set isLensOverlayShowing_(value){this.#isLensOverlayShowing__accessor_storage=value}#isShownInTab__accessor_storage=true;get isShownInTab_(){return this.#isShownInTab__accessor_storage}set isShownInTab_(value){this.#isShownInTab__accessor_storage=value}#darkMode__accessor_storage=loadTimeData.getBoolean("darkMode");get darkMode_(){return this.#darkMode__accessor_storage}set darkMode_(value){this.#darkMode__accessor_storage=value}pendingUrl_="";#threadTitle__accessor_storage="";get threadTitle_(){return this.#threadTitle__accessor_storage}set threadTitle_(value){this.#threadTitle__accessor_storage=value}#contextTabs__accessor_storage=[];get contextTabs_(){return this.#contextTabs__accessor_storage}set contextTabs_(value){this.#contextTabs__accessor_storage=value}#isInBasicMode__accessor_storage=false;get isInBasicMode_(){return this.#isInBasicMode__accessor_storage}set isInBasicMode_(value){this.#isInBasicMode__accessor_storage=value}#isErrorPageVisible__accessor_storage=false;get isErrorPageVisible_(){return this.#isErrorPageVisible__accessor_storage}set isErrorPageVisible_(value){this.#isErrorPageVisible__accessor_storage=value}#isZeroState__accessor_storage=false;get isZeroState_(){return this.#isZeroState__accessor_storage}set isZeroState_(value){this.#isZeroState__accessor_storage=value}friendlyZeroStateSubtitle=loadTimeData.getString("friendlyZeroStateSubtitle");friendlyZeroStateTitle=loadTimeData.getString("friendlyZeroStateTitle");listenerIds_=[];oauthToken_=null;commonSearchParams_={};postMessageHandler_;forcedEmbeddedPageHost=loadTimeData.getString("forcedEmbeddedPageHost");signInDomains_=loadTimeData.getString("contextualTasksSignInDomains").split(",");firstUpdated(){this.postMessageHandler_=new PostMessageHandler(this.$.threadFrame,this.browserProxy_)}async onNewThreadClick_(){chrome.metricsPrivate.recordUserAction("ContextualTasks.WebUI.UserAction.OpenNewThread");chrome.metricsPrivate.recordBoolean("ContextualTasks.WebUI.UserAction.OpenNewThread",true);const{url:url}=await this.browserProxy_.handler.getThreadUrl();this.$.threadFrame.src=url.url;this.$.composebox.startExpandAnimation();this.$.composebox.clearInputAndFocus()}async connectedCallback(){super.connectedCallback();const webUiUrlOnLoad=new URL(window.location.href);const callbackRouter=this.browserProxy_.callbackRouter;this.listenerIds_=[callbackRouter.onSidePanelStateChanged.addListener((()=>this.updateSidePanelState())),callbackRouter.setThreadTitle.addListener((title=>{this.threadTitle_=title;updateTitleInUrl(title);document.title=title||loadTimeData.getString("title")})),callbackRouter.onAiPageStatusChanged.addListener((isAiPage=>{this.isAiPage_=isAiPage})),callbackRouter.postMessageToWebview.addListener(this.postMessageToWebview.bind(this)),callbackRouter.onHandshakeComplete.addListener(this.onHandshakeComplete.bind(this)),callbackRouter.onContextUpdated.addListener((tabs=>{this.contextTabs_=tabs})),callbackRouter.setOAuthToken.addListener((oauthToken=>{this.oauthToken_=oauthToken;this.maybeLoadPendingUrl_()})),callbackRouter.hideInput.addListener((()=>{this.isInBasicMode_=true})),callbackRouter.restoreInput.addListener((()=>{this.isInBasicMode_=false})),callbackRouter.setTaskDetails.addListener(updateTaskDetailsInUrl),callbackRouter.onZeroStateChange.addListener((isZeroState=>{this.isZeroState_=isZeroState})),callbackRouter.onLensOverlayStateChanged.addListener((isOverlayShowing=>{this.isLensOverlayShowing_=isOverlayShowing})),callbackRouter.showErrorPage.addListener((()=>{this.isErrorPageVisible_=true})),callbackRouter.hideErrorPage.addListener((()=>{this.isErrorPageVisible_=false}))];this.updateSidePanelState();this.updateCommonSearchParams();this.setupWebviewRequestOverrides();const taskUuid=webUiUrlOnLoad.searchParams.get("task");let threadUrl="";if(taskUuid){const{url:url}=await this.browserProxy_.handler.getUrlForTask({value:taskUuid});this.browserProxy_.handler.setTaskId({value:taskUuid});const aiPageParams=new URLSearchParams(new URL(url.url).search);this.browserProxy_.handler.setThreadTitle(aiPageParams.get("q")||"");threadUrl=url.url}else{const{url:url}=await this.browserProxy_.handler.getThreadUrl();threadUrl=url.url;this.$.composebox.clearInputAndFocus()}const threadUrlAsUrl=new URL(threadUrl);if(webUiUrlOnLoad.searchParams.has("open_history")){threadUrlAsUrl.searchParams.set("atvm","1");const url=new URL(window.location.href);url.searchParams.delete("open_history");window.history.replaceState({},"",url.href)}const{isZeroState:isZeroState}=await this.browserProxy_.handler.isZeroState({url:threadUrlAsUrl.href});this.isZeroState_=isZeroState;this.pendingUrl_=this.maybeUpdateThreadUrlForRestore(threadUrlAsUrl,webUiUrlOnLoad);this.maybeLoadPendingUrl_()}disconnectedCallback(){super.disconnectedCallback();this.listenerIds_.forEach((id=>this.browserProxy_.callbackRouter.removeListener(id)));this.$.threadFrame.request.onBeforeSendHeaders.removeListener(this.onBeforeSendHeaders);this.$.threadFrame.request.onBeforeRequest.removeListener(this.onBeforeRequest)}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("isShownInTab_")){this.updateCommonSearchParams()}}maybeUpdateThreadUrlForRestore(threadUrl,webUiUrl){const updatedThreadUrl=new URL(threadUrl.href);const threadUrlHasParams=embeddedUrlHasThreadParams(updatedThreadUrl);const webUiUrlHasParams=webUiUrlHasThreadParams(webUiUrl);if(!threadUrlHasParams&&webUiUrlHasParams){applyWebUiParamsToThreadUrl(updatedThreadUrl,webUiUrl);this.threadTitle_=webUiUrl.searchParams.get("title")||loadTimeData.getString("title");document.title=this.threadTitle_}return updatedThreadUrl.href}postMessageToWebview(message){this.postMessageHandler_.sendMessage(new Uint8Array(message))}maybeLoadPendingUrl_(){if(this.pendingUrl_&&this.commonSearchParams_&&this.oauthToken_!=null){this.$.threadFrame.src=this.pendingUrl_;this.pendingUrl_=""}}onHandshakeComplete(){this.postMessageHandler_.completeHandshake()}async updateSidePanelState(){const{isInTab:isInTab}=await this.browserProxy_.handler.isShownInTab();this.isShownInTab_=isInTab}async updateCommonSearchParams(){const{params:params}=await this.browserProxy_.handler.getCommonSearchParams(this.darkMode_,!this.isShownInTab_);this.commonSearchParams_=params;this.maybeLoadPendingUrl_()}setupWebviewRequestOverrides(){this.$.threadFrame.request.onBeforeSendHeaders.addListener(this.onBeforeSendHeaders,{types:"main_frame,xmlhttprequest,websocket".split(","),urls:["<all_urls>"]},["blocking","requestHeaders","extraHeaders"]);this.$.threadFrame.request.onBeforeRequest.addListener(this.onBeforeRequest,{types:["main_frame"],urls:["<all_urls>"]},["blocking"]);const userAgent=this.$.threadFrame.getUserAgent();const userAgentSuffix=loadTimeData.getString("userAgentSuffix");this.$.threadFrame.setUserAgentOverride(`${userAgent} ${userAgentSuffix}`)}addCommonSearchParams(url){for(const[key,value]of Object.entries(this.commonSearchParams_)){if(value===""){url.searchParams.delete(key)}else{url.searchParams.set(key,value)}}const resultsBoundingRect=this.$.threadFrame.getBoundingClientRect();if(resultsBoundingRect.width>0){url.searchParams.set(VIEWPORT_WIDTH_KEY,resultsBoundingRect.width.toString())}if(resultsBoundingRect.height>0){url.searchParams.set(VIEWPORT_HEIGHT_KEY,resultsBoundingRect.height.toString())}return url}onBeforeRequest=details=>{const url=new URL(details.url);const newUrl=this.addCommonSearchParams(url);const isSigninDomain=!!this.signInDomains_.find((domain=>domain===url.host));if(this.forcedEmbeddedPageHost&&!isSigninDomain){newUrl.host=this.forcedEmbeddedPageHost}if(newUrl.href!==details.url){return{redirectUrl:newUrl.href}}return{}};onBeforeSendHeaders=details=>{const requestHeaders=details.requestHeaders||[];requestHeaders.push({name:"Authorization",value:`Bearer ${this.oauthToken_}`});return{requestHeaders:requestHeaders}};getPendingUrlForTesting(){return this.pendingUrl_}}customElements.define(ContextualTasksAppElement.is,ContextualTasksAppElement);