// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';






export const KeyManagerInitializedValueSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum KeyManagerInitializedValue {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  UNSUPPORTED = 0,
  KEY_LOADED = 1,
  NO_KEY = 2,
}

export const KeyTrustLevelSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum KeyTrustLevel {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  UNSPECIFIED = 0,
  HW = 1,
  OS = 2,
  OS_SOFTWARE = 3,
}

export const KeyTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum KeyType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  UNKNOWN = 0,
  RSA = 1,
  EC = 2,
}

export const KeyManagerPermanentFailureSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum KeyManagerPermanentFailure {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  UNSPECIFIED = 0,
  CREATION_UPLOAD_CONFLICT = 1,
  INSUFFICIENT_PERMISSIONS = 2,
  OS_RESTRICTION = 3,
  INVALID_INSTALLATION = 4,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'connectors_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getDeviceTrustState(): Promise<{
        state: DeviceTrustState, }>;
  deleteDeviceTrustKey(): Promise<void>;
  getClientCertificateState(): Promise<{
        state: ClientCertificateState, }>;
  getSignalsReportingState(): Promise<{
        state: SignalsReportingState, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDeviceTrustState(): Promise<{
        state: DeviceTrustState, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetDeviceTrustState_ParamsSpec.$,
        PageHandler_GetDeviceTrustState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  deleteDeviceTrustKey(): Promise<void> {
    return this.proxy.sendMessage(
        1,
        PageHandler_DeleteDeviceTrustKey_ParamsSpec.$,
        PageHandler_DeleteDeviceTrustKey_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getClientCertificateState(): Promise<{
        state: ClientCertificateState, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetClientCertificateState_ParamsSpec.$,
        PageHandler_GetClientCertificateState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getSignalsReportingState(): Promise<{
        state: SignalsReportingState, }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_GetSignalsReportingState_ParamsSpec.$,
        PageHandler_GetSignalsReportingState_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetDeviceTrustState_ParamsSpec.$,
        PageHandler_GetDeviceTrustState_ResponseParamsSpec.$,
        impl.getDeviceTrustState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_DeleteDeviceTrustKey_ParamsSpec.$,
        PageHandler_DeleteDeviceTrustKey_ResponseParamsSpec.$,
        impl.deleteDeviceTrustKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetClientCertificateState_ParamsSpec.$,
        PageHandler_GetClientCertificateState_ResponseParamsSpec.$,
        impl.getClientCertificateState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetSignalsReportingState_ParamsSpec.$,
        PageHandler_GetSignalsReportingState_ResponseParamsSpec.$,
        impl.getSignalsReportingState.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "connectors_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDeviceTrustState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteDeviceTrustKey: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getClientCertificateState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSignalsReportingState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDeviceTrustState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetDeviceTrustState_ParamsSpec.$,
        PageHandler_GetDeviceTrustState_ResponseParamsSpec.$,
        this.getDeviceTrustState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteDeviceTrustKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_DeleteDeviceTrustKey_ParamsSpec.$,
        PageHandler_DeleteDeviceTrustKey_ResponseParamsSpec.$,
        this.deleteDeviceTrustKey.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getClientCertificateState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetClientCertificateState_ParamsSpec.$,
        PageHandler_GetClientCertificateState_ResponseParamsSpec.$,
        this.getClientCertificateState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getSignalsReportingState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetSignalsReportingState_ParamsSpec.$,
        PageHandler_GetSignalsReportingState_ResponseParamsSpec.$,
        this.getSignalsReportingState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const Int32ValueSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LoadedKeyInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const KeyInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ConsentMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DeviceTrustStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ClientIdentitySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ClientCertificateStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SignalsReportingStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeviceTrustState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeviceTrustState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteDeviceTrustKey_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteDeviceTrustKey_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetClientCertificateState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetClientCertificateState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetSignalsReportingState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetSignalsReportingState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const KeyUploadStatusSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface Int32ValueMojoType {
  value: number;
}


export type Int32Value = Int32ValueMojoType;
mojo.internal.Struct<Int32ValueMojoType>(
    Int32ValueSpec.$,
    'Int32Value',
    [
      mojo.internal.StructField<Int32ValueMojoType, number>(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LoadedKeyInfoMojoType {
  trustLevel: KeyTrustLevel;
  keyType: KeyType;
  encodedSpkiHash: string;
  keyUploadStatus: (KeyUploadStatus | null);
  hasSslKey: boolean;
}


export type LoadedKeyInfo = LoadedKeyInfoMojoType;
mojo.internal.Struct<LoadedKeyInfoMojoType>(
    LoadedKeyInfoSpec.$,
    'LoadedKeyInfo',
    [
      mojo.internal.StructField<LoadedKeyInfoMojoType, KeyTrustLevel>(
        'trustLevel', 0,
        0,
        KeyTrustLevelSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadedKeyInfoMojoType, KeyType>(
        'keyType', 4,
        0,
        KeyTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadedKeyInfoMojoType, string>(
        'encodedSpkiHash', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadedKeyInfoMojoType, KeyUploadStatus>(
        'keyUploadStatus', 16,
        0,
        KeyUploadStatusSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LoadedKeyInfoMojoType, boolean>(
        'hasSslKey', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface KeyInfoMojoType {
  isKeyManagerInitialized: KeyManagerInitializedValue;
  permanentFailure: KeyManagerPermanentFailure;
  loadedKeyInfo: (LoadedKeyInfo | null);
}


export type KeyInfo = KeyInfoMojoType;
mojo.internal.Struct<KeyInfoMojoType>(
    KeyInfoSpec.$,
    'KeyInfo',
    [
      mojo.internal.StructField<KeyInfoMojoType, KeyManagerInitializedValue>(
        'isKeyManagerInitialized', 0,
        0,
        KeyManagerInitializedValueSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<KeyInfoMojoType, LoadedKeyInfo>(
        'loadedKeyInfo', 8,
        0,
        LoadedKeyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<KeyInfoMojoType, KeyManagerPermanentFailure>(
        'permanentFailure', 4,
        0,
        KeyManagerPermanentFailureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ConsentMetadataMojoType {
  canCollectSignals: boolean;
  consentReceived: boolean;
}


export type ConsentMetadata = ConsentMetadataMojoType;
mojo.internal.Struct<ConsentMetadataMojoType>(
    ConsentMetadataSpec.$,
    'ConsentMetadata',
    [
      mojo.internal.StructField<ConsentMetadataMojoType, boolean>(
        'canCollectSignals', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConsentMetadataMojoType, boolean>(
        'consentReceived', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DeviceTrustStateMojoType {
  isEnabled: boolean;
  policyEnabledLevels: string[];
  keyInfo: KeyInfo;
  signalsJson: string;
  consentMetadata: (ConsentMetadata | null);
}


export type DeviceTrustState = DeviceTrustStateMojoType;
mojo.internal.Struct<DeviceTrustStateMojoType>(
    DeviceTrustStateSpec.$,
    'DeviceTrustState',
    [
      mojo.internal.StructField<DeviceTrustStateMojoType, boolean>(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceTrustStateMojoType, string[]>(
        'policyEnabledLevels', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceTrustStateMojoType, KeyInfo>(
        'keyInfo', 16,
        0,
        KeyInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceTrustStateMojoType, string>(
        'signalsJson', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceTrustStateMojoType, ConsentMetadata>(
        'consentMetadata', 32,
        0,
        ConsentMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface CertificateMetadataMojoType {
  serialNumber: string;
  fingerprint: string;
  creationDateString: string;
  expirationDateString: string;
  subjectDisplayName: string;
  issuerDisplayName: string;
}


export type CertificateMetadata = CertificateMetadataMojoType;
mojo.internal.Struct<CertificateMetadataMojoType>(
    CertificateMetadataSpec.$,
    'CertificateMetadata',
    [
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'serialNumber', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'fingerprint', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'creationDateString', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'expirationDateString', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'subjectDisplayName', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateMetadataMojoType, string>(
        'issuerDisplayName', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface ClientIdentityMojoType {
  identityName: string;
  loadedKeyInfo: (LoadedKeyInfo | null);
  certificateMetadata: (CertificateMetadata | null);
}


export type ClientIdentity = ClientIdentityMojoType;
mojo.internal.Struct<ClientIdentityMojoType>(
    ClientIdentitySpec.$,
    'ClientIdentity',
    [
      mojo.internal.StructField<ClientIdentityMojoType, string>(
        'identityName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientIdentityMojoType, LoadedKeyInfo>(
        'loadedKeyInfo', 8,
        0,
        LoadedKeyInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientIdentityMojoType, CertificateMetadata>(
        'certificateMetadata', 16,
        0,
        CertificateMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ClientCertificateStateMojoType {
  policyEnabledLevels: string[];
  managedProfileIdentity: (ClientIdentity | null);
  managedBrowserIdentity: (ClientIdentity | null);
}


export type ClientCertificateState = ClientCertificateStateMojoType;
mojo.internal.Struct<ClientCertificateStateMojoType>(
    ClientCertificateStateSpec.$,
    'ClientCertificateState',
    [
      mojo.internal.StructField<ClientCertificateStateMojoType, string[]>(
        'policyEnabledLevels', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientCertificateStateMojoType, ClientIdentity>(
        'managedProfileIdentity', 8,
        0,
        ClientIdentitySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientCertificateStateMojoType, ClientIdentity>(
        'managedBrowserIdentity', 16,
        0,
        ClientIdentitySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SignalsReportingStateMojoType {
  errorInfo: (string | null);
  statusReportEnabled: boolean;
  signalsReportEnabled: boolean;
  canCollectAllFields: boolean;
  lastUploadAttemptTimestamp: string;
  lastUploadSuccessTimestamp: string;
  lastSignalsUploadConfig: string;
}


export type SignalsReportingState = SignalsReportingStateMojoType;
mojo.internal.Struct<SignalsReportingStateMojoType>(
    SignalsReportingStateSpec.$,
    'SignalsReportingState',
    [
      mojo.internal.StructField<SignalsReportingStateMojoType, string>(
        'errorInfo', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, boolean>(
        'statusReportEnabled', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, boolean>(
        'signalsReportEnabled', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, string>(
        'lastUploadAttemptTimestamp', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, string>(
        'lastUploadSuccessTimestamp', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, string>(
        'lastSignalsUploadConfig', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SignalsReportingStateMojoType, boolean>(
        'canCollectAllFields', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface PageHandler_GetDeviceTrustState_ParamsMojoType {
}


export type PageHandler_GetDeviceTrustState_Params = PageHandler_GetDeviceTrustState_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeviceTrustState_ParamsMojoType>(
    PageHandler_GetDeviceTrustState_ParamsSpec.$,
    'PageHandler_GetDeviceTrustState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetDeviceTrustState_ResponseParamsMojoType {
  state: DeviceTrustState;
}


export type PageHandler_GetDeviceTrustState_ResponseParams = PageHandler_GetDeviceTrustState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeviceTrustState_ResponseParamsMojoType>(
    PageHandler_GetDeviceTrustState_ResponseParamsSpec.$,
    'PageHandler_GetDeviceTrustState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetDeviceTrustState_ResponseParamsMojoType, DeviceTrustState>(
        'state', 0,
        0,
        DeviceTrustStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeleteDeviceTrustKey_ParamsMojoType {
}


export type PageHandler_DeleteDeviceTrustKey_Params = PageHandler_DeleteDeviceTrustKey_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteDeviceTrustKey_ParamsMojoType>(
    PageHandler_DeleteDeviceTrustKey_ParamsSpec.$,
    'PageHandler_DeleteDeviceTrustKey_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_DeleteDeviceTrustKey_ResponseParamsMojoType {
}


export type PageHandler_DeleteDeviceTrustKey_ResponseParams = PageHandler_DeleteDeviceTrustKey_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteDeviceTrustKey_ResponseParamsMojoType>(
    PageHandler_DeleteDeviceTrustKey_ResponseParamsSpec.$,
    'PageHandler_DeleteDeviceTrustKey_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetClientCertificateState_ParamsMojoType {
}


export type PageHandler_GetClientCertificateState_Params = PageHandler_GetClientCertificateState_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetClientCertificateState_ParamsMojoType>(
    PageHandler_GetClientCertificateState_ParamsSpec.$,
    'PageHandler_GetClientCertificateState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetClientCertificateState_ResponseParamsMojoType {
  state: ClientCertificateState;
}


export type PageHandler_GetClientCertificateState_ResponseParams = PageHandler_GetClientCertificateState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetClientCertificateState_ResponseParamsMojoType>(
    PageHandler_GetClientCertificateState_ResponseParamsSpec.$,
    'PageHandler_GetClientCertificateState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetClientCertificateState_ResponseParamsMojoType, ClientCertificateState>(
        'state', 0,
        0,
        ClientCertificateStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetSignalsReportingState_ParamsMojoType {
}


export type PageHandler_GetSignalsReportingState_Params = PageHandler_GetSignalsReportingState_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetSignalsReportingState_ParamsMojoType>(
    PageHandler_GetSignalsReportingState_ParamsSpec.$,
    'PageHandler_GetSignalsReportingState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetSignalsReportingState_ResponseParamsMojoType {
  state: SignalsReportingState;
}


export type PageHandler_GetSignalsReportingState_ResponseParams = PageHandler_GetSignalsReportingState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetSignalsReportingState_ResponseParamsMojoType>(
    PageHandler_GetSignalsReportingState_ResponseParamsSpec.$,
    'PageHandler_GetSignalsReportingState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetSignalsReportingState_ResponseParamsMojoType, SignalsReportingState>(
        'state', 0,
        0,
        SignalsReportingStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    KeyUploadStatusSpec.$, 'KeyUploadStatus',
    {
      'syncKeyResponseCode': {
        'ordinal': 0,
        'type': Int32ValueSpec.$,
      },
      'uploadClientError': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

export interface KeyUploadStatus {
  syncKeyResponseCode?: Int32Value,
  uploadClientError?: string,
}

export enum KeyUploadStatusFieldTags {
  SYNC_KEY_RESPONSE_CODE,
  UPLOAD_CLIENT_ERROR,
}

export function whichKeyUploadStatus(u: KeyUploadStatus): KeyUploadStatusFieldTags {
  if (u.syncKeyResponseCode !== null && u.syncKeyResponseCode !== undefined) {
    return KeyUploadStatusFieldTags.SYNC_KEY_RESPONSE_CODE;
  }
  if (u.uploadClientError !== null && u.uploadClientError !== undefined) {
    return KeyUploadStatusFieldTags.UPLOAD_CLIENT_ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
