import 'chrome://resources/cr_elements/cr_auto_img/cr_auto_img.js';
import './description_section.js';
import './product_selector.js';
import './buying_options_section.js';
import './empty_section.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_hidden_style.css.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import './shared_vars.css.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { BuyingOptions } from './buying_options_section.js';
import type { ProductDescription } from './description_section.js';
import { DragAndDropManager } from './drag_and_drop_manager.js';
import type { SectionType } from './product_selection_menu.js';
import type { UrlListEntry } from './utils.js';
export type ContentOrNull = string | ProductDescription | BuyingOptions | null;
export interface ProductDetail {
    title: string | null;
    content: ContentOrNull;
}
export interface TableColumn {
    selectedItem: UrlListEntry;
    productDetails: ProductDetail[] | null;
}
export interface TableElement {
    $: {
        table: HTMLElement;
    };
}
export declare class TableElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        columns: {
            type: ArrayConstructor;
        };
        draggingColumn: {
            type: ObjectConstructor;
        };
        hoveredColumnIndex_: {
            type: NumberConstructor;
        };
    };
    accessor columns: TableColumn[];
    accessor draggingColumn: HTMLElement | null;
    private accessor hoveredColumnIndex_;
    private dragAndDropManager_;
    private shoppingApi_;
    constructor();
    getDragAndDropManager(): DragAndDropManager;
    updated(changedProperties: PropertyValues<this>): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    moveColumnOnDrop(fromIndex: number, dropIndex: number): Promise<void>;
    closeAllProductSelectionMenus(): void;
    protected isDragging_(columnIndex: number): boolean;
    protected isFirstColumn_(columnIndex: number): boolean | undefined;
    protected getScrollSnapAlign_(): string;
    protected getRowCount_(numProductDetails: number): number;
    protected getUrls_(): string[];
    protected onHideOpenTabButton_(): void;
    protected onShowOpenTabButton_(e: Event): void;
    protected showOpenTabButton_(columnIndex: number): boolean;
    protected onOpenTabButtonClick_(e: Event): void;
    protected onSelectedUrlChange_(e: CustomEvent<{
        url: string;
        urlSection: SectionType;
    }>): void;
    protected onUrlRemove_(e: Event): void;
    protected showRow_(title: string, rowIndex: number): boolean;
    private rowHasText_;
    private rowHasNonEmptyAttributes_;
    private rowHasNonEmptySummary_;
    private rowHasBuyingOptions_;
    protected filterProductDescription_(productDesc: ProductDescription, title: string, rowIndex: number): ProductDescription;
    protected contentIsString_(content: ContentOrNull): content is string;
    protected contentIsProductDescription_(content: ContentOrNull): content is ProductDescription;
    protected contentIsBuyingOptions_(content: ContentOrNull): content is BuyingOptions;
    protected getFavicon_(url: string): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'product-specifications-table': TableElement;
    }
}
