import 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import './product_selection_menu.js';
import type { CrUrlListItemElement } from 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ProductSelectionMenuElement } from './product_selection_menu.js';
import type { UrlListEntry } from './utils.js';
export interface ProductSelectorElement {
    $: {
        currentProduct: CrUrlListItemElement;
        currentProductContainer: HTMLElement;
        productSelectionMenu: ProductSelectionMenuElement;
    };
}
export declare class ProductSelectorElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        selectedItem: {
            type: ObjectConstructor;
        };
        excludedUrls: {
            type: ArrayConstructor;
        };
    };
    accessor selectedItem: UrlListEntry | null;
    accessor excludedUrls: string[];
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    closeMenu(): void;
    protected showMenu_(): void;
    protected onCloseMenu_(): void;
    protected onCurrentProductContainerKeyDown_(e: KeyboardEvent): void;
    protected getUrl_(item: UrlListEntry): string;
    protected getSelectedUrl_(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'product-selector': ProductSelectorElement;
    }
}
