import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
/**
 * @fileoverview
 * Navigates a `product-specifications-table` horizontally by one column width,
 * using forward and backward buttons.
 *
 * Prevents vertical scrolling by directly controlling horizontal scroll
 * position. Updates button visibility using `IntersectionObserver` to detect if
 * either end of the container has been reached.
 *
 * Relies on CSS scroll-snap properties for precise column alignment:
 *  - `scroll-snap-type: x mandatory` on container
 *  - `scroll-snap-align: start` on `product-specifications-table`'s columns
 *
 * Note: Key differences between this HorizontalCarouselElement and the one
 * located at ui/webui/resources/cr_components/history_clusters.
 *    - This carousel considers the width of its slotted children, and uses
 * CSS scroll-snap properties to enable fine-grained control over how much
 * content is shown/hidden at once.
 *    - The other carousel bases its scrolling on the container's width, making
 * it less suitable for cases where precise content control is needed.
 */
export interface HorizontalCarouselElement {
    $: {
        backButton: HTMLElement;
        backButtonContainer: HTMLElement;
        carouselContainer: HTMLElement;
        endProbe: HTMLElement;
        forwardButton: HTMLElement;
        forwardButtonContainer: HTMLElement;
        slottedTable: HTMLSlotElement;
        startProbe: HTMLElement;
    };
}
export declare class HorizontalCarouselElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * True if slotted table is overflown, regardless of any elements that may
         * appear before or after it.
         */
        canScroll_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
           True if slotted table is overflown on the left side of the carousel.
         */
        showBackButton_: {
            type: BooleanConstructor;
        };
        /**
           True if slotted table is overflown on the right side of the carousel.
         */
        showForwardButton: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    accessor showForwardButton: boolean;
    protected accessor canScroll_: boolean;
    protected accessor showBackButton_: boolean;
    private intersectionObserver_;
    private resizeObserver_;
    private scrolledToEnd_;
    private scrolledToStart_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    protected onCarouselBackClick_(): void;
    protected onCarouselForwardClick_(): void;
    private createIntersectionObserver_;
    private createResizeObserver_;
    private get columnOffsetWidth_();
}
declare global {
    interface HTMLElementTagNameMap {
        'horizontal-carousel': HorizontalCarouselElement;
    }
}
