// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import './images/icons.html.js';
import { AnchorAlignment } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './header_menu.css.js';
import { getHtml } from './header_menu.html.js';
export class HeaderMenuElement extends CrLitElement {
    static get is() {
        return 'header-menu';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    showAt(element) {
        const rect = element.getBoundingClientRect();
        const verticalOffsetPx = 4;
        this.$.menu.get().showAt(element, {
            anchorAlignmentX: AnchorAlignment.BEFORE_END,
            top: rect.bottom + verticalOffsetPx,
            left: rect.left,
        });
    }
    close() {
        this.$.menu.get().close();
    }
    onRenameClick_() {
        this.close();
        this.dispatchEvent(new CustomEvent('rename-click', {
            bubbles: true,
            composed: true,
        }));
    }
    onSeeAllClick_() {
        this.close();
        this.dispatchEvent(new CustomEvent('see-all-click', {
            bubbles: true,
            composed: true,
        }));
    }
    onDeleteClick_() {
        this.close();
        this.dispatchEvent(new CustomEvent('delete-click', {
            bubbles: true,
            composed: true,
        }));
    }
}
customElements.define(HeaderMenuElement.is, HeaderMenuElement);
