import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import './header_menu.js';
import type { CrIconButtonElement } from 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { HeaderMenuElement } from './header_menu.js';
export interface HeaderElement {
    $: {
        divider: HTMLElement;
        menuButton: CrIconButtonElement;
        menu: HeaderMenuElement;
    };
}
export declare class HeaderElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        disabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isPageTitleClickable: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        subtitle: {
            type: StringConstructor;
            reflect: boolean;
        };
        maxNameLength_: {
            type: NumberConstructor;
        };
        showingMenu_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        showingInput_: {
            type: BooleanConstructor;
        };
    };
    accessor disabled: boolean;
    accessor isPageTitleClickable: boolean;
    accessor subtitle: string | null;
    protected accessor showingMenu_: boolean;
    protected accessor showingInput_: boolean;
    protected accessor maxNameLength_: number;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected showMenu_(): void;
    protected onCloseMenu_(): void;
    private get input_();
    protected onRenaming_(): Promise<void>;
    protected onInputKeyDown_(event: KeyboardEvent): void;
    protected onInputBlur_(): void;
    protected onSubtitleKeyDown_(event: KeyboardEvent): void;
    protected onPageTitleClick_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'product-specifications-header': HeaderElement;
    }
}
