import './description_citation.js';
import './empty_section.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ProductSpecificationsDescriptionText } from './shopping_service.mojom-webui.js';
interface Attribute {
    label: string;
    value: string;
}
export interface ProductDescription {
    attributes: Attribute[];
    summary: ProductSpecificationsDescriptionText[];
}
export interface DescriptionSectionElement {
    $: {
        attributes: HTMLElement;
        summary: HTMLElement;
    };
}
export declare class DescriptionSectionElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    willUpdate(changedProperties: PropertyValues<this>): void;
    static get properties(): {
        citationCount: {
            type: NumberConstructor;
        };
        description: {
            type: ObjectConstructor;
        };
        productName: {
            type: StringConstructor;
        };
    };
    accessor description: ProductDescription;
    accessor productName: string;
    accessor citationCount: number;
    protected computeCitationIndex_(summaryIndex: number, urlIndex: number): number;
    protected summaryIsEmpty_(summary: ProductSpecificationsDescriptionText[]): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'description-section': DescriptionSectionElement;
    }
}
export {};
