import 'chrome://resources/cr_elements/cr_lazy_list/cr_lazy_list.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_toolbar/cr_toolbar_selection_overlay.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import './images/icons.html.js';
import './comparison_table_list_item.js';
import type { Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrIconButtonElement } from 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { CrLazyRenderLitElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import type { CrToolbarSelectionOverlayElement } from 'chrome://resources/cr_elements/cr_toolbar/cr_toolbar_selection_overlay.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ComparisonTableListItemCheckboxChangeEvent, ComparisonTableListItemDeleteEvent } from './comparison_table_list_item.js';
export interface ComparisonTableDetails {
    name: string;
    uuid: Uuid;
    urls: Url[];
}
export interface ComparisonTableListElement {
    $: {
        delete: CrIconButtonElement;
        edit: CrIconButtonElement;
        menu: CrLazyRenderLitElement<CrActionMenuElement>;
        more: CrIconButtonElement;
        toast: CrLazyRenderLitElement<CrToastElement>;
        toolbar: CrToolbarSelectionOverlayElement;
    };
}
export declare class ComparisonTableListElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        deletionToastDurationMs_: {
            type: NumberConstructor;
        };
        deletionToastMessage_: {
            type: StringConstructor;
        };
        isEditing_: {
            type: BooleanConstructor;
        };
        numSelected_: {
            type: NumberConstructor;
        };
        tables: {
            type: ArrayConstructor;
        };
        tablesPendingDeletion_: {
            type: ObjectConstructor;
        };
    };
    accessor tables: ComparisonTableDetails[];
    protected accessor deletionToastDurationMs_: number;
    protected accessor deletionToastMessage_: string;
    protected accessor isEditing_: boolean;
    protected accessor numSelected_: number;
    protected accessor tablesPendingDeletion_: Set<Uuid>;
    private deletionTimeoutId_;
    private pluralStringProxy_;
    private productSpecificationsProxy_;
    private selectedUuids_;
    private shoppingApi_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    resetDeletionToastDurationMsForTesting(): void;
    protected getTables_(tables: ComparisonTableDetails[], uuidsPendingDeletion: Set<Uuid>): ComparisonTableDetails[];
    protected getSelectionLabel_(numSelected: number): string;
    protected getOpenAllString_(numSelected: number): string;
    protected getOpenAllInNewWindowString_(numSelected: number): string;
    protected onEditClick_(): void;
    protected onClearClick_(): void;
    protected onDeleteClick_(): Promise<void>;
    protected onShowContextMenuClick_(): void;
    protected onOpenAllClick_(): void;
    protected onOpenAllInNewWindowClick_(): void;
    protected onUndoDeletionClick_(): void;
    protected onCheckboxChange_(event: ComparisonTableListItemCheckboxChangeEvent): void;
    protected onItemDelete_(event: ComparisonTableListItemDeleteEvent): void;
    protected stopEditing_(): void;
    private scheduleSelectedTablesForDeletion_;
    private deletePendingTables_;
    private updateDeletionToastMessage_;
    private cancelPendingDeletionTimeout_;
}
declare global {
    interface HTMLElementTagNameMap {
        'comparison-table-list': ComparisonTableListElement;
    }
}
