import '/strings.m.js';
import './header.js';
import './loading_state.js';
import './new_column_selector.js';
import './product_selector.js';
import './table.js';
import './horizontal_carousel.js';
import './comparison_table_list.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import 'chrome://resources/cr_elements/cr_hidden_style.css.js';
import 'chrome://resources/cr_elements/cr_loading_gradient/cr_loading_gradient.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import './shared_vars.css.js';
import type { ProductSpecificationsSet } from 'chrome://resources/cr_components/commerce/shared.mojom-webui.js';
import type { ProductSpecificationsFeatureState } from 'chrome://resources/cr_components/commerce/shopping_service.mojom-webui.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import { CrFeedbackOption } from 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Uuid } from 'chrome://resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import type { ComparisonTableListElement } from './comparison_table_list.js';
import type { ComparisonTableListItemClickEvent, ComparisonTableListItemRenameEvent } from './comparison_table_list_item.js';
import type { HeaderElement } from './header.js';
import type { NewColumnSelectorElement } from './new_column_selector.js';
import { SectionType } from './product_selection_menu.js';
import type { ProductSelectorElement } from './product_selector.js';
import type { TableColumn, TableElement } from './table.js';
interface LoadingState {
    loading: boolean;
    urlCount: number;
}
export interface ProductSpecificationsElement {
    $: {
        comparisonTableList: ComparisonTableListElement;
        contentContainer: HTMLElement;
        empty: HTMLElement;
        error: HTMLElement;
        errorToast: CrToastElement;
        header: HeaderElement;
        loading: HTMLElement;
        newColumnSelector: NewColumnSelectorElement;
        offlineToast: CrToastElement;
        productSelector: ProductSelectorElement;
        specs: HTMLElement;
        summaryContainer: HTMLElement;
        summaryTable: TableElement;
        syncPromo: HTMLElement;
        turnOnSyncButton: CrButtonElement;
    };
}
export declare enum CompareTableColumnAction {
    REMOVE = 0,
    CHANGE_ORDER_DRAG_AND_DROP = 1,
    ADD_FROM_SUGGESTED = 2,
    UPDATE_FROM_SUGGESTED = 3,
    ADD_FROM_RECENTLY_VIEWED = 4,
    UPDATE_FROM_RECENTLY_VIEWED = 5,
    MAX_VALUE = 6
}
export declare enum CompareTableLoadStatus {
    SUCCESS = 0,
    FAILURE = 1,
    FAILURE_EMPTY_TABLE_BACKEND = 2,
    FAILURE_EMPTY_TABLE_NON_PRODUCTS = 2,
    FAILURE_USER_NOT_ELIGIBLE = 3,
    FAILURE_OFFLINE = 4,
    MAX_VALUE = 5
}
export declare const COLUMN_MODIFICATION_HISTOGRAM_NAME: string;
export declare const TABLE_LOAD_HISTOGRAM_NAME: string;
export declare enum AppState {
    ERROR = 0,
    TABLE_EMPTY = 1,
    SYNC_SCREEN = 2,
    TABLE_POPULATED = 3,
    LOADING = 4,
    NO_CONTENT = 5
}
export declare const LOADING_START_EVENT_TYPE: string;
export declare const LOADING_END_EVENT_TYPE: string;
export declare class ProductSpecificationsElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        appState_: {
            type: ObjectConstructor;
        };
        id_: {
            type: ObjectConstructor;
        };
        sets_: {
            type: ArrayConstructor;
        };
        loadingState_: {
            type: ObjectConstructor;
        };
        productSpecificationsFeatureState_: {
            type: ObjectConstructor;
        };
        setName_: {
            type: StringConstructor;
        };
        showComparisonTableList_: {
            type: BooleanConstructor;
        };
        showEmptyState_: {
            type: BooleanConstructor;
        };
        showTableDataUnavailableContainer_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        tableColumns_: {
            type: ObjectConstructor;
        };
    };
    protected accessor appState_: AppState;
    protected accessor id_: Uuid | null;
    protected accessor loadingState_: LoadingState;
    protected accessor productSpecificationsFeatureState_: ProductSpecificationsFeatureState | null;
    protected accessor setName_: string | null;
    protected accessor sets_: ProductSpecificationsSet[];
    protected accessor showComparisonTableList_: boolean;
    private accessor showEmptyState_;
    protected accessor showTableDataUnavailableContainer_: boolean;
    protected accessor tableColumns_: TableColumn[];
    private callbackRouter_;
    private eventTracker_;
    private isWindowFocused_;
    private listenerIds_;
    private loadingAnimationSlideDurationMs_;
    private contentContainerIsHidden_;
    private minLoadingAnimationMs_;
    private pendingSetUpdate_;
    private productSpecificationsProxy_;
    private shoppingApi_;
    constructor();
    willUpdate(changedProperties: PropertyValues<this>): void;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
    resetLoadingAnimationMsForTesting(loadingAnimationMs?: number): void;
    focusWindowForTesting(): void;
    private loadTable_;
    private updateFeatureState_;
    private computeAppState_;
    private computeShowTableDataUnavailableContainer_;
    private computeShowComparisonTableList_;
    protected isHeaderEnabled_(): boolean;
    protected canShowFooter_(showTableDataUnavailableContainer: boolean, appState: AppState): boolean;
    protected canShowFeedbackButtons_(): boolean;
    protected showSyncSetupFlow_(): void;
    protected showOfflineToast_(): void;
    private populateTable_;
    private get isOffline_();
    private getProductInfoForUrls_;
    private aggregateProductDataByUrl_;
    private loadSet_;
    private deleteSet_;
    protected updateSetName_(e: CustomEvent<{
        name: string;
    }>): void;
    protected seeAllSets_(): void;
    protected onUrlAdd_(e: CustomEvent<{
        url: string;
        urlSection: SectionType;
    }>): Promise<void>;
    protected onUrlChange_(e: CustomEvent<{
        url: string;
        urlSection: SectionType;
        index: number;
    }>): void;
    protected onUrlOrderUpdate_(): void;
    protected onUrlRemove_(e: CustomEvent<{
        index: number;
    }>): void;
    private modifyUrls_;
    private createNewSet_;
    protected getTableUrls_(): string[];
    protected isTableFull_(): boolean;
    private onSetUpdated_;
    private updateSet_;
    private onSetRemoved_;
    protected onFeedbackSelectedOptionChanged_(e: CustomEvent<{
        value: CrFeedbackOption;
    }>): void;
    private onSetAdded_;
    protected getDisclaimerText_(): string;
    private hideContentContainer_;
    private showContentContainer_;
    private enterLoadingState_;
    private exitLoadingState_;
    private dispatchLoadingStartEvent_;
    private dispatchLoadingEndEvent_;
    private updateEmptyState_;
    protected onComparisonTableListItemClick_(event: ComparisonTableListItemClickEvent): void;
    protected onComparisonTableListItemRename_(event: ComparisonTableListItemRenameEvent): void;
    protected onHeaderMenuDeleteClick_(): void;
    private closeAllProductSelectionMenus_;
}
declare global {
    interface HTMLElementTagNameMap {
        'product-specifications-app': ProductSpecificationsElement;
    }
}
export {};
