// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{$$}from"./utils.js";export const IS_FIRST_COLUMN_ATTR="is-first-column";function getColumnByComposedPath(path){return path.filter((node=>node instanceof HTMLElement)).find((p=>p.classList.contains("col")))||null}function getVisualOrderIndex(col){assert(col.style.order!=="");return Number.parseInt(col.style.order,10)}export class DragAndDropManager{dragImage_;eventTracker_=new EventTracker;tableElement_;pendingOrder_=new Map;constructor(tableElement){this.dragImage_=new Image(1,1);this.dragImage_.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAA"+"ABAAEAAAICTAEAOw==";this.tableElement_=tableElement;this.eventTracker_.add(document,"dragstart",(e=>this.onDragStart_(e)))}get columnElements_(){const table=$$(this.tableElement_,"#table");assert(table);return Array.from(table.querySelectorAll(".col:not([hidden])"))}destroy(){this.eventTracker_.removeAll()}tablePropertiesUpdated(){if(this.pendingOrder_.size>0){this.pendingOrder_.forEach(((value,key)=>{const col=this.columnElements_[key];assert(col);col.style.order=`${value}`;col.style.position="relative";col.toggleAttribute(IS_FIRST_COLUMN_ATTR,value===0)}))}}syncVisualOrderWithDom(){this.columnElements_.forEach(((column,index)=>{column.toggleAttribute(IS_FIRST_COLUMN_ATTR,index===0);column.style.order=`${index}`;this.pendingOrder_.set(index,index)}))}resetVisualOrder(){this.pendingOrder_.clear();for(const column of this.columnElements_){column.style.order=""}}onDragStart_(e){if(e.dataTransfer){e.dataTransfer.setDragImage(this.dragImage_,0,0)}const dragElement=getColumnByComposedPath(e.composedPath());if(!dragElement){return}this.dragStart_(dragElement);this.eventTracker_.add(document,"dragover",(e=>this.dragOver_(e)));this.eventTracker_.add(document,"drop",(e=>this.drop_(e)));this.eventTracker_.add(this.tableElement_,"dragleave",(e=>this.drop_(e)));this.eventTracker_.add(document,"dragend",(()=>{this.eventTracker_.remove(document,"dragover");this.eventTracker_.remove(document,"drop");this.eventTracker_.remove(this.tableElement_,"dragleave");this.dragEnd_()}))}dragStart_(dragElement){this.columnElements_.forEach((column=>{column.style.position="relative"}));this.tableElement_.draggingColumn=dragElement;this.syncVisualOrderWithDom()}dragOver_(e){e.preventDefault();const dragElement=this.tableElement_.draggingColumn;if(!dragElement){return}const dropTarget=getColumnByComposedPath(e.composedPath());if(!dropTarget){return}const fromIndex=getVisualOrderIndex(dragElement);const toIndex=getVisualOrderIndex(dropTarget);if(toIndex!==fromIndex){if(e.dataTransfer){e.dataTransfer.dropEffect="move"}const domFromIndex=this.columnElements_.findIndex((item=>item===dragElement));const domToIndex=this.columnElements_.findIndex((item=>item===dropTarget));this.pendingOrder_.set(domToIndex,fromIndex);this.pendingOrder_.set(domFromIndex,toIndex);dropTarget.style.order=`${fromIndex}`;dragElement.style.order=`${toIndex}`;dropTarget.toggleAttribute(IS_FIRST_COLUMN_ATTR,fromIndex===0);dragElement.toggleAttribute(IS_FIRST_COLUMN_ATTR,toIndex===0)}}drop_(e){const dragElement=this.tableElement_.draggingColumn;if(!dragElement){return}const dropTarget=getColumnByComposedPath(e.composedPath());if(!dropTarget){return}const fromIndex=Number(dragElement.dataset["index"]);const toIndex=getVisualOrderIndex(dropTarget);if(toIndex!==fromIndex){this.tableElement_.moveColumnOnDrop(fromIndex,toIndex);this.pendingOrder_.clear()}this.dragEnd_()}dragEnd_(){this.columnElements_.forEach((column=>{column.style.position="unset"}));if(!this.tableElement_.draggingColumn){return}this.tableElement_.draggingColumn=null;this.resetVisualOrder()}}