// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_lazy_list/cr_lazy_list.js";import"chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/cr_elements/cr_toolbar/cr_toolbar_selection_overlay.js";import"chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js";import"chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js";import"chrome://resources/cr_elements/cr_toast/cr_toast.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"./images/icons.html.js";import"./comparison_table_list_item.js";import{ShowSetDisposition}from"//resources/cr_components/commerce/product_specifications.mojom-webui.js";import{ProductSpecificationsBrowserProxyImpl}from"//resources/cr_components/commerce/product_specifications_browser_proxy.js";import{ShoppingServiceBrowserProxyImpl}from"//resources/cr_components/commerce/shopping_service_browser_proxy.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PluralStringProxyImpl}from"//resources/js/plural_string_proxy.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./comparison_table_list.css.js";import{getHtml}from"./comparison_table_list.html.js";export class ComparisonTableListElement extends CrLitElement{static get is(){return"comparison-table-list"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{deletionToastDurationMs_:{type:Number},deletionToastMessage_:{type:String},isEditing_:{type:Boolean},numSelected_:{type:Number},tables:{type:Array},tablesPendingDeletion_:{type:Object}}}#tables_accessor_storage=[];get tables(){return this.#tables_accessor_storage}set tables(value){this.#tables_accessor_storage=value}#deletionToastDurationMs__accessor_storage=5e3;get deletionToastDurationMs_(){return this.#deletionToastDurationMs__accessor_storage}set deletionToastDurationMs_(value){this.#deletionToastDurationMs__accessor_storage=value}#deletionToastMessage__accessor_storage="";get deletionToastMessage_(){return this.#deletionToastMessage__accessor_storage}set deletionToastMessage_(value){this.#deletionToastMessage__accessor_storage=value}#isEditing__accessor_storage=false;get isEditing_(){return this.#isEditing__accessor_storage}set isEditing_(value){this.#isEditing__accessor_storage=value}#numSelected__accessor_storage=0;get numSelected_(){return this.#numSelected__accessor_storage}set numSelected_(value){this.#numSelected__accessor_storage=value}#tablesPendingDeletion__accessor_storage=new Set;get tablesPendingDeletion_(){return this.#tablesPendingDeletion__accessor_storage}set tablesPendingDeletion_(value){this.#tablesPendingDeletion__accessor_storage=value}deletionTimeoutId_=null;pluralStringProxy_=PluralStringProxyImpl.getInstance();productSpecificationsProxy_=ProductSpecificationsBrowserProxyImpl.getInstance();selectedUuids_=new Set;shoppingApi_=ShoppingServiceBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();window.addEventListener("beforeunload",(()=>{if(this.deletionTimeoutId_){this.cancelPendingDeletionTimeout_();this.deletePendingTables_()}}))}disconnectedCallback(){super.disconnectedCallback();this.cancelPendingDeletionTimeout_()}resetDeletionToastDurationMsForTesting(){this.deletionToastDurationMs_=0}getTables_(tables,uuidsPendingDeletion){return tables.filter((table=>!uuidsPendingDeletion.has(table.uuid)))}getSelectionLabel_(numSelected){return loadTimeData.getStringF("numSelected",numSelected)}getOpenAllString_(numSelected){return loadTimeData.getStringF("menuOpenAll",numSelected)}getOpenAllInNewWindowString_(numSelected){return loadTimeData.getStringF("menuOpenAllInNewWindow",numSelected)}onEditClick_(){if(!this.isEditing_){const toast=this.$.toast.getIfExists();if(toast){toast.hide()}this.isEditing_=true;return}this.stopEditing_()}onClearClick_(){this.stopEditing_()}async onDeleteClick_(){const menu=this.$.menu.getIfExists();if(menu){menu.close()}await this.updateDeletionToastMessage_();this.scheduleSelectedTablesForDeletion_();this.stopEditing_();await this.updateComplete;await this.$.toast.get().show()}onShowContextMenuClick_(){this.$.menu.get().showAt(this.$.more)}onOpenAllClick_(){this.productSpecificationsProxy_.showProductSpecificationsSetsForUuids(Array.from(this.selectedUuids_),ShowSetDisposition.kInNewTabs);this.$.menu.get().close();this.fire("open-all-finished-for-testing")}onOpenAllInNewWindowClick_(){this.productSpecificationsProxy_.showProductSpecificationsSetsForUuids(Array.from(this.selectedUuids_),ShowSetDisposition.kInNewWindow);this.$.menu.get().close();this.fire("open-all-in-new-window-finished-for-testing")}onUndoDeletionClick_(){this.cancelPendingDeletionTimeout_();this.tablesPendingDeletion_.clear();this.$.toast.get().hide();this.requestUpdate()}onCheckboxChange_(event){if(event.detail.checked){this.selectedUuids_.add(event.detail.uuid)}else{this.selectedUuids_.delete(event.detail.uuid)}this.numSelected_=this.selectedUuids_.size}onItemDelete_(event){this.selectedUuids_.clear();this.selectedUuids_.add(event.detail.uuid);this.numSelected_=1;this.onDeleteClick_()}stopEditing_(){this.isEditing_=false;this.selectedUuids_.clear();this.numSelected_=0}scheduleSelectedTablesForDeletion_(){for(const uuid of this.selectedUuids_){this.tablesPendingDeletion_.add(uuid)}this.deletionTimeoutId_=setTimeout((()=>{this.deletionTimeoutId_=null;this.deletePendingTables_()}),this.deletionToastDurationMs_)}deletePendingTables_(){for(const uuid of this.tablesPendingDeletion_){this.shoppingApi_.deleteProductSpecificationsSet(uuid)}this.tablesPendingDeletion_.clear();this.fire("delete-finished-for-testing")}async updateDeletionToastMessage_(){this.deletionToastMessage_=await this.pluralStringProxy_.getPluralString("deletionToastMessage",this.numSelected_)}cancelPendingDeletionTimeout_(){if(this.deletionTimeoutId_){clearTimeout(this.deletionTimeoutId_);this.deletionTimeoutId_=null}}}customElements.define(ComparisonTableListElement.is,ComparisonTableListElement);