// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./header.js";import"./loading_state.js";import"./new_column_selector.js";import"./product_selector.js";import"./table.js";import"./horizontal_carousel.js";import"./comparison_table_list.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import"chrome://resources/cr_elements/cr_hidden_style.css.js";import"chrome://resources/cr_elements/cr_loading_gradient/cr_loading_gradient.js";import"chrome://resources/cr_elements/cr_toast/cr_toast.js";import"./shared_vars.css.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{ProductSpecificationsBrowserProxyImpl}from"chrome://resources/cr_components/commerce/product_specifications_browser_proxy.js";import{UserFeedback}from"chrome://resources/cr_components/commerce/shopping_service.mojom-webui.js";import{ShoppingServiceBrowserProxyImpl}from"chrome://resources/cr_components/commerce/shopping_service_browser_proxy.js";import{CrFeedbackOption}from"chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{OpenWindowProxyImpl}from"chrome://resources/js/open_window_proxy.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{SectionType}from"./product_selection_menu.js";import{Router}from"./router.js";import{isValidLowercaseUuid}from"./utils.js";import{WindowProxy}from"./window_proxy.js";export var CompareTableColumnAction;(function(CompareTableColumnAction){CompareTableColumnAction[CompareTableColumnAction["REMOVE"]=0]="REMOVE";CompareTableColumnAction[CompareTableColumnAction["CHANGE_ORDER_DRAG_AND_DROP"]=1]="CHANGE_ORDER_DRAG_AND_DROP";CompareTableColumnAction[CompareTableColumnAction["ADD_FROM_SUGGESTED"]=2]="ADD_FROM_SUGGESTED";CompareTableColumnAction[CompareTableColumnAction["UPDATE_FROM_SUGGESTED"]=3]="UPDATE_FROM_SUGGESTED";CompareTableColumnAction[CompareTableColumnAction["ADD_FROM_RECENTLY_VIEWED"]=4]="ADD_FROM_RECENTLY_VIEWED";CompareTableColumnAction[CompareTableColumnAction["UPDATE_FROM_RECENTLY_VIEWED"]=5]="UPDATE_FROM_RECENTLY_VIEWED";CompareTableColumnAction[CompareTableColumnAction["MAX_VALUE"]=6]="MAX_VALUE"})(CompareTableColumnAction||(CompareTableColumnAction={}));export var CompareTableLoadStatus;(function(CompareTableLoadStatus){CompareTableLoadStatus[CompareTableLoadStatus["SUCCESS"]=0]="SUCCESS";CompareTableLoadStatus[CompareTableLoadStatus["FAILURE"]=1]="FAILURE";CompareTableLoadStatus[CompareTableLoadStatus["FAILURE_EMPTY_TABLE_BACKEND"]=2]="FAILURE_EMPTY_TABLE_BACKEND";CompareTableLoadStatus[CompareTableLoadStatus["FAILURE_EMPTY_TABLE_NON_PRODUCTS"]=2]="FAILURE_EMPTY_TABLE_NON_PRODUCTS";CompareTableLoadStatus[CompareTableLoadStatus["FAILURE_USER_NOT_ELIGIBLE"]=3]="FAILURE_USER_NOT_ELIGIBLE";CompareTableLoadStatus[CompareTableLoadStatus["FAILURE_OFFLINE"]=4]="FAILURE_OFFLINE";CompareTableLoadStatus[CompareTableLoadStatus["MAX_VALUE"]=5]="MAX_VALUE"})(CompareTableLoadStatus||(CompareTableLoadStatus={}));export const COLUMN_MODIFICATION_HISTOGRAM_NAME="Commerce.Compare.Table.ColumnModification";export const TABLE_LOAD_HISTOGRAM_NAME="Commerce.Compare.Table.LoadStatus";export var AppState;(function(AppState){AppState[AppState["ERROR"]=0]="ERROR";AppState[AppState["TABLE_EMPTY"]=1]="TABLE_EMPTY";AppState[AppState["SYNC_SCREEN"]=2]="SYNC_SCREEN";AppState[AppState["TABLE_POPULATED"]=3]="TABLE_POPULATED";AppState[AppState["LOADING"]=4]="LOADING";AppState[AppState["NO_CONTENT"]=5]="NO_CONTENT"})(AppState||(AppState={}));function getProductDetails(product,productSpecs,productInfo){const productDetails=[];const priceRowTitle=loadTimeData.getString("priceRowTitle");const price=productInfo?.priceSummary||productInfo?.currentPrice||"";const jackpotUrl=product?.buyingOptionsUrl.url||"";if(price||jackpotUrl){productDetails.push({title:priceRowTitle,content:{price:price,jackpotUrl:jackpotUrl}})}else{productDetails.push({title:priceRowTitle,content:null})}productDetails.push({title:loadTimeData.getString("productSummaryRowTitle"),content:{attributes:[],summary:product?.summary||[]}});productSpecs.productDimensionMap.forEach(((title,key)=>{if(!product){productDetails.push({title:title,content:null})}else{const value=product.productDimensionValues.get(key);const attributes=(value?.specificationDescriptions||[]).flatMap((description=>({label:description.label,value:description.options.flatMap((option=>option.descriptions)).flatMap((desc=>desc.text)).join(", ")})))||[];const summary=value?.summary||[];productDetails.push({title:title,content:{attributes:attributes,summary:summary}})}}));return productDetails}function areStatesEqual(firstState,secondState){return firstState!==null&&secondState!==null&&firstState.isSyncingTabCompare===secondState.isSyncingTabCompare&&firstState.canLoadFullPageUi===secondState.canLoadFullPageUi&&firstState.canManageSets===secondState.canManageSets&&firstState.canFetchData===secondState.canFetchData&&firstState.isAllowedForEnterprise===secondState.isAllowedForEnterprise}function findProductInResults(clusterId,specs){if(!specs){return null}for(const product of specs.products){if(product.productClusterId.toString()===clusterId.toString()){return product}}return null}export const LOADING_START_EVENT_TYPE="loading-animation-start";export const LOADING_END_EVENT_TYPE="loading-animation-end";const LOADING_ANIMATION_SLIDE_PX=16;export class ProductSpecificationsElement extends CrLitElement{static get is(){return"product-specifications-app"}static get styles(){return getCss()}static get properties(){return{appState_:{type:Object},id_:{type:Object},sets_:{type:Array},loadingState_:{type:Object},productSpecificationsFeatureState_:{type:Object},setName_:{type:String},showComparisonTableList_:{type:Boolean},showEmptyState_:{type:Boolean},showTableDataUnavailableContainer_:{type:Boolean,reflect:true},tableColumns_:{type:Object}}}#appState__accessor_storage=AppState.NO_CONTENT;get appState_(){return this.#appState__accessor_storage}set appState_(value){this.#appState__accessor_storage=value}#id__accessor_storage=null;get id_(){return this.#id__accessor_storage}set id_(value){this.#id__accessor_storage=value}#loadingState__accessor_storage={loading:false,urlCount:0};get loadingState_(){return this.#loadingState__accessor_storage}set loadingState_(value){this.#loadingState__accessor_storage=value}#productSpecificationsFeatureState__accessor_storage=null;get productSpecificationsFeatureState_(){return this.#productSpecificationsFeatureState__accessor_storage}set productSpecificationsFeatureState_(value){this.#productSpecificationsFeatureState__accessor_storage=value}#setName__accessor_storage=null;get setName_(){return this.#setName__accessor_storage}set setName_(value){this.#setName__accessor_storage=value}#sets__accessor_storage=[];get sets_(){return this.#sets__accessor_storage}set sets_(value){this.#sets__accessor_storage=value}#showComparisonTableList__accessor_storage=false;get showComparisonTableList_(){return this.#showComparisonTableList__accessor_storage}set showComparisonTableList_(value){this.#showComparisonTableList__accessor_storage=value}#showEmptyState__accessor_storage=false;get showEmptyState_(){return this.#showEmptyState__accessor_storage}set showEmptyState_(value){this.#showEmptyState__accessor_storage=value}#showTableDataUnavailableContainer__accessor_storage=false;get showTableDataUnavailableContainer_(){return this.#showTableDataUnavailableContainer__accessor_storage}set showTableDataUnavailableContainer_(value){this.#showTableDataUnavailableContainer__accessor_storage=value}#tableColumns__accessor_storage=[];get tableColumns_(){return this.#tableColumns__accessor_storage}set tableColumns_(value){this.#tableColumns__accessor_storage=value}callbackRouter_;eventTracker_=new EventTracker;isWindowFocused_=true;listenerIds_=[];loadingAnimationSlideDurationMs_=200;contentContainerIsHidden_=false;minLoadingAnimationMs_=500;pendingSetUpdate_=null;productSpecificationsProxy_=ProductSpecificationsBrowserProxyImpl.getInstance();shoppingApi_=ShoppingServiceBrowserProxyImpl.getInstance();constructor(){super();this.callbackRouter_=this.productSpecificationsProxy_.getCallbackRouter();ColorChangeUpdater.forDocument().start()}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("productSpecificationsFeatureState_")||changedPrivateProperties.has("loadingState_")||changedPrivateProperties.has("showEmptyState_")){this.appState_=this.computeAppState_()}if(changedPrivateProperties.has("appState_")||changedPrivateProperties.has("id_")||changedPrivateProperties.has("sets_")||changedPrivateProperties.has("showEmptyState_")){this.showComparisonTableList_=this.computeShowComparisonTableList_()}if(changedPrivateProperties.has("appState_")){this.showTableDataUnavailableContainer_=this.computeShowTableDataUnavailableContainer_()}}render(){return getHtml.bind(this)()}async connectedCallback(){super.connectedCallback();this.listenerIds_.push(this.callbackRouter_.onProductSpecificationsSetAdded.addListener((set=>this.onSetAdded_(set))),this.callbackRouter_.onProductSpecificationsSetRemoved.addListener((uuid=>this.onSetRemoved_(uuid))),this.callbackRouter_.onProductSpecificationsSetUpdated.addListener((set=>this.onSetUpdated_(set))),this.callbackRouter_.onSyncStateChanged.addListener((()=>this.updateFeatureState_())));window.addEventListener("focus",(()=>{this.isWindowFocused_=true;if(this.pendingSetUpdate_){this.pendingSetUpdate_()}this.pendingSetUpdate_=null}));window.addEventListener("blur",(()=>{this.isWindowFocused_=false}));window.addEventListener("popstate",(()=>{window.location.replace(window.location.href)}));this.eventTracker_.add(this,"click",(()=>{this.$.offlineToast.hide();this.$.errorToast.hide()}),true);this.eventTracker_.add(window,"online",(()=>{this.$.offlineToast.hide()}));if(this.isOffline_){this.showOfflineToast_();return}await this.updateFeatureState_()}disconnectedCallback(){super.disconnectedCallback();this.listenerIds_.forEach((id=>this.callbackRouter_.removeListener(id)));this.eventTracker_.removeAll()}resetLoadingAnimationMsForTesting(loadingAnimationMs=0){this.minLoadingAnimationMs_=loadingAnimationMs;this.loadingAnimationSlideDurationMs_=0}focusWindowForTesting(){this.isWindowFocused_=true}async loadTable_(state){if(!(state.isSyncingTabCompare&&state.canLoadFullPageUi&&state.canFetchData&&state.isAllowedForEnterprise)){return}const router=Router.getInstance();const params=new URLSearchParams(router.getCurrentQuery());const idParam=params.get("id");if(idParam&&isValidLowercaseUuid(idParam)){if(await this.loadSet_({value:idParam})){return}}const urlsParam=params.get("urls");if(!urlsParam){this.updateEmptyState_(true);return}let urls=[];try{urls=JSON.parse(urlsParam)}catch(_){return}await this.createNewSet_(urls)}async updateFeatureState_(){const{state:state}=await this.shoppingApi_.getProductSpecificationsFeatureState();if(!state){return}if(!this.productSpecificationsFeatureState_||!areStatesEqual(state,this.productSpecificationsFeatureState_)){await this.loadTable_(state);this.productSpecificationsFeatureState_=state}}computeAppState_(){if(this.productSpecificationsFeatureState_){if(!this.productSpecificationsFeatureState_.isSyncingTabCompare){return AppState.SYNC_SCREEN}if(!(this.productSpecificationsFeatureState_.canLoadFullPageUi&&this.productSpecificationsFeatureState_.canFetchData&&this.productSpecificationsFeatureState_.isAllowedForEnterprise)){chrome.metricsPrivate.recordEnumerationValue(TABLE_LOAD_HISTOGRAM_NAME,CompareTableLoadStatus.FAILURE_USER_NOT_ELIGIBLE,CompareTableLoadStatus.MAX_VALUE);return AppState.ERROR}if(this.loadingState_.loading){return AppState.LOADING}if(this.showEmptyState_){return AppState.TABLE_EMPTY}return AppState.TABLE_POPULATED}if(this.isOffline_){chrome.metricsPrivate.recordEnumerationValue(TABLE_LOAD_HISTOGRAM_NAME,CompareTableLoadStatus.FAILURE_OFFLINE,CompareTableLoadStatus.MAX_VALUE);return AppState.ERROR}return AppState.NO_CONTENT}computeShowTableDataUnavailableContainer_(){return this.appState_===AppState.ERROR||this.appState_===AppState.TABLE_EMPTY||this.appState_===AppState.SYNC_SCREEN}computeShowComparisonTableList_(){return this.showEmptyState_&&this.id_===null&&this.sets_.length>0&&this.appState_===AppState.TABLE_EMPTY}isHeaderEnabled_(){return!this.loadingState_.loading&&this.appState_!==AppState.ERROR&&this.appState_!==AppState.SYNC_SCREEN}canShowFooter_(showTableDataUnavailableContainer,appState){return!(showTableDataUnavailableContainer||appState===AppState.NO_CONTENT)}canShowFeedbackButtons_(){return Boolean(this.productSpecificationsFeatureState_?.isQualityLoggingAllowed)}showSyncSetupFlow_(){assert(this.productSpecificationsFeatureState_);assert(!this.productSpecificationsFeatureState_.isSyncingTabCompare);if(this.productSpecificationsFeatureState_.isSignedIn){OpenWindowProxyImpl.getInstance().openUrl("chrome://settings/syncSetup/advanced");return}this.productSpecificationsProxy_.showSyncSetupFlow()}showOfflineToast_(){this.$.offlineToast.show()}async populateTable_(urls){this.$.errorToast.hide();if(urls.length===0){this.tableColumns_=[];this.updateEmptyState_(true);await this.showContentContainer_();return}await this.enterLoadingState_(urls.length);const start=Date.now();this.updateEmptyState_(false);const tableColumns=[];const{productSpecs:productSpecs}=await this.shoppingApi_.getProductSpecificationsForUrls(urls.map((url=>({url:url}))));const aggregatedDataByUrl=await this.aggregateProductDataByUrl_(urls,productSpecs);const titleMap=new Map;await Promise.all(urls.map((async url=>{const info=aggregatedDataByUrl.get(url)?.productInfo;const product=aggregatedDataByUrl.get(url)?.spec;const title=product?.title||info?.title||(await this.productSpecificationsProxy_.getPageTitleFromHistory({url:url})).title;titleMap.set(url,title)})));urls.map(((url,index)=>{const info=aggregatedDataByUrl.get(url)?.productInfo;const product=aggregatedDataByUrl.get(url)?.spec;tableColumns[index]={selectedItem:{title:titleMap.get(url)||"",url:url,imageUrl:info?.imageUrl?.url||product?.imageUrl?.url||""},productDetails:getProductDetails(product||null,productSpecs,info||null)}}));if(productSpecs.productDimensionMap.size===0&&urls.length>1){this.$.errorToast.show();if(urls.some((url=>!!aggregatedDataByUrl.get(url)))){chrome.metricsPrivate.recordEnumerationValue(TABLE_LOAD_HISTOGRAM_NAME,CompareTableLoadStatus.FAILURE_EMPTY_TABLE_NON_PRODUCTS,CompareTableLoadStatus.MAX_VALUE)}else{chrome.metricsPrivate.recordEnumerationValue(TABLE_LOAD_HISTOGRAM_NAME,CompareTableLoadStatus.FAILURE_EMPTY_TABLE_BACKEND,CompareTableLoadStatus.MAX_VALUE)}}else{chrome.metricsPrivate.recordEnumerationValue(TABLE_LOAD_HISTOGRAM_NAME,CompareTableLoadStatus.SUCCESS,CompareTableLoadStatus.MAX_VALUE)}const delta=Date.now()-start;if(delta<this.minLoadingAnimationMs_&&urls.length>0){await new Promise((res=>setTimeout(res,this.minLoadingAnimationMs_-delta)))}this.tableColumns_=tableColumns;this.updateEmptyState_(this.tableColumns_.length===0);this.exitLoadingState_()}get isOffline_(){return!WindowProxy.getInstance().onLine}async getProductInfoForUrls_(urls){const urlList=urls.map((url=>({url:url})));const{productInfos:productInfos}=await this.shoppingApi_.getProductInfoForUrls(urlList);const infoMap=new Map;for(const info of productInfos){if(info&&info.clusterId){infoMap.set(info.productUrl.url,info)}}return infoMap}async aggregateProductDataByUrl_(urls,specs){const urlToProductInfoMap=await this.getProductInfoForUrls_(urls);const specProductMap=new Map;urlToProductInfoMap.forEach(((value,key)=>{const product=findProductInResults(value.clusterId,specs);if(product){specProductMap.set(key,product)}}));const aggregatedDatas=new Map;urls.forEach((url=>{const productInfo=urlToProductInfoMap.get(url);const productSpecs=specProductMap.get(url);aggregatedDatas.set(url,{productInfo:productInfo??null,spec:productSpecs??null})}));return aggregatedDatas}async loadSet_(uuid){const{set:set}=await this.shoppingApi_.getProductSpecificationsSetByUuid(uuid);if(set){const{disclosureShown:disclosureShown}=await this.productSpecificationsProxy_.maybeShowDisclosure([],"",uuid.value);if(disclosureShown){this.updateEmptyState_(true);this.id_=null;return false}if(this.appState_===AppState.TABLE_EMPTY){await this.hideContentContainer_()}this.id_=set.uuid;document.title=set.name;this.setName_=set.name;this.populateTable_(set.urls.map((url=>url.url)));return true}this.updateEmptyState_(true);this.id_=null;return false}deleteSet_(uuid=this.id_){if(this.isOffline_){this.showOfflineToast_();return}if(uuid){this.shoppingApi_.deleteProductSpecificationsSet(uuid)}}updateSetName_(e){if(this.isOffline_){this.showOfflineToast_();return}if(this.id_){this.shoppingApi_.setNameForProductSpecificationsSet(this.id_,e.detail.name)}}seeAllSets_(){this.productSpecificationsProxy_.showComparePage(true)}async onUrlAdd_(e){if(this.isOffline_){this.showOfflineToast_();return}let recordValue=CompareTableColumnAction.MAX_VALUE;switch(e.detail.urlSection){case SectionType.RECENT:recordValue=CompareTableColumnAction.ADD_FROM_RECENTLY_VIEWED;break;case SectionType.SUGGESTED:recordValue=CompareTableColumnAction.ADD_FROM_SUGGESTED;break}chrome.metricsPrivate.recordEnumerationValue(COLUMN_MODIFICATION_HISTOGRAM_NAME,recordValue,CompareTableColumnAction.MAX_VALUE);const urls=this.getTableUrls_();urls.push(e.detail.url);if(this.id_){this.modifyUrls_(urls);return}const{disclosureShown:disclosureShown}=await this.productSpecificationsProxy_.maybeShowDisclosure(urls.map((url=>({url:url}))),this.setName_?this.setName_:"","");if(!disclosureShown){this.modifyUrls_(urls)}}onUrlChange_(e){if(this.isOffline_){this.showOfflineToast_();return}let recordValue=CompareTableColumnAction.MAX_VALUE;switch(e.detail.urlSection){case SectionType.RECENT:recordValue=CompareTableColumnAction.UPDATE_FROM_RECENTLY_VIEWED;break;case SectionType.SUGGESTED:recordValue=CompareTableColumnAction.UPDATE_FROM_SUGGESTED;break}chrome.metricsPrivate.recordEnumerationValue(COLUMN_MODIFICATION_HISTOGRAM_NAME,recordValue,CompareTableColumnAction.MAX_VALUE);const urls=this.getTableUrls_();urls[e.detail.index]=e.detail.url;this.modifyUrls_(urls)}onUrlOrderUpdate_(){if(this.isOffline_){this.showOfflineToast_();return}chrome.metricsPrivate.recordEnumerationValue(COLUMN_MODIFICATION_HISTOGRAM_NAME,CompareTableColumnAction.CHANGE_ORDER_DRAG_AND_DROP,CompareTableColumnAction.MAX_VALUE);const urls=this.getTableUrls_();this.modifyUrls_(urls)}onUrlRemove_(e){if(this.isOffline_){this.showOfflineToast_();return}chrome.metricsPrivate.recordEnumerationValue(COLUMN_MODIFICATION_HISTOGRAM_NAME,CompareTableColumnAction.REMOVE,CompareTableColumnAction.MAX_VALUE);const urls=this.getTableUrls_();urls.splice(e.detail.index,1);this.modifyUrls_(urls)}modifyUrls_(urls){if(this.id_){this.shoppingApi_.setUrlsForProductSpecificationsSet(this.id_,urls.map((url=>({url:url}))))}else{this.createNewSet_(urls)}}async createNewSet_(urls){if(this.isOffline_){this.showOfflineToast_();return}assert(!this.id_&&!this.setName_);this.setName_=loadTimeData.getString("defaultTableTitle");const{createdSet:createdSet}=await this.shoppingApi_.addProductSpecificationsSet(this.setName_,urls.map((url=>({url:url}))));if(createdSet){this.id_=createdSet.uuid;document.title=this.setName_;window.history.pushState(undefined,"",`?id=${this.id_.value}`)}this.populateTable_(urls)}getTableUrls_(){return this.tableColumns_.map((column=>column.selectedItem.url))}isTableFull_(){return this.tableColumns_.length>=loadTimeData.getInteger("maxTableSize")}onSetUpdated_(set){if(!this.isWindowFocused_){this.pendingSetUpdate_=this.updateSet_.bind(this,set);return}this.updateSet_(set)}async updateSet_(set){if(this.showEmptyState_){const tableIndex=this.sets_.findIndex((table=>table.uuid.value===set.uuid.value));if(tableIndex!==-1){this.sets_=this.sets_.toSpliced(tableIndex,1,set)}}if(set.uuid.value!==this.id_?.value){return}document.title=set.name;this.setName_=set.name;let urlSetChanged=false;let orderChanged=false;const tableUrls=this.getTableUrls_();if(tableUrls.length===set.urls.length){for(const[i,setUrl]of set.urls.entries()){if(setUrl.url!==tableUrls[i]){orderChanged=true}if(!tableUrls.includes(setUrl.url)){urlSetChanged=true;break}}}else{urlSetChanged=true}if(urlSetChanged){this.closeAllProductSelectionMenus_();await this.hideContentContainer_();this.populateTable_(set.urls.map((url=>url.url)))}else if(orderChanged){const newCols=[];for(const[_,setUrl]of set.urls.entries()){const existingIndex=tableUrls.indexOf(setUrl.url);assert(existingIndex>=0,"Did not find column to reorder!");const col=this.tableColumns_[existingIndex];assert(col);newCols.push(col)}this.tableColumns_=newCols}}onSetRemoved_(id){if(id.value===this.id_?.value){window.location.replace(window.location.origin)}if(this.showEmptyState_){this.sets_=this.sets_.filter((table=>table.uuid.value!==id.value))}}onFeedbackSelectedOptionChanged_(e){switch(e.detail.value){case CrFeedbackOption.UNSPECIFIED:this.shoppingApi_.setProductSpecificationsUserFeedback(UserFeedback.kUnspecified);return;case CrFeedbackOption.THUMBS_UP:this.shoppingApi_.setProductSpecificationsUserFeedback(UserFeedback.kThumbsUp);return;case CrFeedbackOption.THUMBS_DOWN:this.shoppingApi_.setProductSpecificationsUserFeedback(UserFeedback.kThumbsDown);return}}onSetAdded_(set){if(this.showEmptyState_){this.sets_=[set].concat(this.sets_)}}getDisclaimerText_(){return loadTimeData.getStringF("experimentalFeatureDisclaimer",loadTimeData.getString("userEmail"))}async hideContentContainer_(){if(this.contentContainerIsHidden_){return}this.contentContainerIsHidden_=true;await this.$.contentContainer.animate([{opacity:1,transform:"translateY(0px)"},{opacity:0,transform:`translateY(-${LOADING_ANIMATION_SLIDE_PX}px)`}],{duration:this.loadingAnimationSlideDurationMs_,easing:"ease-out",fill:"forwards"}).finished}async showContentContainer_(){if(!this.contentContainerIsHidden_){return}await this.$.contentContainer.animate([{opacity:0,transform:`translateY(${LOADING_ANIMATION_SLIDE_PX}px)`},{opacity:1,transform:"translateY(0px)"}],{duration:this.loadingAnimationSlideDurationMs_,easing:"ease-out",fill:"forwards"}).finished;this.contentContainerIsHidden_=false}async enterLoadingState_(urlCount){if([AppState.ERROR,AppState.SYNC_SCREEN,AppState.LOADING,AppState.NO_CONTENT].includes(this.appState_)){this.loadingState_={loading:true,urlCount:urlCount};this.dispatchLoadingStartEvent_();return Promise.resolve()}return new Promise((async resolve=>{await this.hideContentContainer_();this.loadingState_={loading:true,urlCount:urlCount};resolve();await this.showContentContainer_();this.dispatchLoadingStartEvent_()}))}async exitLoadingState_(){await this.hideContentContainer_();this.loadingState_={loading:false,urlCount:0};await this.showContentContainer_();this.dispatchLoadingEndEvent_()}dispatchLoadingStartEvent_(){this.fire(LOADING_START_EVENT_TYPE)}dispatchLoadingEndEvent_(){this.fire(LOADING_END_EVENT_TYPE)}async updateEmptyState_(shouldShow){this.showEmptyState_=shouldShow;this.requestUpdate();if(this.showEmptyState_&&this.sets_.length===0){const{sets:sets}=await this.shoppingApi_.getAllProductSpecificationsSets();this.sets_=sets}}onComparisonTableListItemClick_(event){window.history.pushState(undefined,"",`?id=${event.detail.uuid.value}`);this.loadSet_(event.detail.uuid)}onComparisonTableListItemRename_(event){this.shoppingApi_.setNameForProductSpecificationsSet(event.detail.uuid,event.detail.name)}onHeaderMenuDeleteClick_(){this.deleteSet_()}closeAllProductSelectionMenus_(){this.$.summaryTable.closeAllProductSelectionMenus();this.$.newColumnSelector.closeMenu()}}customElements.define(ProductSpecificationsElement.is,ProductSpecificationsElement);