/**
 * @fileoverview The 'certificate-entry' component is for showing a summary
 * of a certificate in a row on screen.
 *
 * This component is used in the new Certificate Management UI in
 * ./certificate_manager.ts.
 */
import '/strings.m.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_icons.css.js';
import '//resources/cr_elements/cr_input/cr_input.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import type { CrInputElement } from '//resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ActionResult, CertificateSource } from './certificate_manager.mojom-webui.js';
export interface CertificateEntryElement {
    $: {
        certhash: CrInputElement;
        copy: HTMLElement;
        view: HTMLElement;
        delete: HTMLElement;
    };
}
declare global {
    interface HTMLElementEventMap {
        'hash-copied': CustomEvent<void>;
        'delete-result': CustomEvent<ActionResult | null>;
    }
}
declare const CertificateEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class CertificateEntryElement extends CertificateEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        certSource: NumberConstructor;
        sha256hashHex: StringConstructor;
        displayName: StringConstructor;
        isDeletable: BooleanConstructor;
        showEditIcon: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    certSource: CertificateSource;
    sha256hashHex: string;
    displayName: string;
    isDeletable: boolean;
    showEditIcon: boolean;
    private certDetailsIconClass_;
    private onViewCertificate_;
    private onDeleteCertificate_;
    private onCopyHash_;
}
declare global {
    interface HTMLElementTagNameMap {
        'certificate-entry': CertificateEntryElement;
    }
}
export {};
