// chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-data-view.h"




namespace std {

template <>
struct hash<::certificate_manager::mojom::CertificateSource>
    : public mojo::internal::EnumHashImpl<::certificate_manager::mojom::CertificateSource> {};

template <>
struct hash<::certificate_manager::mojom::SuccessResult>
    : public mojo::internal::EnumHashImpl<::certificate_manager::mojom::SuccessResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::certificate_manager::mojom::CertificateSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::certificate_manager::mojom::CertificateSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::certificate_manager::mojom::CertificateSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::certificate_manager::mojom::SuccessResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::certificate_manager::mojom::SuccessResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::certificate_manager::mojom::SuccessResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::certificate_manager::mojom::SummaryCertInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::certificate_manager::mojom::SummaryCertInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::certificate_manager::mojom::internal::SummaryCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sha256hash_hex(input)) in_sha256hash_hex = Traits::sha256hash_hex(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sha256hash_hex)::BaseType> sha256hash_hex_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sha256hash_hex,
      sha256hash_hex_fragment);

    fragment->sha256hash_hex.Set(
        sha256hash_hex_fragment.is_null() ? nullptr : sha256hash_hex_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sha256hash_hex.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sha256hash_hex in SummaryCertInfo struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in SummaryCertInfo struct");

    fragment->is_deletable = Traits::is_deletable(input);
  }

  static bool Deserialize(::certificate_manager::mojom::internal::SummaryCertInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::certificate_manager::mojom::SummaryCertInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::certificate_manager::mojom::CertManagementMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::certificate_manager::mojom::CertManagementMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::certificate_manager::mojom::internal::CertManagementMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->include_system_trust_store = Traits::include_system_trust_store(input);

    fragment->num_user_added_system_certs = Traits::num_user_added_system_certs(input);

    fragment->is_include_system_trust_store_managed = Traits::is_include_system_trust_store_managed(input);

    fragment->num_policy_certs = Traits::num_policy_certs(input);

    fragment->num_user_certs = Traits::num_user_certs(input);

    fragment->show_user_certs_ui = Traits::show_user_certs_ui(input);
  }

  static bool Deserialize(::certificate_manager::mojom::internal::CertManagementMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::certificate_manager::mojom::CertManagementMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::certificate_manager::mojom::ActionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::certificate_manager::mojom::ActionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::certificate_manager::mojom::internal::ActionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::certificate_manager::mojom::ActionResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in ActionResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::certificate_manager::mojom::ActionResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::certificate_manager::mojom::SuccessResult>(
  in_success,
  &fragment->data.f_success);
    break;
  }
}
  }

  static bool Deserialize(::certificate_manager::mojom::internal::ActionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::certificate_manager::mojom::ActionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace certificate_manager::mojom {

inline void SummaryCertInfoDataView::GetSha256hashHexDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sha256hash_hex.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SummaryCertInfoDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void ActionResultDataView::GetErrorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error());
  *output = mojo::StringDataView(data_->data.f_error.Get(), message_);
}


}  // certificate_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::certificate_manager::mojom::CertificateSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::certificate_manager::mojom::CertificateSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::certificate_manager::mojom::SuccessResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::certificate_manager::mojom::SuccessResult value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_H_