// chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_INTERNAL_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace certificate_manager::mojom {
namespace internal {
class SummaryCertInfo_Data;
class CertManagementMetadata_Data;
class ActionResult_Data;

struct CertificateSource_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SuccessResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  ActionResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  ActionResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~ActionResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<ActionResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class ActionResult_Tag : uint32_t {

    
    kError,
    
    kSuccess,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<mojo::internal::String_Data> f_error;
    int32_t f_success;
    uint64_t unknown;
  };

  uint32_t size;
  ActionResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(ActionResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(ActionResult_Data)");
class  SummaryCertInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> sha256hash_hex;
  mojo::internal::Pointer<mojo::internal::String_Data> display_name;
  uint8_t is_deletable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SummaryCertInfo_Data>;

  SummaryCertInfo_Data();
  ~SummaryCertInfo_Data() = delete;
};
static_assert(sizeof(SummaryCertInfo_Data) == 32,
              "Bad sizeof(SummaryCertInfo_Data)");
// Used by SummaryCertInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SummaryCertInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SummaryCertInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SummaryCertInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SummaryCertInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SummaryCertInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CertManagementMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t include_system_trust_store : 1;
  uint8_t is_include_system_trust_store_managed : 1;
  uint8_t show_user_certs_ui : 1;
  uint8_t num_user_added_system_certs;
  uint8_t num_policy_certs;
  uint8_t pad4_[1];
  uint32_t num_user_certs;

 private:
  friend class mojo::internal::MessageFragment<CertManagementMetadata_Data>;

  CertManagementMetadata_Data();
  ~CertManagementMetadata_Data() = delete;
};
static_assert(sizeof(CertManagementMetadata_Data) == 16,
              "Bad sizeof(CertManagementMetadata_Data)");
// Used by CertManagementMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CertManagementMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CertManagementMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CertManagementMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CertManagementMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CertManagementMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // certificate_manager::mojom

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SHARED_INTERNAL_H_