// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{listenOnce}from"chrome://resources/js/util.js";import{getTemplate}from"./snackbar.html.js";const SHOW_DURATION=5e3;const TRANSITION_DURATION=225;export var SnackbarType;(function(SnackbarType){SnackbarType["INFO"]="info";SnackbarType["SUCCESS"]="success";SnackbarType["WARNING"]="warning";SnackbarType["ERROR"]="error"})(SnackbarType||(SnackbarType={}));class BluetoothSnackbarElement extends CustomElement{static get template(){return getTemplate()}static get is(){return"bluetooth-snackbar"}boundStartTimeout_=null;boundStopTimeout_=null;timeoutId_=null;options_=null;connectedCallback(){assert(this.options_);assert(this.shadowRoot);this.shadowRoot.querySelector("#message").textContent=this.options_.message;this.classList.add(this.options_.type);const actionLink=this.shadowRoot.querySelector("a");actionLink.textContent=this.options_.actionText||"Dismiss";actionLink.addEventListener("click",(()=>{this.options_.action?.();this.dismiss()}));this.boundStartTimeout_=this.startTimeout_.bind(this);this.boundStopTimeout_=this.stopTimeout_.bind(this);this.addEventListener("mouseleave",this.boundStartTimeout_);this.addEventListener("mouseenter",this.boundStopTimeout_);this.timeoutId_=null}initialize(options){this.options_=options}show(){this.classList.add("open");if(hasContentFocus){this.startTimeout_()}else{this.stopTimeout_()}document.addEventListener("contentfocus",this.boundStartTimeout_);document.addEventListener("contentblur",this.boundStopTimeout_);this.dispatchEvent(new CustomEvent("showed",{bubbles:true,composed:true}))}ensureTransitionEndEvent_(){let fired=false;this.addEventListener("transitionend",(()=>{fired=true}),{once:true});window.setTimeout((()=>{if(!fired){this.dispatchEvent(new CustomEvent("transitionend",{bubbles:true,composed:true}))}}),TRANSITION_DURATION)}dismiss(){this.stopTimeout_();if(!this.classList.contains("open")){return Promise.resolve()}return new Promise((resolve=>{listenOnce(this,"transitionend",(()=>{this.dispatchEvent(new CustomEvent("dismissed"));resolve()}));this.ensureTransitionEndEvent_();this.classList.remove("open");document.removeEventListener("contentfocus",this.boundStartTimeout_);document.removeEventListener("contentblur",this.boundStopTimeout_)}))}startTimeout_(){this.timeoutId_=setTimeout((()=>{this.dismiss()}),SHOW_DURATION)}stopTimeout_(){if(this.classList.contains("open")){clearTimeout(this.timeoutId_);this.timeoutId_=null}}}customElements.define("bluetooth-snackbar",BluetoothSnackbarElement);let current=null;const queue=[];let hasContentFocus=true;document.addEventListener("contentfocus",(function(){hasContentFocus=true}));document.addEventListener("contentblur",(function(){hasContentFocus=false}));export function getSnackbarStateForTest(){return{current:current,numPending:queue.length}}export function showSnackbar(message,type,actionText,action){const options={message:message,type:type||SnackbarType.INFO,actionText:actionText,action:action};const newSnackbar=document.createElement("bluetooth-snackbar");newSnackbar.initialize(options);if(current){queue.push(newSnackbar)}else{show(newSnackbar)}return newSnackbar}window["showSnackbar"]=showSnackbar;function show(snackbar){document.body.querySelector("#snackbar-container").appendChild(snackbar);snackbar.addEventListener("dismissed",(function(){const container=document.body.querySelector("#snackbar-container");if(container){container.removeChild(current)}const newSnackbar=queue.shift();if(container&&newSnackbar){show(newSnackbar);return}current=null}));current=snackbar;setTimeout((function(){snackbar.show()}),10)}export function dismissSnackbar(clearQueue){if(clearQueue){queue.length=0}if(current){return current.dismiss()}return Promise.resolve()}