// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{FocusOutlineManager}from"chrome://resources/js/focus_outline_manager.js";import{Page}from"./page.js";export class PageManager{isDialog=false;registeredPages=new Map;observers_=[];defaultPage_=null;constructor(){}initialize(defaultPage){this.defaultPage_=defaultPage;FocusOutlineManager.forDocument(document)}register(page){this.registeredPages.set(page.name.toLowerCase(),page);page.addEventListener("page-hash-changed",(e=>this.onPageHashChanged_(e)));page.initializePage()}unregister(page){this.registeredPages.delete(page.name.toLowerCase())}showDefaultPage(updateHistory){assert(this.defaultPage_ instanceof Page,"PageManager must be initialized with a default page.");this.showPageByName(this.defaultPage_.name,updateHistory)}showPageByName(pageName,updateHistory=true,propertyBag={}){let rootPage=null;for(const page of this.registeredPages.values()){if(page.visible&&!page.parentPage){rootPage=page;break}}const targetPage=this.registeredPages.get(pageName.toLowerCase())??this.defaultPage_;pageName=targetPage.name.toLowerCase();const targetPageWasVisible=targetPage.visible;this.registeredPages.forEach((page=>{if(page.name!==pageName&&!this.isAncestorOfPage(page,targetPage)){page.willHidePage()}}));targetPage.hash=propertyBag.hash||"";this.registeredPages.forEach((page=>{page.visible=page.name===pageName||this.isAncestorOfPage(page,targetPage)}));if(updateHistory){this.updateHistoryState_(!!propertyBag.replaceState)}if(document.activeElement!==document.body&&(!rootPage||rootPage.pageDiv.contains(document.activeElement))){targetPage.focus()}this.registeredPages.forEach((page=>{if(!targetPageWasVisible&&(page.name===pageName||this.isAncestorOfPage(page,targetPage))){page.didShowPage()}}));if(targetPageWasVisible){targetPage.didChangeHash()}this.updateTitle_()}getPageNameFromPath(){const path=location.pathname;if(path.length<=1){return this.defaultPage_.name}return path.slice(1).replace(/\/$/,"")}getNestingLevel(page){let level=0;let parent=page.parentPage;while(parent){level++;parent=parent.parentPage}return level}isAncestorOfPage(potentialAncestor,potentialDescendent){let parent=potentialDescendent.parentPage;while(parent){if(parent===potentialAncestor){return true}parent=parent.parentPage}return false}onPageHashChanged_(e){const page=e.target;if(page===this.getTopmostVisiblePage()){this.updateHistoryState_(false)}}addObserver(observer){this.observers_.push(observer)}getTopmostVisiblePage(){for(const page of this.registeredPages.values()){if(page.visible){return page}}return null}updateTitle_(){let page=this.getTopmostVisiblePage();while(page){if(page.title){for(const observer of this.observers_){observer.updateTitle(page.title)}return}page=page.parentPage}}updateHistoryState_(replace){if(this.isDialog){return}const page=this.getTopmostVisiblePage();assert(page);let path=window.location.pathname+window.location.hash;if(path){path=path.slice(1).replace(/\/(?:#|$)/,"")}const newPath=(page===this.defaultPage_?"":page.name)+page.hash;if(path===newPath){return}for(const observer of this.observers_){observer.updateHistory(newPath,replace)}}static getInstance(){return instance||(instance=new PageManager)}}let instance=null;