// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{getTemplate}from"./object_fieldset.html.js";export class ObjectFieldsetElement extends CustomElement{static get template(){return getTemplate()}static get is(){return"object-fieldset"}static get observedAttributes(){return["data-value","show-all"]}get showAll(){return this.hasAttribute("show-all")}get value(){return this.dataset["value"]?JSON.parse(this.dataset["value"]):null}attributeChangedCallback(name,oldValue,newValue){assert(name==="data-value"||name==="show-all");if(newValue===oldValue||!this.dataset["value"]){return}const fieldset=this.shadowRoot.querySelector("fieldset");fieldset.innerHTML=window.trustedTypes.emptyHTML;const nameMap=JSON.parse(this.dataset["nameMap"]);const valueObject=JSON.parse(this.dataset["value"]);assert(valueObject);Object.keys(valueObject).forEach((propName=>{const value=valueObject[propName];if(value===false&&!this.showAll){return}const name=nameMap[propName]||propName;const newField=document.createElement("div");newField.classList.add("status");const nameDiv=document.createElement("div");nameDiv.textContent=name+":";newField.appendChild(nameDiv);const valueDiv=document.createElement("div");valueDiv.dataset["field"]=propName;if(typeof value==="boolean"){valueDiv.classList.add("toggle-status");valueDiv.classList.toggle("checked",value)}else{valueDiv.textContent=String(value)}newField.appendChild(valueDiv);fieldset.appendChild(newField)}))}}customElements.define("object-fieldset",ObjectFieldsetElement);