// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";export var ConnectionStatus;(function(ConnectionStatus){ConnectionStatus[ConnectionStatus["DISCONNECTED"]=0]="DISCONNECTED";ConnectionStatus[ConnectionStatus["CONNECTING"]=1]="CONNECTING";ConnectionStatus[ConnectionStatus["CONNECTED"]=2]="CONNECTED"})(ConnectionStatus||(ConnectionStatus={}));export class DeviceCollection extends EventTarget{array_;removedDevices_={};constructor(array){super();this.array_=array}get length(){return this.array_.length}item(index){return index<0||index>=this.length?undefined:this.array_[index]}getByAddress(address){for(let i=0;i<this.length;i++){const device=this.array_[i];if(address===device.address){return i}}return-1}addOrUpdate(deviceInfo){this.removedDevices_[deviceInfo.address]=false;const oldDeviceIndex=this.getByAddress(deviceInfo.address);if(oldDeviceIndex!==-1){const oldDeviceInfo=this.array_[oldDeviceIndex];const rssi=deviceInfo.rssi&&deviceInfo.rssi.value||oldDeviceInfo.rssi&&oldDeviceInfo.rssi.value;Object.assign(oldDeviceInfo,deviceInfo);if(rssi!==undefined&&rssi!==null){oldDeviceInfo.rssi={value:rssi}}this.dispatchEvent(new CustomEvent("device-update",{bubbles:true,composed:true,detail:oldDeviceIndex}))}else{this.array_.push(deviceInfo);this.dispatchEvent(new CustomEvent("device-added",{bubbles:true,composed:true,detail:{index:this.length-1,device:deviceInfo}}))}}remove(deviceInfo){const deviceIndex=this.getByAddress(deviceInfo.address);assert(deviceIndex!==-1,"Device does not exist.");this.removedDevices_[deviceInfo.address]=true;this.dispatchEvent(new CustomEvent("device-update",{bubbles:true,composed:true,detail:deviceIndex}))}isRemoved(deviceInfo){return!!this.removedDevices_[deviceInfo.address]}resetForTest(){this.array_=[];this.removedDevices_={};this.dispatchEvent(new CustomEvent("devices-reset-for-test",{bubbles:true,composed:true}))}}