// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getRequiredElement}from"chrome://resources/js/util.js";import{Page}from"./page.js";const LOGS_NOT_SUPPORTED_STRING="Debug logs not supported";export class DebugLogPage extends Page{debugLogsChangeHandler_=null;inputElement_=null;debugContainer_;bluetoothInternalsHandler_;btsnoopInterface_=null;constructor(bluetoothInternalsHandler){super("debug","Debug Logs","debug");this.debugContainer_=getRequiredElement("debug-container");this.bluetoothInternalsHandler_=bluetoothInternalsHandler;this.btsnoopInterface_=null;this.bluetoothInternalsHandler_.getDebugLogsChangeHandler().then((params=>{if(params.handler){this.setUpInput(params.handler,params.initialToggleValue)}else{this.debugContainer_.textContent=LOGS_NOT_SUPPORTED_STRING}}))}setUpInput(handler,initialInputValue){this.debugLogsChangeHandler_=handler;this.inputElement_=document.createElement("input");this.inputElement_.setAttribute("type","checkbox");this.inputElement_.checked=initialInputValue;this.inputElement_.addEventListener("change",this.onToggleChange.bind(this));this.debugContainer_.appendChild(this.inputElement_)}setUpBtmonButton(){const elem=getRequiredElement("btmon-start-btn");elem.addEventListener("click",this.onStartBtsnoopClick.bind(this));this.setBtmonButtonText("Start logging")}setBtmonButtonText(text){const elem=getRequiredElement("btmon-start-btn");elem.textContent=text}setBtmonStatusText(text){const elem=getRequiredElement("btmon-status-bar");elem.textContent=text}onToggleChange(){this.debugLogsChangeHandler_.changeDebugLogsState(this.inputElement_.checked)}onStartBtsnoopClick(){this.btsnoopInterface_?this.onStopBtsnoop():this.onStartBtsnoop()}async onStartBtsnoop(){const{btsnoop:btsnoopInterface}=await this.bluetoothInternalsHandler_.startBtsnoop();if(btsnoopInterface!=null){this.setBtmonStatusText("Logging is ongoing.");this.setBtmonButtonText("Stop logging");this.btsnoopInterface_=btsnoopInterface}else{this.setBtmonStatusText("Fail to start logging.");this.btsnoopInterface_=null}}async onStopBtsnoop(){if(!this.btsnoopInterface_){return}const{success:success}=await this.btsnoopInterface_.stop();if(success){this.setBtmonStatusText("Logging is stopped. Log is saved to Downloads as capture.btsnoop.")}else{this.setBtmonStatusText("Fail to save debug log.")}this.setBtmonButtonText("Start logging");this.btsnoopInterface_=null}async prepareBtsnoopTemplate(){const{enabled:enabled}=await this.bluetoothInternalsHandler_.isBtsnoopFeatureEnabled();if(!enabled){return}this.pageDiv.appendChild(document.importNode(getRequiredElement("btsnoop-template").content,true));this.setUpBtmonButton()}}