// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Custom actions added here also need to be added to
// tools/metrics/actions/actions.xml
export var AppHomeUserAction;
(function (AppHomeUserAction) {
    AppHomeUserAction["APP_HOME_INIT"] = "AppHome_NavigationComplete";
    AppHomeUserAction["CONTEXT_MENU_TRIGGERED"] = "AppHome_CustomContextMenuTriggered";
    AppHomeUserAction["OPEN_IN_WINDOW_CHECKED"] = "AppHome_OpenInWindowChecked";
    AppHomeUserAction["OPEN_IN_WINDOW_UNCHECKED"] = "AppHome_OpenInWindowUnchecked";
    AppHomeUserAction["LAUNCH_AT_STARTUP_CHECKED"] = "AppHome_LaunchAtStartupChecked";
    AppHomeUserAction["LAUNCH_AT_STARTUP_UNCHECKED"] = "AppHome_LaunchAtStartupUnchecked";
    AppHomeUserAction["CREATE_SHORTCUT"] = "AppHome_CreateShortcut";
    AppHomeUserAction["INSTALL_APP_LOCALLY"] = "AppHome_InstallAppLocally";
    AppHomeUserAction["UNINSTALL"] = "AppHome_Uninstall";
    AppHomeUserAction["OPEN_APP_SETTINGS"] = "AppHome_OpenAppSettings";
    AppHomeUserAction["LAUNCH_WEB_APP"] = "AppHome_LaunchApp";
    AppHomeUserAction["LAUNCH_DEPRECATED_APP"] = "AppHome_LaunchDeprecatedApp";
})(AppHomeUserAction || (AppHomeUserAction = {}));
export function recordUserAction(metricName) {
    chrome.metricsPrivate.recordUserAction(metricName);
}
