import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">.body-1{font-size:14px;line-height:20px}.title-1{font-size:16px;line-height:24px}.button-image{margin-inline-end:8px}.center-content{display:flex;justify-content:center;width:100%}.space-1{height:8px}.space-2{height:32px}.text-button:not(:focus){border:none;box-shadow:none}.text-button:hover{background-color:transparent}#buttons cr-button{margin-inline-start:8px}#error-message-container{min-height:16px}#remembered-device-footnote{align-items:center;display:flex;font-size:12px;line-height:18px;justify-content:center}#remembered-device-icon{align-self:flex-start;flex-shrink:0;height:20px;padding-inline-end:16px;width:20px}a[href]{color:var(--color-link-foreground);text-decoration:none}cr-dialog::part(dialog){border-radius:0;height:100%;width:100%}cr-dialog [slot=body]{height:480px}</style>
<cr-dialog id="dialog">
  <div slot="title" class="title-1">$i18n{dialogTitle}</div>
  <div slot="body">
    <div id="codeInputView">
      <div class="body-1">
        $i18n{accessCodeMessage}
        <a href="$i18n{learnMoreUrl}" target="_blank">$i18n{learnMore}</a>
      </div>
      <div class="space-2"></div>
      <div class="center-content">
        <c2c-passcode-input
            aria-label="[[inputLabel]]"
            disabled="[[!canCast]]"
            id="codeInput"
            length="6"
            value="{{accessCode}}"
        ></c2c-passcode-input>
      </div>
      <div class="space-1"></div>
      <template is="dom-if" if="[[qrScannerEnabled]]" class="center-content">
        <div class="center-content">
          <cr-button on-click="switchToQrInput" class="center text-button">
            <cr-icon class="button-image" icon="cr:videocam"></cr-icon>
            $i18n{useCamera}
          </cr-button>
        </div>
      </template>
    </div>
    <div id="qrInputView">
      <div>Camera input view</div>
    </div>
    <div id="error-message-container">
      <c2c-error-message id="errorMessage"></c2c-error-message>
    </div>
    <div class="space-1"></div>
    <template is="dom-if" if="[[rememberDevices]]">
      <div id="remembered-device-footnote">
        <cr-icon icon="cr:domain" id="remembered-device-icon"></cr-icon>
        <div id="remembered-device-content">
          [[managedFootnote]]
        </div>
      </div>
    </template>
  </div>
  <div slot="button-container" id="buttons">
    <template is="dom-if" if="[[!isWin]]">
      <cr-button on-click="cancelButtonPressed">
        $i18n{cancel}
      </cr-button>
    </template>
      <cr-button id="castButton" on-click="addSinkAndCast" class="action-button"
        disabled="[[submitDisabled]]">
        $i18n{cast}
      </cr-button>
      <cr-button id="backButton" on-click="switchToCodeInput"
        class="action-button">
        $i18n{back}
      </cr-button>
    <template is="dom-if" if="[[isWin]]">
      <cr-button on-click="cancelButtonPressed">
        $i18n{cancel}
      </cr-button>
    </template>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}