// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{PageCallbackRouter,PageHandlerFactory,PageHandlerRemote}from"./access_code_cast.mojom-webui.js";const HISTOGRAM_ACCESS_CODE_INPUT_TIME="AccessCodeCast.Ui.AccessCodeInputTime";const HISTOGRAM_CAST_ATTEMPT_LENGTH="AccessCodeCast.Ui.CastAttemptLength";const HISTOGRAM_DIALOG_CLOSE_REASON="AccessCodeCast.Ui.DialogCloseReason";export var DialogCloseReason;(function(DialogCloseReason){DialogCloseReason[DialogCloseReason["LOST_FOCUS"]=0]="LOST_FOCUS";DialogCloseReason[DialogCloseReason["CANCEL_BUTTON"]=1]="CANCEL_BUTTON";DialogCloseReason[DialogCloseReason["CAST_SUCCESS"]=2]="CAST_SUCCESS";DialogCloseReason[DialogCloseReason["COUNT"]=3]="COUNT"})(DialogCloseReason||(DialogCloseReason={}));export class BrowserProxy{callbackRouter;handler;constructor(omitHandler){if(omitHandler){return}this.callbackRouter=new PageCallbackRouter;this.handler=new PageHandlerRemote;const factory=PageHandlerFactory.getRemote();factory.createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(),this.handler.$.bindNewPipeAndPassReceiver())}closeDialog(){chrome.send("dialogClose")}getDialogArgs(){return JSON.parse(chrome.getVariableValue("dialogArguments"))}isDialog(){return chrome.getVariableValue("dialogArguments").length>0}isBarcodeApiAvailable(){return"BarcodeDetector"in window}async isQrScanningAvailable(){return loadTimeData.getBoolean("qrScannerEnabled")&&this.isBarcodeApiAvailable()&&await this.isCameraAvailable()}async isCameraAvailable(){const devices=await navigator.mediaDevices.enumerateDevices();for(const device of devices){if(device.kind==="videoinput"){return true}}return false}static recordAccessCodeEntryTime(time){if(time<0){return}chrome.send("metricsHandler:recordMediumTime",[HISTOGRAM_ACCESS_CODE_INPUT_TIME,time])}static recordCastAttemptLength(time){if(time<0){return}chrome.send("metricsHandler:recordMediumTime",[HISTOGRAM_CAST_ATTEMPT_LENGTH,time])}static recordDialogCloseReason(reason){chrome.send("metricsHandler:recordInHistogram",[HISTOGRAM_DIALOG_CLOSE_REASON,reason,DialogCloseReason.COUNT])}static getInstance(){return instance||(instance=new BrowserProxy)}static setInstance(obj){instance=obj}}let instance=null;