// chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-params-data.h"
#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-shared-message-ids.h"

#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-import-headers.h"
#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-test-utils.h"


namespace ntp::tab_groups::mojom {
TabGroup::TabGroup()
    : id(),
      title(),
      update_time(),
      device_name(),
      total_tab_count(),
      color(),
      favicon_urls(),
      is_shared_tab_group() {}

TabGroup::TabGroup(
    const std::string& id_in,
    const std::string& title_in,
    const std::string& update_time_in,
    const std::optional<std::string>& device_name_in,
    int32_t total_tab_count_in,
    ::tab_groups::TabGroupColorId color_in,
    std::vector<::GURL> favicon_urls_in,
    bool is_shared_tab_group_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      update_time(std::move(update_time_in)),
      device_name(std::move(device_name_in)),
      total_tab_count(std::move(total_tab_count_in)),
      color(std::move(color_in)),
      favicon_urls(std::move(favicon_urls_in)),
      is_shared_tab_group(std::move(is_shared_tab_group_in)) {}

TabGroup::~TabGroup() = default;

void TabGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_time"), this->update_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_name"), this->device_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_tab_count"), this->total_tab_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tab_groups::TabGroupColorId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_urls"), this->favicon_urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_shared_tab_group"), this->is_shared_tab_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kCreateNewTabGroup: {
      return &PageHandler::CreateNewTabGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabGroups: {
      return &PageHandler::GetTabGroups_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenTabGroup: {
      return &PageHandler::OpenTabGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDismissModule: {
      return &PageHandler::DismissModule_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRestoreModule: {
      return &PageHandler::RestoreModule_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCreateNewTabGroup:
            return "Receive ntp::tab_groups::mojom::PageHandler::CreateNewTabGroup";
      case messages::PageHandler::kGetTabGroups:
            return "Receive ntp::tab_groups::mojom::PageHandler::GetTabGroups";
      case messages::PageHandler::kOpenTabGroup:
            return "Receive ntp::tab_groups::mojom::PageHandler::OpenTabGroup";
      case messages::PageHandler::kDismissModule:
            return "Receive ntp::tab_groups::mojom::PageHandler::DismissModule";
      case messages::PageHandler::kRestoreModule:
            return "Receive ntp::tab_groups::mojom::PageHandler::RestoreModule";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCreateNewTabGroup:
            return "Receive reply ntp::tab_groups::mojom::PageHandler::CreateNewTabGroup";
      case messages::PageHandler::kGetTabGroups:
            return "Receive reply ntp::tab_groups::mojom::PageHandler::GetTabGroups";
      case messages::PageHandler::kOpenTabGroup:
            return "Receive reply ntp::tab_groups::mojom::PageHandler::OpenTabGroup";
      case messages::PageHandler::kDismissModule:
            return "Receive reply ntp::tab_groups::mojom::PageHandler::DismissModule";
      case messages::PageHandler::kRestoreModule:
            return "Receive reply ntp::tab_groups::mojom::PageHandler::RestoreModule";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::CreateNewTabGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4fa67e62;  // IPCStableHash for ntp::tab_groups::mojom::PageHandler::CreateNewTabGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18ddbe82;  // IPCStableHash for ntp::tab_groups::mojom::PageHandler::GetTabGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenTabGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x860654a7;  // IPCStableHash for ntp::tab_groups::mojom::PageHandler::OpenTabGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DismissModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d10a026;  // IPCStableHash for ntp::tab_groups::mojom::PageHandler::DismissModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RestoreModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2c23280;  // IPCStableHash for ntp::tab_groups::mojom::PageHandler::RestoreModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetTabGroups_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabGroups_ForwardToCallback(
      PageHandler::GetTabGroupsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabGroups_ForwardToCallback(const PageHandler_GetTabGroups_ForwardToCallback&) = delete;
  PageHandler_GetTabGroups_ForwardToCallback& operator=(const PageHandler_GetTabGroups_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabGroupsCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::CreateNewTabGroup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::tab_groups::mojom::PageHandler::CreateNewTabGroup");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCreateNewTabGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_CreateNewTabGroup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CreateNewTabGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetTabGroups(
    GetTabGroupsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::tab_groups::mojom::PageHandler::GetTabGroups");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_GetTabGroups_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabGroups");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabGroups_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenTabGroup(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ntp::tab_groups::mojom::PageHandler::OpenTabGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenTabGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_OpenTabGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in PageHandler.OpenTabGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenTabGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DismissModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::tab_groups::mojom::PageHandler::DismissModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDismissModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_DismissModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DismissModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RestoreModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::tab_groups::mojom::PageHandler::RestoreModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRestoreModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_RestoreModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RestoreModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetTabGroups_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabGroupsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabGroups_ProxyToResponder> proxy(
        new PageHandler_GetTabGroups_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabGroups_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabGroups_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabGroups_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabGroupsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<std::vector<TabGroupPtr>> in_tab_groups, bool in_showZeroState);
};

bool PageHandler_GetTabGroups_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabGroups_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabGroups_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  std::optional<std::vector<TabGroupPtr>> p_tab_groups{};
  bool p_showZeroState{};
  PageHandler_GetTabGroups_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTabGroups(&p_tab_groups))
    success = false;
  if (success)
    p_showZeroState = input_data_view.showZeroState();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tab_groups), 
std::move(p_showZeroState));
  }
  return true;
}

void PageHandler_GetTabGroups_ProxyToResponder::Run(
    std::optional<std::vector<TabGroupPtr>> in_tab_groups, bool in_showZeroState) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ntp::tab_groups::mojom::PageHandler::GetTabGroups", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_groups"), in_tab_groups,
                        "<value of type std::optional<std::vector<TabGroupPtr>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("showZeroState"), in_showZeroState,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::tab_groups::mojom::internal::PageHandler_GetTabGroups_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_groups)::BaseType>
      tab_groups_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tab_groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp::tab_groups::mojom::TabGroupDataView>>(
    in_tab_groups,
    tab_groups_fragment,
    &tab_groups_validate_params);

  params->tab_groups.Set(
      tab_groups_fragment.is_null() ? nullptr : tab_groups_fragment.data());

  params->showZeroState = in_showZeroState;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabGroups");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCreateNewTabGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CreateNewTabGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CreateNewTabGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_CreateNewTabGroup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewTabGroup(        );
      return true;
    }
    case messages::PageHandler::kGetTabGroups: {
      break;
    }
    case messages::PageHandler::kOpenTabGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenTabGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenTabGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_id{};
      PageHandler_OpenTabGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenTabGroup(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kDismissModule: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DismissModule_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DismissModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_DismissModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DismissModule(        );
      return true;
    }
    case messages::PageHandler::kRestoreModule: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RestoreModule_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RestoreModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_RestoreModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestoreModule(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCreateNewTabGroup: {
      break;
    }
    case messages::PageHandler::kGetTabGroups: {
      internal::PageHandler_GetTabGroups_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabGroups_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_GetTabGroups_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabGroups_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabGroups(std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenTabGroup: {
      break;
    }
    case messages::PageHandler::kDismissModule: {
      break;
    }
    case messages::PageHandler::kRestoreModule: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_CreateNewTabGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetTabGroups_Params_Data::Validate,
     &internal::PageHandler_GetTabGroups_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenTabGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DismissModule_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RestoreModule_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ntp::tab_groups::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::ntp::tab_groups::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}


}  // ntp::tab_groups::mojom


namespace mojo {


// static
bool StructTraits<::ntp::tab_groups::mojom::TabGroup::DataView, ::ntp::tab_groups::mojom::TabGroupPtr>::Read(
    ::ntp::tab_groups::mojom::TabGroup::DataView input,
    ::ntp::tab_groups::mojom::TabGroupPtr* output) {
  bool success = true;
  ::ntp::tab_groups::mojom::TabGroupPtr result(::ntp::tab_groups::mojom::TabGroup::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUpdateTime(&result->update_time))
        success = false;
      if (success && !input.ReadDeviceName(&result->device_name))
        success = false;
      if (success)
        result->total_tab_count = input.total_tab_count();
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadFaviconUrls(&result->favicon_urls))
        success = false;
      if (success)
        result->is_shared_tab_group = input.is_shared_tab_group();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ntp::tab_groups::mojom {


void PageHandlerInterceptorForTesting::CreateNewTabGroup() {
  GetForwardingInterface()->CreateNewTabGroup();
}
void PageHandlerInterceptorForTesting::GetTabGroups(GetTabGroupsCallback callback) {
  GetForwardingInterface()->GetTabGroups(std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenTabGroup(const std::string& id) {
  GetForwardingInterface()->OpenTabGroup(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::DismissModule() {
  GetForwardingInterface()->DismissModule();
}
void PageHandlerInterceptorForTesting::RestoreModule() {
  GetForwardingInterface()->RestoreModule();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetTabGroups(
    std::optional<std::vector<TabGroupPtr>>* out_tab_groups, bool* out_showZeroState) {
  base::RunLoop loop;
  proxy_->GetTabGroups(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<TabGroupPtr>>* out_tab_groups
,
             bool* out_showZeroState
,
             std::optional<std::vector<TabGroupPtr>> tab_groups,
             bool showZeroState) {*out_tab_groups = std::move(tab_groups);*out_showZeroState = std::move(showZeroState);
            loop->Quit();
          },
          &loop,
          out_tab_groups,
          out_showZeroState));
  loop.Run();
}








}  // ntp::tab_groups::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif