// chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_SHARED_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-shared-internal.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/new_tab_page/modules/v2/tab_groups/tab_groups.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ntp::tab_groups::mojom::TabGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ntp::tab_groups::mojom::TabGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ntp::tab_groups::mojom::internal::TabGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabGroup struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroup struct");

    decltype(Traits::update_time(input)) in_update_time = Traits::update_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_time)::BaseType> update_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_update_time,
      update_time_fragment);

    fragment->update_time.Set(
        update_time_fragment.is_null() ? nullptr : update_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->update_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null update_time in TabGroup struct");

    decltype(Traits::device_name(input)) in_device_name = Traits::device_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_name)::BaseType> device_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_name,
      device_name_fragment);

    fragment->device_name.Set(
        device_name_fragment.is_null() ? nullptr : device_name_fragment.data());

    fragment->total_tab_count = Traits::total_tab_count(input);

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    decltype(Traits::favicon_urls(input)) in_favicon_urls = Traits::favicon_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_urls)::BaseType>
        favicon_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& favicon_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_favicon_urls,
      favicon_urls_fragment,
      &favicon_urls_validate_params);

    fragment->favicon_urls.Set(
        favicon_urls_fragment.is_null() ? nullptr : favicon_urls_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_urls.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_urls in TabGroup struct");

    fragment->is_shared_tab_group = Traits::is_shared_tab_group(input);
  }

  static bool Deserialize(::ntp::tab_groups::mojom::internal::TabGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ntp::tab_groups::mojom::TabGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ntp::tab_groups::mojom {

inline void TabGroupDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupDataView::GetUpdateTimeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->update_time.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabGroupDataView::GetFaviconUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->favicon_urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}



}  // ntp::tab_groups::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_TAB_GROUPS_TAB_GROUPS_MOJOM_SHARED_H_