// chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/url_visit_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_MOST_RELEVANT_TAB_RESUMPTION_URL_VISIT_TYPES_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_MOST_RELEVANT_TAB_RESUMPTION_URL_VISIT_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/url_visit_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace ntp::most_relevant_tab_resumption::mojom {
class DecorationDataView;

class URLVisitDataView;



}  // ntp::most_relevant_tab_resumption::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ntp::most_relevant_tab_resumption::mojom::DecorationDataView> {
  using Data = ::ntp::most_relevant_tab_resumption::mojom::internal::Decoration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ntp::most_relevant_tab_resumption::mojom::URLVisitDataView> {
  using Data = ::ntp::most_relevant_tab_resumption::mojom::internal::URLVisit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ntp::most_relevant_tab_resumption::mojom {


enum class FormFactor : int32_t {
  
  kUnknown = 0,
  
  kDesktop = 1,
  
  kPhone = 2,
  
  kTablet = 3,
  
  kAutomotive = 4,
  
  kWearable = 5,
  
  kTv = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, FormFactor value);
inline bool IsKnownEnumValue(FormFactor value) {
  return internal::FormFactor_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DecorationType : int32_t {
  
  kVisitedXAgo = 0,
  
  kMostRecent = 1,
  
  kFrequentlyVisited = 2,
  
  kFrequentlyVisitedAtTime = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DecorationType value);
inline bool IsKnownEnumValue(DecorationType value) {
  return internal::DecorationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VisitSource : int32_t {
  
  kTab = 0,
  
  kHistory = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VisitSource value);
inline bool IsKnownEnumValue(VisitSource value) {
  return internal::VisitSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DecorationDataView {
 public:
  DecorationDataView() = default;

  DecorationDataView(
      internal::Decoration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ntp::most_relevant_tab_resumption::mojom::DecorationType>(
        data_value, output);
  }
  DecorationType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ntp::most_relevant_tab_resumption::mojom::DecorationType>(data_->type));
  }
  inline void GetDisplayStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayString(UserType* output) {
    
    auto* pointer = data_->display_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decoration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLVisitDataView {
 public:
  URLVisitDataView() = default;

  URLVisitDataView(
      internal::URLVisit_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormFactor(UserType* output) const {
    auto data_value = data_->form_factor;
    return mojo::internal::Deserialize<::ntp::most_relevant_tab_resumption::mojom::FormFactor>(
        data_value, output);
  }
  FormFactor form_factor() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ntp::most_relevant_tab_resumption::mojom::FormFactor>(data_->form_factor));
  }
  bool is_known_to_sync() const {
    return data_->is_known_to_sync;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::ntp::most_relevant_tab_resumption::mojom::VisitSource>(
        data_value, output);
  }
  VisitSource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ntp::most_relevant_tab_resumption::mojom::VisitSource>(data_->source));
  }
  inline void GetSessionNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `session_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSessionName` instead "
    "of `ReadSessionName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->session_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDecorationDataView(
      DecorationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecoration(UserType* output) {
    
    auto* pointer = data_->decoration.Get();
    return mojo::internal::Deserialize<::ntp::most_relevant_tab_resumption::mojom::DecorationDataView>(
        pointer, output, message_);
  }
  inline void GetRelativeTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeTime(UserType* output) {
    
    auto* pointer = data_->relative_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimestamp` instead "
    "of `ReadTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetUrlKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlKey(UserType* output) {
    
    auto* pointer = data_->url_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t training_request_id() const {
    return data_->training_request_id;
  }
 private:
  internal::URLVisit_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ntp::most_relevant_tab_resumption::mojom

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_MOST_RELEVANT_TAB_RESUMPTION_URL_VISIT_TYPES_MOJOM_DATA_VIEW_H_