// chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/most_relevant_tab_resumption.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  URLVisitSpec as ntp_mostRelevantTabResumption_mojom_URLVisitSpec,
  URLVisit as ntp_mostRelevantTabResumption_mojom_URLVisit
} from './url_visit_types.mojom-webui.js';





export const ScoredURLUserActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ScoredURLUserAction {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kUnknown = 0,
  kSeen = 1,
  kActivated = 2,
  kDismissed = 3,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'ntp.most_relevant_tab_resumption.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getURLVisits(): Promise<{
        urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[], }>;
  dismissModule(urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[]): void;
  dismissURLVisit(urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit): void;
  restoreModule(urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[]): void;
  restoreURLVisit(urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit): void;
  recordAction(action: ScoredURLUserAction, urlKey: string, visitRequestId: bigint): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getURLVisits(): Promise<{
        urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[], }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetURLVisits_ParamsSpec.$,
        PageHandler_GetURLVisits_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  dismissModule(
      urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[]): void {
    this.proxy.sendMessage(
        1,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        [
          urlVisits
        ],
        false);
  }

  dismissURLVisit(
      urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit): void {
    this.proxy.sendMessage(
        2,
        PageHandler_DismissURLVisit_ParamsSpec.$,
        null,
        [
          urlVisit
        ],
        false);
  }

  restoreModule(
      urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[]): void {
    this.proxy.sendMessage(
        3,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        [
          urlVisits
        ],
        false);
  }

  restoreURLVisit(
      urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RestoreURLVisit_ParamsSpec.$,
        null,
        [
          urlVisit
        ],
        false);
  }

  recordAction(
      action: ScoredURLUserAction,
      urlKey: string,
      visitRequestId: bigint): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RecordAction_ParamsSpec.$,
        null,
        [
          action,
          urlKey,
          visitRequestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetURLVisits_ParamsSpec.$,
        PageHandler_GetURLVisits_ResponseParamsSpec.$,
        impl.getURLVisits.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        impl.dismissModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_DismissURLVisit_ParamsSpec.$,
        null,
        impl.dismissURLVisit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        impl.restoreModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RestoreURLVisit_ParamsSpec.$,
        null,
        impl.restoreURLVisit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RecordAction_ParamsSpec.$,
        null,
        impl.recordAction.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "ntp.most_relevant_tab_resumption.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getURLVisits: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dismissModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dismissURLVisit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restoreModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restoreURLVisit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getURLVisits =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetURLVisits_ParamsSpec.$,
        PageHandler_GetURLVisits_ResponseParamsSpec.$,
        this.getURLVisits.createReceiverHandler(true /* expectsResponse */),
        false);
    this.dismissModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_DismissModule_ParamsSpec.$,
        null,
        this.dismissModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.dismissURLVisit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_DismissURLVisit_ParamsSpec.$,
        null,
        this.dismissURLVisit.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restoreModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_RestoreModule_ParamsSpec.$,
        null,
        this.restoreModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restoreURLVisit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RestoreURLVisit_ParamsSpec.$,
        null,
        this.restoreURLVisit.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RecordAction_ParamsSpec.$,
        null,
        this.recordAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandler_GetURLVisits_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetURLVisits_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DismissModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DismissURLVisit_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RestoreModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RestoreURLVisit_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandler_GetURLVisits_ParamsMojoType {
}


export type PageHandler_GetURLVisits_Params = PageHandler_GetURLVisits_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetURLVisits_ParamsMojoType>(
    PageHandler_GetURLVisits_ParamsSpec.$,
    'PageHandler_GetURLVisits_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetURLVisits_ResponseParamsMojoType {
  urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[];
}


export type PageHandler_GetURLVisits_ResponseParams = PageHandler_GetURLVisits_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetURLVisits_ResponseParamsMojoType>(
    PageHandler_GetURLVisits_ResponseParamsSpec.$,
    'PageHandler_GetURLVisits_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetURLVisits_ResponseParamsMojoType, ntp_mostRelevantTabResumption_mojom_URLVisit[]>(
        'urlVisits', 0,
        0,
        mojo.internal.Array(ntp_mostRelevantTabResumption_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DismissModule_ParamsMojoType {
  urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[];
}


export type PageHandler_DismissModule_Params = PageHandler_DismissModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_DismissModule_ParamsMojoType>(
    PageHandler_DismissModule_ParamsSpec.$,
    'PageHandler_DismissModule_Params',
    [
      mojo.internal.StructField<PageHandler_DismissModule_ParamsMojoType, ntp_mostRelevantTabResumption_mojom_URLVisit[]>(
        'urlVisits', 0,
        0,
        mojo.internal.Array(ntp_mostRelevantTabResumption_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DismissURLVisit_ParamsMojoType {
  urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit;
}


export type PageHandler_DismissURLVisit_Params = PageHandler_DismissURLVisit_ParamsMojoType;
mojo.internal.Struct<PageHandler_DismissURLVisit_ParamsMojoType>(
    PageHandler_DismissURLVisit_ParamsSpec.$,
    'PageHandler_DismissURLVisit_Params',
    [
      mojo.internal.StructField<PageHandler_DismissURLVisit_ParamsMojoType, ntp_mostRelevantTabResumption_mojom_URLVisit>(
        'urlVisit', 0,
        0,
        ntp_mostRelevantTabResumption_mojom_URLVisitSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RestoreModule_ParamsMojoType {
  urlVisits: ntp_mostRelevantTabResumption_mojom_URLVisit[];
}


export type PageHandler_RestoreModule_Params = PageHandler_RestoreModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_RestoreModule_ParamsMojoType>(
    PageHandler_RestoreModule_ParamsSpec.$,
    'PageHandler_RestoreModule_Params',
    [
      mojo.internal.StructField<PageHandler_RestoreModule_ParamsMojoType, ntp_mostRelevantTabResumption_mojom_URLVisit[]>(
        'urlVisits', 0,
        0,
        mojo.internal.Array(ntp_mostRelevantTabResumption_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RestoreURLVisit_ParamsMojoType {
  urlVisit: ntp_mostRelevantTabResumption_mojom_URLVisit;
}


export type PageHandler_RestoreURLVisit_Params = PageHandler_RestoreURLVisit_ParamsMojoType;
mojo.internal.Struct<PageHandler_RestoreURLVisit_ParamsMojoType>(
    PageHandler_RestoreURLVisit_ParamsSpec.$,
    'PageHandler_RestoreURLVisit_Params',
    [
      mojo.internal.StructField<PageHandler_RestoreURLVisit_ParamsMojoType, ntp_mostRelevantTabResumption_mojom_URLVisit>(
        'urlVisit', 0,
        0,
        ntp_mostRelevantTabResumption_mojom_URLVisitSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordAction_ParamsMojoType {
  action: ScoredURLUserAction;
  urlKey: string;
  visitRequestId: bigint;
}


export type PageHandler_RecordAction_Params = PageHandler_RecordAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordAction_ParamsMojoType>(
    PageHandler_RecordAction_ParamsSpec.$,
    'PageHandler_RecordAction_Params',
    [
      mojo.internal.StructField<PageHandler_RecordAction_ParamsMojoType, ScoredURLUserAction>(
        'action', 0,
        0,
        ScoredURLUserActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordAction_ParamsMojoType, string>(
        'urlKey', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordAction_ParamsMojoType, bigint>(
        'visitRequestId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);



