// chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-params-data.h"
#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-shared-message-ids.h"

#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-import-headers.h"
#include "chrome/browser/new_tab_page/modules/safe_browsing/safe_browsing.mojom-test-utils.h"


namespace ntp::safe_browsing::mojom {
// The declaration includes the definition on other builds.

SafeBrowsingHandler::IPCStableHashFunction SafeBrowsingHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SafeBrowsingHandler>(message.name())) {
    case messages::SafeBrowsingHandler::kCanShowModule: {
      return &SafeBrowsingHandler::CanShowModule_Sym::IPCStableHash;
    }
    case messages::SafeBrowsingHandler::kProcessModuleClick: {
      return &SafeBrowsingHandler::ProcessModuleClick_Sym::IPCStableHash;
    }
    case messages::SafeBrowsingHandler::kDismissModule: {
      return &SafeBrowsingHandler::DismissModule_Sym::IPCStableHash;
    }
    case messages::SafeBrowsingHandler::kRestoreModule: {
      return &SafeBrowsingHandler::RestoreModule_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SafeBrowsingHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SafeBrowsingHandler>(message.name())) {
      case messages::SafeBrowsingHandler::kCanShowModule:
            return "Receive ntp::safe_browsing::mojom::SafeBrowsingHandler::CanShowModule";
      case messages::SafeBrowsingHandler::kProcessModuleClick:
            return "Receive ntp::safe_browsing::mojom::SafeBrowsingHandler::ProcessModuleClick";
      case messages::SafeBrowsingHandler::kDismissModule:
            return "Receive ntp::safe_browsing::mojom::SafeBrowsingHandler::DismissModule";
      case messages::SafeBrowsingHandler::kRestoreModule:
            return "Receive ntp::safe_browsing::mojom::SafeBrowsingHandler::RestoreModule";
    }
  } else {
    switch (static_cast<messages::SafeBrowsingHandler>(message.name())) {
      case messages::SafeBrowsingHandler::kCanShowModule:
            return "Receive reply ntp::safe_browsing::mojom::SafeBrowsingHandler::CanShowModule";
      case messages::SafeBrowsingHandler::kProcessModuleClick:
            return "Receive reply ntp::safe_browsing::mojom::SafeBrowsingHandler::ProcessModuleClick";
      case messages::SafeBrowsingHandler::kDismissModule:
            return "Receive reply ntp::safe_browsing::mojom::SafeBrowsingHandler::DismissModule";
      case messages::SafeBrowsingHandler::kRestoreModule:
            return "Receive reply ntp::safe_browsing::mojom::SafeBrowsingHandler::RestoreModule";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SafeBrowsingHandler::CanShowModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3feecd6;  // IPCStableHash for ntp::safe_browsing::mojom::SafeBrowsingHandler::CanShowModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeBrowsingHandler::ProcessModuleClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35f4d2df;  // IPCStableHash for ntp::safe_browsing::mojom::SafeBrowsingHandler::ProcessModuleClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeBrowsingHandler::DismissModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x514173f0;  // IPCStableHash for ntp::safe_browsing::mojom::SafeBrowsingHandler::DismissModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeBrowsingHandler::RestoreModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x230aeb26;  // IPCStableHash for ntp::safe_browsing::mojom::SafeBrowsingHandler::RestoreModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SafeBrowsingHandler_CanShowModule_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeBrowsingHandler_CanShowModule_ForwardToCallback(
      SafeBrowsingHandler::CanShowModuleCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeBrowsingHandler_CanShowModule_ForwardToCallback(const SafeBrowsingHandler_CanShowModule_ForwardToCallback&) = delete;
  SafeBrowsingHandler_CanShowModule_ForwardToCallback& operator=(const SafeBrowsingHandler_CanShowModule_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeBrowsingHandler::CanShowModuleCallback callback_;
};

SafeBrowsingHandlerProxy::SafeBrowsingHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SafeBrowsingHandlerProxy::CanShowModule(
    CanShowModuleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::safe_browsing::mojom::SafeBrowsingHandler::CanShowModule");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingHandler::kCanShowModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::safe_browsing::mojom::internal::SafeBrowsingHandler_CanShowModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingHandler::Name_);
  message.set_method_name("CanShowModule");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeBrowsingHandler_CanShowModule_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SafeBrowsingHandlerProxy::ProcessModuleClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::safe_browsing::mojom::SafeBrowsingHandler::ProcessModuleClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingHandler::kProcessModuleClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::safe_browsing::mojom::internal::SafeBrowsingHandler_ProcessModuleClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingHandler::Name_);
  message.set_method_name("ProcessModuleClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SafeBrowsingHandlerProxy::DismissModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::safe_browsing::mojom::SafeBrowsingHandler::DismissModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingHandler::kDismissModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::safe_browsing::mojom::internal::SafeBrowsingHandler_DismissModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingHandler::Name_);
  message.set_method_name("DismissModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SafeBrowsingHandlerProxy::RestoreModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp::safe_browsing::mojom::SafeBrowsingHandler::RestoreModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingHandler::kRestoreModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::safe_browsing::mojom::internal::SafeBrowsingHandler_RestoreModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingHandler::Name_);
  message.set_method_name("RestoreModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SafeBrowsingHandler_CanShowModule_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeBrowsingHandler::CanShowModuleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeBrowsingHandler_CanShowModule_ProxyToResponder> proxy(
        new SafeBrowsingHandler_CanShowModule_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeBrowsingHandler_CanShowModule_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeBrowsingHandler_CanShowModule_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeBrowsingHandler_CanShowModule_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeBrowsingHandler::CanShowModuleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_show);
};

bool SafeBrowsingHandler_CanShowModule_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeBrowsingHandler_CanShowModule_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeBrowsingHandler_CanShowModule_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeBrowsingHandler.0
  bool success = true;
  bool p_show{};
  SafeBrowsingHandler_CanShowModule_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_show = input_data_view.show();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeBrowsingHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_show));
  }
  return true;
}

void SafeBrowsingHandler_CanShowModule_ProxyToResponder::Run(
    bool in_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ntp::safe_browsing::mojom::SafeBrowsingHandler::CanShowModule", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show"), in_show,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsingHandler::kCanShowModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp::safe_browsing::mojom::internal::SafeBrowsingHandler_CanShowModule_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->show = in_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsingHandler::Name_);
  message.set_method_name("CanShowModule");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SafeBrowsingHandlerStubDispatch::Accept(
    SafeBrowsingHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SafeBrowsingHandler>(message->header()->name)) {
    case messages::SafeBrowsingHandler::kCanShowModule: {
      break;
    }
    case messages::SafeBrowsingHandler::kProcessModuleClick: {
      DCHECK(message->is_serialized());
      internal::SafeBrowsingHandler_ProcessModuleClick_Params_Data* params =
          reinterpret_cast<internal::SafeBrowsingHandler_ProcessModuleClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SafeBrowsingHandler.1
      bool success = true;
      SafeBrowsingHandler_ProcessModuleClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsingHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessModuleClick(        );
      return true;
    }
    case messages::SafeBrowsingHandler::kDismissModule: {
      DCHECK(message->is_serialized());
      internal::SafeBrowsingHandler_DismissModule_Params_Data* params =
          reinterpret_cast<internal::SafeBrowsingHandler_DismissModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SafeBrowsingHandler.2
      bool success = true;
      SafeBrowsingHandler_DismissModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsingHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DismissModule(        );
      return true;
    }
    case messages::SafeBrowsingHandler::kRestoreModule: {
      DCHECK(message->is_serialized());
      internal::SafeBrowsingHandler_RestoreModule_Params_Data* params =
          reinterpret_cast<internal::SafeBrowsingHandler_RestoreModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SafeBrowsingHandler.3
      bool success = true;
      SafeBrowsingHandler_RestoreModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsingHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestoreModule(        );
      return true;
    }
  }
  return false;
}

// static
bool SafeBrowsingHandlerStubDispatch::AcceptWithResponder(
    SafeBrowsingHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SafeBrowsingHandler>(message->header()->name)) {
    case messages::SafeBrowsingHandler::kCanShowModule: {
      internal::SafeBrowsingHandler_CanShowModule_Params_Data* params =
          reinterpret_cast<
              internal::SafeBrowsingHandler_CanShowModule_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeBrowsingHandler.0
      bool success = true;
      SafeBrowsingHandler_CanShowModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsingHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          SafeBrowsingHandler_CanShowModule_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanShowModule(std::move(callback));
      return true;
    }
    case messages::SafeBrowsingHandler::kProcessModuleClick: {
      break;
    }
    case messages::SafeBrowsingHandler::kDismissModule: {
      break;
    }
    case messages::SafeBrowsingHandler::kRestoreModule: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSafeBrowsingHandlerValidationInfo[] = {
    { &internal::SafeBrowsingHandler_CanShowModule_Params_Data::Validate,
     &internal::SafeBrowsingHandler_CanShowModule_ResponseParams_Data::Validate},
    { &internal::SafeBrowsingHandler_ProcessModuleClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SafeBrowsingHandler_DismissModule_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SafeBrowsingHandler_RestoreModule_Params_Data::Validate,
     nullptr /* no response */},
};

bool SafeBrowsingHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ntp::safe_browsing::mojom::SafeBrowsingHandler::Name_,
    kSafeBrowsingHandlerValidationInfo);
}

bool SafeBrowsingHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::ntp::safe_browsing::mojom::SafeBrowsingHandler::Name_,
    kSafeBrowsingHandlerValidationInfo);
}


}  // ntp::safe_browsing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ntp::safe_browsing::mojom {


void SafeBrowsingHandlerInterceptorForTesting::CanShowModule(CanShowModuleCallback callback) {
  GetForwardingInterface()->CanShowModule(std::move(callback));
}
void SafeBrowsingHandlerInterceptorForTesting::ProcessModuleClick() {
  GetForwardingInterface()->ProcessModuleClick();
}
void SafeBrowsingHandlerInterceptorForTesting::DismissModule() {
  GetForwardingInterface()->DismissModule();
}
void SafeBrowsingHandlerInterceptorForTesting::RestoreModule() {
  GetForwardingInterface()->RestoreModule();
}
SafeBrowsingHandlerAsyncWaiter::SafeBrowsingHandlerAsyncWaiter(
    SafeBrowsingHandler* proxy) : proxy_(proxy) {}

SafeBrowsingHandlerAsyncWaiter::~SafeBrowsingHandlerAsyncWaiter() = default;


void SafeBrowsingHandlerAsyncWaiter::CanShowModule(
    bool* out_show) {
  base::RunLoop loop;
  proxy_->CanShowModule(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_show
,
             bool show) {*out_show = std::move(show);
            loop->Quit();
          },
          &loop,
          out_show));
  loop.Run();
}

bool SafeBrowsingHandlerAsyncWaiter::CanShowModule(
    ) {
  bool async_wait_result;
  CanShowModule(&async_wait_result);
  return async_wait_result;
}






}  // ntp::safe_browsing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif