// chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace file_suggestion::mojom {








class  File {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<File, T>::value>;
  using DataView = FileDataView;
  using Data_ = internal::File_Data;

  template <typename... Args>
  static FilePtr New(Args&&... args) {
    return FilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilePtr From(const U& u) {
    return mojo::TypeConverter<FilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, File>::Convert(*this);
  }


  File();

  File(
      const std::string& id,
      const std::string& justification_text,
      const ::GURL& icon_url,
      const std::string& title,
      const ::GURL& item_url,
      std::optional<RecommendationType> recommendation_type);


  ~File();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilePtr>
  FilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, File::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        File::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        File::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        File::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<File::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return File::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::File_UnserializedMessageContext<
            UserType, File::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<File::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string justification_text;
  
  ::GURL icon_url;
  
  std::string title;
  
  ::GURL item_url;
  
  std::optional<RecommendationType> recommendation_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, File::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FilePtr File::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(justification_text),
      mojo::Clone(icon_url),
      mojo::Clone(title),
      mojo::Clone(item_url),
      mojo::Clone(recommendation_type)
  );
}

template <typename T, File::EnableIfSame<T>*>
bool File::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->justification_text, other_struct.justification_text))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->item_url, other_struct.item_url))
    return false;
  if (!mojo::Equals(this->recommendation_type, other_struct.recommendation_type))
    return false;
  return true;
}

template <typename T, File::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.justification_text < rhs.justification_text)
    return true;
  if (rhs.justification_text < lhs.justification_text)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.item_url < rhs.item_url)
    return true;
  if (rhs.item_url < lhs.item_url)
    return false;
  if (lhs.recommendation_type < rhs.recommendation_type)
    return true;
  if (rhs.recommendation_type < lhs.recommendation_type)
    return false;
  return false;
}


}  // file_suggestion::mojom

namespace mojo {


template <>
struct  StructTraits<::file_suggestion::mojom::File::DataView,
                                         ::file_suggestion::mojom::FilePtr> {
  static bool IsNull(const ::file_suggestion::mojom::FilePtr& input) { return !input; }
  static void SetToNull(::file_suggestion::mojom::FilePtr* output) { output->reset(); }

  static const decltype(::file_suggestion::mojom::File::id)& id(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->id;
  }

  static const decltype(::file_suggestion::mojom::File::justification_text)& justification_text(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->justification_text;
  }

  static const decltype(::file_suggestion::mojom::File::icon_url)& icon_url(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->icon_url;
  }

  static const decltype(::file_suggestion::mojom::File::title)& title(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->title;
  }

  static const decltype(::file_suggestion::mojom::File::item_url)& item_url(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->item_url;
  }

  static decltype(::file_suggestion::mojom::File::recommendation_type) recommendation_type(
      const ::file_suggestion::mojom::FilePtr& input) {
    return input->recommendation_type;
  }

  static bool Read(::file_suggestion::mojom::File::DataView input, ::file_suggestion::mojom::FilePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_H_