// chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_SHARED_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"




#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-data-view.h"




namespace std {

template <>
struct hash<::file_suggestion::mojom::RecommendationType>
    : public mojo::internal::EnumHashImpl<::file_suggestion::mojom::RecommendationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::file_suggestion::mojom::RecommendationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::file_suggestion::mojom::RecommendationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::file_suggestion::mojom::RecommendationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::file_suggestion::mojom::FileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::file_suggestion::mojom::FileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::file_suggestion::mojom::internal::File_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in File struct");

    decltype(Traits::justification_text(input)) in_justification_text = Traits::justification_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->justification_text)::BaseType> justification_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_justification_text,
      justification_text_fragment);

    fragment->justification_text.Set(
        justification_text_fragment.is_null() ? nullptr : justification_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->justification_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null justification_text in File struct");

    decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_url)::BaseType> icon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon_url,
      icon_url_fragment);

    fragment->icon_url.Set(
        icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_url in File struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in File struct");

    decltype(Traits::item_url(input)) in_item_url = Traits::item_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->item_url)::BaseType> item_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_item_url,
      item_url_fragment);

    fragment->item_url.Set(
        item_url_fragment.is_null() ? nullptr : item_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->item_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_url in File struct");
    fragment->recommendation_type_$flag = Traits::recommendation_type(input).has_value();
    if (Traits::recommendation_type(input).has_value()) {
      
      mojo::internal::Serialize<::file_suggestion::mojom::RecommendationType>(
        Traits::recommendation_type(input).value(),
        &fragment->recommendation_type_$value);
    } else {
      fragment->recommendation_type_$value =
          static_cast<int32_t>(::file_suggestion::mojom::RecommendationType::kMinValue);
    }
  }

  static bool Deserialize(::file_suggestion::mojom::internal::File_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::file_suggestion::mojom::FileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace file_suggestion::mojom {

inline void FileDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileDataView::GetJustificationTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->justification_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileDataView::GetIconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FileDataView::GetItemUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->item_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // file_suggestion::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::file_suggestion::mojom::RecommendationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::file_suggestion::mojom::RecommendationType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_SHARED_H_