// chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-params-data.h"
namespace file_suggestion {
namespace mojom {

NOINLINE static const char* RecommendationTypeToStringHelper(RecommendationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RecommendationType::kUsed:
      return "kUsed";
    case RecommendationType::kShared:
      return "kShared";
    case RecommendationType::kTrending:
      return "kTrending";
    default:
      return nullptr;
  }
}

std::string RecommendationTypeToString(RecommendationType value) {
  const char *str = RecommendationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RecommendationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RecommendationType value) {
  return os << RecommendationTypeToString(value);
}

namespace internal {


// static
bool File_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const File_Data* object =
      static_cast<const File_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->justification_text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& justification_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->justification_text, validation_context,
                                         &justification_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->item_url, validation_context))
    return false;


  if (!::file_suggestion::mojom::internal::RecommendationType_Data
        ::Validate(object->recommendation_type_$value, validation_context))
    return false;

  return true;
}

File_Data::File_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace file_suggestion

namespace perfetto {

// static
void TraceFormatTraits<::file_suggestion::mojom::RecommendationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::file_suggestion::mojom::RecommendationType value) {
  return std::move(context).WriteString(::file_suggestion::mojom::RecommendationTypeToString(value));
}

} // namespace perfetto