// chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/file_suggestion.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace file_suggestion::mojom {
class FileDataView;



}  // file_suggestion::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::file_suggestion::mojom::FileDataView> {
  using Data = ::file_suggestion::mojom::internal::File_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace file_suggestion::mojom {


enum class RecommendationType : int32_t {
  
  kUsed = 0,
  
  kShared = 1,
  
  kTrending = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RecommendationType value);
inline bool IsKnownEnumValue(RecommendationType value) {
  return internal::RecommendationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FileDataView {
 public:
  FileDataView() = default;

  FileDataView(
      internal::File_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetJustificationTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJustificationText(UserType* output) {
    
    auto* pointer = data_->justification_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetItemUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItemUrl(UserType* output) {
    
    auto* pointer = data_->item_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRecommendationType(UserType* output) const {
    if (!data_->recommendation_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::file_suggestion::mojom::RecommendationType>(
        data_->recommendation_type_$value, &output->emplace());
  }
  std::optional<RecommendationType> recommendation_type() const {
    if (!data_->recommendation_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::file_suggestion::mojom::RecommendationType>(data_->recommendation_type_$value));
  }
 private:
  internal::File_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // file_suggestion::mojom

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_FILE_SUGGESTION_FILE_SUGGESTION_MOJOM_DATA_VIEW_H_