// chrome/browser/media/media_engagement_score_details.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/media/media_engagement_score_details.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"


namespace media::mojom {
class MediaEngagementScoreDetailsDataView;

class MediaEngagementConfigDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::MediaEngagementScoreDetailsDataView> {
  using Data = ::media::mojom::internal::MediaEngagementScoreDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::MediaEngagementConfigDataView> {
  using Data = ::media::mojom::internal::MediaEngagementConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class MediaEngagementScoreDetailsProviderInterfaceBase {};

using MediaEngagementScoreDetailsProviderPtrDataView =
    mojo::InterfacePtrDataView<MediaEngagementScoreDetailsProviderInterfaceBase>;
using MediaEngagementScoreDetailsProviderRequestDataView =
    mojo::InterfaceRequestDataView<MediaEngagementScoreDetailsProviderInterfaceBase>;
using MediaEngagementScoreDetailsProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaEngagementScoreDetailsProviderInterfaceBase>;
using MediaEngagementScoreDetailsProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaEngagementScoreDetailsProviderInterfaceBase>;


class MediaEngagementScoreDetailsDataView {
 public:
  MediaEngagementScoreDetailsDataView() = default;

  MediaEngagementScoreDetailsDataView(
      internal::MediaEngagementScoreDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  double total_score() const {
    return data_->total_score;
  }
  int32_t visits() const {
    return data_->visits;
  }
  int32_t media_playbacks() const {
    return data_->media_playbacks;
  }
  double last_media_playback_time() const {
    return data_->last_media_playback_time;
  }
  bool is_high() const {
    return data_->is_high;
  }
 private:
  internal::MediaEngagementScoreDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaEngagementConfigDataView {
 public:
  MediaEngagementConfigDataView() = default;

  MediaEngagementConfigDataView(
      internal::MediaEngagementConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t score_min_visits() const {
    return data_->score_min_visits;
  }
  double high_score_lower_threshold() const {
    return data_->high_score_lower_threshold;
  }
  double high_score_upper_threshold() const {
    return data_->high_score_upper_threshold;
  }
  bool feature_record_data() const {
    return data_->feature_record_data;
  }
  bool feature_bypass_autoplay() const {
    return data_->feature_bypass_autoplay;
  }
  bool feature_preload_data() const {
    return data_->feature_preload_data;
  }
  bool feature_https_only() const {
    return data_->feature_https_only;
  }
  bool feature_autoplay_disable_settings() const {
    return data_->feature_autoplay_disable_settings;
  }
  bool pref_disable_unified_autoplay() const {
    return data_->pref_disable_unified_autoplay;
  }
  bool has_custom_autoplay_policy() const {
    return data_->has_custom_autoplay_policy;
  }
  inline void GetAutoplayPolicyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAutoplayPolicy(UserType* output) {
    
    auto* pointer = data_->autoplay_policy.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreloadVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreloadVersion(UserType* output) {
    
    auto* pointer = data_->preload_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaEngagementConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_DATA_VIEW_H_