// chrome/browser/lens/core/mojom/translate.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/translate.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/translate.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/translate.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace lens::mojom {





class  Language {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Language, T>::value>;
  using DataView = LanguageDataView;
  using Data_ = internal::Language_Data;

  template <typename... Args>
  static LanguagePtr New(Args&&... args) {
    return LanguagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LanguagePtr From(const U& u) {
    return mojo::TypeConverter<LanguagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Language>::Convert(*this);
  }


  Language();

  Language(
      const std::string& language_code,
      const std::string& name);


  ~Language();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LanguagePtr>
  LanguagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Language::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Language::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Language::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Language::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Language::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Language::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Language_UnserializedMessageContext<
            UserType, Language::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Language::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Language::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Language_UnserializedMessageContext<
            UserType, Language::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Language::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string language_code;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Language::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Language::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Language::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Language::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
LanguagePtr Language::Clone() const {
  return New(
      mojo::Clone(language_code),
      mojo::Clone(name)
  );
}

template <typename T, Language::EnableIfSame<T>*>
bool Language::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->language_code, other_struct.language_code))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, Language::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.language_code < rhs.language_code)
    return true;
  if (rhs.language_code < lhs.language_code)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::Language::DataView,
                                         ::lens::mojom::LanguagePtr> {
  static bool IsNull(const ::lens::mojom::LanguagePtr& input) { return !input; }
  static void SetToNull(::lens::mojom::LanguagePtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Language::language_code)& language_code(
      const ::lens::mojom::LanguagePtr& input) {
    return input->language_code;
  }

  static const decltype(::lens::mojom::Language::name)& name(
      const ::lens::mojom::LanguagePtr& input) {
    return input->name;
  }

  static bool Read(::lens::mojom::Language::DataView input, ::lens::mojom::LanguagePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_H_