// chrome/browser/lens/core/mojom/translate.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/lens/core/mojom/translate.mojom-shared-internal.h"

#include "chrome/browser/lens/core/mojom/translate.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::LanguageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::LanguageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Language_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::language_code(input)) in_language_code = Traits::language_code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language_code)::BaseType> language_code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_language_code,
        language_code_fragment);

      fragment->language_code.Set(
          language_code_fragment.is_null() ? nullptr : language_code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->language_code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language_code in Language struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in Language struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TRANSLATE_MOJOM_SEND_VALIDATION_H_