// chrome/browser/lens/core/mojom/text.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/text.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/text.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/text.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/geometry.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace lens::mojom {













class  FormulaMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormulaMetadata, T>::value>;
  using DataView = FormulaMetadataDataView;
  using Data_ = internal::FormulaMetadata_Data;

  template <typename... Args>
  static FormulaMetadataPtr New(Args&&... args) {
    return FormulaMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormulaMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FormulaMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormulaMetadata>::Convert(*this);
  }


  FormulaMetadata();

  explicit FormulaMetadata(
      const std::optional<std::string>& latex);


  ~FormulaMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormulaMetadataPtr>
  FormulaMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormulaMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormulaMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormulaMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormulaMetadata_UnserializedMessageContext<
            UserType, FormulaMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormulaMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormulaMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormulaMetadata_UnserializedMessageContext<
            UserType, FormulaMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormulaMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> latex;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormulaMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  Text {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Text, T>::value>;
  using DataView = TextDataView;
  using Data_ = internal::Text_Data;

  template <typename... Args>
  static TextPtr New(Args&&... args) {
    return TextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextPtr From(const U& u) {
    return mojo::TypeConverter<TextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Text>::Convert(*this);
  }


  Text();

  Text(
      TextLayoutPtr text_layout,
      const std::optional<std::string>& content_language);

Text(const Text&) = delete;
Text& operator=(const Text&) = delete;

  ~Text();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextPtr>
  TextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Text::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Text::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Text::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Text::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Text_UnserializedMessageContext<
            UserType, Text::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Text::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Text::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Text_UnserializedMessageContext<
            UserType, Text::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Text::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TextLayoutPtr text_layout;
  
  std::optional<std::string> content_language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Text::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Text::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Text::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Text::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TextLayout {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextLayout, T>::value>;
  using DataView = TextLayoutDataView;
  using Data_ = internal::TextLayout_Data;

  template <typename... Args>
  static TextLayoutPtr New(Args&&... args) {
    return TextLayoutPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextLayoutPtr From(const U& u) {
    return mojo::TypeConverter<TextLayoutPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextLayout>::Convert(*this);
  }


  TextLayout();

  explicit TextLayout(
      std::vector<ParagraphPtr> paragraphs);

TextLayout(const TextLayout&) = delete;
TextLayout& operator=(const TextLayout&) = delete;

  ~TextLayout();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextLayoutPtr>
  TextLayoutPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextLayout::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextLayout_UnserializedMessageContext<
            UserType, TextLayout::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextLayout::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextLayout::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextLayout_UnserializedMessageContext<
            UserType, TextLayout::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextLayout::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ParagraphPtr> paragraphs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextLayout::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Word {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Word, T>::value>;
  using DataView = WordDataView;
  using Data_ = internal::Word_Data;

  template <typename... Args>
  static WordPtr New(Args&&... args) {
    return WordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WordPtr From(const U& u) {
    return mojo::TypeConverter<WordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Word>::Convert(*this);
  }


  Word();

  Word(
      const std::string& plain_text,
      const std::optional<std::string>& text_separator,
      ::lens::mojom::GeometryPtr geometry,
      std::optional<WritingDirection> writing_direction,
      FormulaMetadataPtr formula_metadata);

Word(const Word&) = delete;
Word& operator=(const Word&) = delete;

  ~Word();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WordPtr>
  WordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Word::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Word::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Word::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Word::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Word::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Word::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Word_UnserializedMessageContext<
            UserType, Word::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Word::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Word::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Word_UnserializedMessageContext<
            UserType, Word::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Word::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string plain_text;
  
  std::optional<std::string> text_separator;
  
  ::lens::mojom::GeometryPtr geometry;
  
  std::optional<WritingDirection> writing_direction;
  
  FormulaMetadataPtr formula_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Word::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Word::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Word::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Word::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Line {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Line, T>::value>;
  using DataView = LineDataView;
  using Data_ = internal::Line_Data;

  template <typename... Args>
  static LinePtr New(Args&&... args) {
    return LinePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LinePtr From(const U& u) {
    return mojo::TypeConverter<LinePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Line>::Convert(*this);
  }


  Line();

  Line(
      std::vector<WordPtr> words,
      ::lens::mojom::GeometryPtr geometry);

Line(const Line&) = delete;
Line& operator=(const Line&) = delete;

  ~Line();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LinePtr>
  LinePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Line::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Line::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Line::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Line::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Line::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Line::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Line_UnserializedMessageContext<
            UserType, Line::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Line::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Line::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Line_UnserializedMessageContext<
            UserType, Line::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Line::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WordPtr> words;
  
  ::lens::mojom::GeometryPtr geometry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Line::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Line::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Line::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Line::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BackgroundImageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundImageData, T>::value>;
  using DataView = BackgroundImageDataDataView;
  using Data_ = internal::BackgroundImageData_Data;

  template <typename... Args>
  static BackgroundImageDataPtr New(Args&&... args) {
    return BackgroundImageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundImageDataPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundImageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundImageData>::Convert(*this);
  }


  BackgroundImageData();

  BackgroundImageData(
      ::mojo_base::BigBuffer background_image,
      const ::gfx::Size& image_size,
      float vertical_padding,
      float horizontal_padding,
      ::mojo_base::BigBuffer text_mask);

BackgroundImageData(const BackgroundImageData&) = delete;
BackgroundImageData& operator=(const BackgroundImageData&) = delete;

  ~BackgroundImageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundImageDataPtr>
  BackgroundImageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundImageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundImageData_UnserializedMessageContext<
            UserType, BackgroundImageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundImageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundImageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundImageData_UnserializedMessageContext<
            UserType, BackgroundImageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundImageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer background_image;
  
  ::gfx::Size image_size;
  
  float vertical_padding;
  
  float horizontal_padding;
  
  ::mojo_base::BigBuffer text_mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundImageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TranslatedLine {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TranslatedLine, T>::value>;
  using DataView = TranslatedLineDataView;
  using Data_ = internal::TranslatedLine_Data;

  template <typename... Args>
  static TranslatedLinePtr New(Args&&... args) {
    return TranslatedLinePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TranslatedLinePtr From(const U& u) {
    return mojo::TypeConverter<TranslatedLinePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TranslatedLine>::Convert(*this);
  }


  TranslatedLine();

  TranslatedLine(
      std::vector<WordPtr> words,
      const std::string& translation,
      ::SkColor text_color,
      ::SkColor background_primary_color,
      BackgroundImageDataPtr background_image_data,
      ::lens::mojom::GeometryPtr geometry);

TranslatedLine(const TranslatedLine&) = delete;
TranslatedLine& operator=(const TranslatedLine&) = delete;

  ~TranslatedLine();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TranslatedLinePtr>
  TranslatedLinePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TranslatedLine::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TranslatedLine_UnserializedMessageContext<
            UserType, TranslatedLine::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TranslatedLine::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TranslatedLine::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TranslatedLine_UnserializedMessageContext<
            UserType, TranslatedLine::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TranslatedLine::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WordPtr> words;
  
  std::string translation;
  
  ::SkColor text_color;
  
  ::SkColor background_primary_color;
  
  BackgroundImageDataPtr background_image_data;
  
  ::lens::mojom::GeometryPtr geometry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TranslatedLine::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TranslatedParagraph {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TranslatedParagraph, T>::value>;
  using DataView = TranslatedParagraphDataView;
  using Data_ = internal::TranslatedParagraph_Data;

  template <typename... Args>
  static TranslatedParagraphPtr New(Args&&... args) {
    return TranslatedParagraphPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TranslatedParagraphPtr From(const U& u) {
    return mojo::TypeConverter<TranslatedParagraphPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TranslatedParagraph>::Convert(*this);
  }


  TranslatedParagraph();

  TranslatedParagraph(
      std::vector<TranslatedLinePtr> lines,
      const ::gfx::Size& resized_bitmap_size,
      std::optional<Alignment> alignment,
      std::optional<WritingDirection> writing_direction,
      const std::optional<std::string>& content_language);

TranslatedParagraph(const TranslatedParagraph&) = delete;
TranslatedParagraph& operator=(const TranslatedParagraph&) = delete;

  ~TranslatedParagraph();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TranslatedParagraphPtr>
  TranslatedParagraphPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TranslatedParagraph::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TranslatedParagraph_UnserializedMessageContext<
            UserType, TranslatedParagraph::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TranslatedParagraph::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TranslatedParagraph::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TranslatedParagraph_UnserializedMessageContext<
            UserType, TranslatedParagraph::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TranslatedParagraph::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<TranslatedLinePtr> lines;
  
  ::gfx::Size resized_bitmap_size;
  
  std::optional<Alignment> alignment;
  
  std::optional<WritingDirection> writing_direction;
  
  std::optional<std::string> content_language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TranslatedParagraph::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Paragraph {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Paragraph, T>::value>;
  using DataView = ParagraphDataView;
  using Data_ = internal::Paragraph_Data;

  template <typename... Args>
  static ParagraphPtr New(Args&&... args) {
    return ParagraphPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParagraphPtr From(const U& u) {
    return mojo::TypeConverter<ParagraphPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Paragraph>::Convert(*this);
  }


  Paragraph();

  Paragraph(
      std::vector<LinePtr> lines,
      TranslatedParagraphPtr translation,
      ::lens::mojom::GeometryPtr geometry,
      std::optional<WritingDirection> writing_direction,
      const std::optional<std::string>& content_language);

Paragraph(const Paragraph&) = delete;
Paragraph& operator=(const Paragraph&) = delete;

  ~Paragraph();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParagraphPtr>
  ParagraphPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Paragraph::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Paragraph_UnserializedMessageContext<
            UserType, Paragraph::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Paragraph::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Paragraph::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Paragraph_UnserializedMessageContext<
            UserType, Paragraph::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Paragraph::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<LinePtr> lines;
  
  TranslatedParagraphPtr translation;
  
  ::lens::mojom::GeometryPtr geometry;
  
  std::optional<WritingDirection> writing_direction;
  
  std::optional<std::string> content_language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Paragraph::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
TextPtr Text::Clone() const {
  return New(
      mojo::Clone(text_layout),
      mojo::Clone(content_language)
  );
}

template <typename T, Text::EnableIfSame<T>*>
bool Text::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_layout, other_struct.text_layout))
    return false;
  if (!mojo::Equals(this->content_language, other_struct.content_language))
    return false;
  return true;
}

template <typename T, Text::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_layout < rhs.text_layout)
    return true;
  if (rhs.text_layout < lhs.text_layout)
    return false;
  if (lhs.content_language < rhs.content_language)
    return true;
  if (rhs.content_language < lhs.content_language)
    return false;
  return false;
}
template <typename StructPtrType>
TextLayoutPtr TextLayout::Clone() const {
  return New(
      mojo::Clone(paragraphs)
  );
}

template <typename T, TextLayout::EnableIfSame<T>*>
bool TextLayout::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->paragraphs, other_struct.paragraphs))
    return false;
  return true;
}

template <typename T, TextLayout::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.paragraphs < rhs.paragraphs)
    return true;
  if (rhs.paragraphs < lhs.paragraphs)
    return false;
  return false;
}
template <typename StructPtrType>
WordPtr Word::Clone() const {
  return New(
      mojo::Clone(plain_text),
      mojo::Clone(text_separator),
      mojo::Clone(geometry),
      mojo::Clone(writing_direction),
      mojo::Clone(formula_metadata)
  );
}

template <typename T, Word::EnableIfSame<T>*>
bool Word::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->plain_text, other_struct.plain_text))
    return false;
  if (!mojo::Equals(this->text_separator, other_struct.text_separator))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  if (!mojo::Equals(this->writing_direction, other_struct.writing_direction))
    return false;
  if (!mojo::Equals(this->formula_metadata, other_struct.formula_metadata))
    return false;
  return true;
}

template <typename T, Word::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.plain_text < rhs.plain_text)
    return true;
  if (rhs.plain_text < lhs.plain_text)
    return false;
  if (lhs.text_separator < rhs.text_separator)
    return true;
  if (rhs.text_separator < lhs.text_separator)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  if (lhs.writing_direction < rhs.writing_direction)
    return true;
  if (rhs.writing_direction < lhs.writing_direction)
    return false;
  if (lhs.formula_metadata < rhs.formula_metadata)
    return true;
  if (rhs.formula_metadata < lhs.formula_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
LinePtr Line::Clone() const {
  return New(
      mojo::Clone(words),
      mojo::Clone(geometry)
  );
}

template <typename T, Line::EnableIfSame<T>*>
bool Line::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->words, other_struct.words))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  return true;
}

template <typename T, Line::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.words < rhs.words)
    return true;
  if (rhs.words < lhs.words)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundImageDataPtr BackgroundImageData::Clone() const {
  return New(
      mojo::Clone(background_image),
      mojo::Clone(image_size),
      mojo::Clone(vertical_padding),
      mojo::Clone(horizontal_padding),
      mojo::Clone(text_mask)
  );
}

template <typename T, BackgroundImageData::EnableIfSame<T>*>
bool BackgroundImageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->background_image, other_struct.background_image))
    return false;
  if (!mojo::Equals(this->image_size, other_struct.image_size))
    return false;
  if (!mojo::Equals(this->vertical_padding, other_struct.vertical_padding))
    return false;
  if (!mojo::Equals(this->horizontal_padding, other_struct.horizontal_padding))
    return false;
  if (!mojo::Equals(this->text_mask, other_struct.text_mask))
    return false;
  return true;
}

template <typename T, BackgroundImageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.background_image < rhs.background_image)
    return true;
  if (rhs.background_image < lhs.background_image)
    return false;
  if (lhs.image_size < rhs.image_size)
    return true;
  if (rhs.image_size < lhs.image_size)
    return false;
  if (lhs.vertical_padding < rhs.vertical_padding)
    return true;
  if (rhs.vertical_padding < lhs.vertical_padding)
    return false;
  if (lhs.horizontal_padding < rhs.horizontal_padding)
    return true;
  if (rhs.horizontal_padding < lhs.horizontal_padding)
    return false;
  if (lhs.text_mask < rhs.text_mask)
    return true;
  if (rhs.text_mask < lhs.text_mask)
    return false;
  return false;
}
template <typename StructPtrType>
TranslatedLinePtr TranslatedLine::Clone() const {
  return New(
      mojo::Clone(words),
      mojo::Clone(translation),
      mojo::Clone(text_color),
      mojo::Clone(background_primary_color),
      mojo::Clone(background_image_data),
      mojo::Clone(geometry)
  );
}

template <typename T, TranslatedLine::EnableIfSame<T>*>
bool TranslatedLine::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->words, other_struct.words))
    return false;
  if (!mojo::Equals(this->translation, other_struct.translation))
    return false;
  if (!mojo::Equals(this->text_color, other_struct.text_color))
    return false;
  if (!mojo::Equals(this->background_primary_color, other_struct.background_primary_color))
    return false;
  if (!mojo::Equals(this->background_image_data, other_struct.background_image_data))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  return true;
}

template <typename T, TranslatedLine::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.words < rhs.words)
    return true;
  if (rhs.words < lhs.words)
    return false;
  if (lhs.translation < rhs.translation)
    return true;
  if (rhs.translation < lhs.translation)
    return false;
  if (lhs.text_color < rhs.text_color)
    return true;
  if (rhs.text_color < lhs.text_color)
    return false;
  if (lhs.background_primary_color < rhs.background_primary_color)
    return true;
  if (rhs.background_primary_color < lhs.background_primary_color)
    return false;
  if (lhs.background_image_data < rhs.background_image_data)
    return true;
  if (rhs.background_image_data < lhs.background_image_data)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  return false;
}
template <typename StructPtrType>
TranslatedParagraphPtr TranslatedParagraph::Clone() const {
  return New(
      mojo::Clone(lines),
      mojo::Clone(resized_bitmap_size),
      mojo::Clone(alignment),
      mojo::Clone(writing_direction),
      mojo::Clone(content_language)
  );
}

template <typename T, TranslatedParagraph::EnableIfSame<T>*>
bool TranslatedParagraph::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lines, other_struct.lines))
    return false;
  if (!mojo::Equals(this->resized_bitmap_size, other_struct.resized_bitmap_size))
    return false;
  if (!mojo::Equals(this->alignment, other_struct.alignment))
    return false;
  if (!mojo::Equals(this->writing_direction, other_struct.writing_direction))
    return false;
  if (!mojo::Equals(this->content_language, other_struct.content_language))
    return false;
  return true;
}

template <typename T, TranslatedParagraph::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lines < rhs.lines)
    return true;
  if (rhs.lines < lhs.lines)
    return false;
  if (lhs.resized_bitmap_size < rhs.resized_bitmap_size)
    return true;
  if (rhs.resized_bitmap_size < lhs.resized_bitmap_size)
    return false;
  if (lhs.alignment < rhs.alignment)
    return true;
  if (rhs.alignment < lhs.alignment)
    return false;
  if (lhs.writing_direction < rhs.writing_direction)
    return true;
  if (rhs.writing_direction < lhs.writing_direction)
    return false;
  if (lhs.content_language < rhs.content_language)
    return true;
  if (rhs.content_language < lhs.content_language)
    return false;
  return false;
}
template <typename StructPtrType>
ParagraphPtr Paragraph::Clone() const {
  return New(
      mojo::Clone(lines),
      mojo::Clone(translation),
      mojo::Clone(geometry),
      mojo::Clone(writing_direction),
      mojo::Clone(content_language)
  );
}

template <typename T, Paragraph::EnableIfSame<T>*>
bool Paragraph::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lines, other_struct.lines))
    return false;
  if (!mojo::Equals(this->translation, other_struct.translation))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  if (!mojo::Equals(this->writing_direction, other_struct.writing_direction))
    return false;
  if (!mojo::Equals(this->content_language, other_struct.content_language))
    return false;
  return true;
}

template <typename T, Paragraph::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lines < rhs.lines)
    return true;
  if (rhs.lines < lhs.lines)
    return false;
  if (lhs.translation < rhs.translation)
    return true;
  if (rhs.translation < lhs.translation)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  if (lhs.writing_direction < rhs.writing_direction)
    return true;
  if (rhs.writing_direction < lhs.writing_direction)
    return false;
  if (lhs.content_language < rhs.content_language)
    return true;
  if (rhs.content_language < lhs.content_language)
    return false;
  return false;
}
template <typename StructPtrType>
FormulaMetadataPtr FormulaMetadata::Clone() const {
  return New(
      mojo::Clone(latex)
  );
}

template <typename T, FormulaMetadata::EnableIfSame<T>*>
bool FormulaMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->latex, other_struct.latex))
    return false;
  return true;
}

template <typename T, FormulaMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.latex < rhs.latex)
    return true;
  if (rhs.latex < lhs.latex)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::Text::DataView,
                                         ::lens::mojom::TextPtr> {
  static bool IsNull(const ::lens::mojom::TextPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::TextPtr* output) { output->reset(); }

  static  decltype(::lens::mojom::Text::text_layout)& text_layout(
       ::lens::mojom::TextPtr& input) {
    return input->text_layout;
  }

  static const decltype(::lens::mojom::Text::content_language)& content_language(
      const ::lens::mojom::TextPtr& input) {
    return input->content_language;
  }

  static bool Read(::lens::mojom::Text::DataView input, ::lens::mojom::TextPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::TextLayout::DataView,
                                         ::lens::mojom::TextLayoutPtr> {
  static bool IsNull(const ::lens::mojom::TextLayoutPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::TextLayoutPtr* output) { output->reset(); }

  static  decltype(::lens::mojom::TextLayout::paragraphs)& paragraphs(
       ::lens::mojom::TextLayoutPtr& input) {
    return input->paragraphs;
  }

  static bool Read(::lens::mojom::TextLayout::DataView input, ::lens::mojom::TextLayoutPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::Word::DataView,
                                         ::lens::mojom::WordPtr> {
  static bool IsNull(const ::lens::mojom::WordPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::WordPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Word::plain_text)& plain_text(
      const ::lens::mojom::WordPtr& input) {
    return input->plain_text;
  }

  static const decltype(::lens::mojom::Word::text_separator)& text_separator(
      const ::lens::mojom::WordPtr& input) {
    return input->text_separator;
  }

  static const decltype(::lens::mojom::Word::geometry)& geometry(
      const ::lens::mojom::WordPtr& input) {
    return input->geometry;
  }

  static decltype(::lens::mojom::Word::writing_direction) writing_direction(
      const ::lens::mojom::WordPtr& input) {
    return input->writing_direction;
  }

  static const decltype(::lens::mojom::Word::formula_metadata)& formula_metadata(
      const ::lens::mojom::WordPtr& input) {
    return input->formula_metadata;
  }

  static bool Read(::lens::mojom::Word::DataView input, ::lens::mojom::WordPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::Line::DataView,
                                         ::lens::mojom::LinePtr> {
  static bool IsNull(const ::lens::mojom::LinePtr& input) { return !input; }
  static void SetToNull(::lens::mojom::LinePtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Line::words)& words(
      const ::lens::mojom::LinePtr& input) {
    return input->words;
  }

  static const decltype(::lens::mojom::Line::geometry)& geometry(
      const ::lens::mojom::LinePtr& input) {
    return input->geometry;
  }

  static bool Read(::lens::mojom::Line::DataView input, ::lens::mojom::LinePtr* output);
};


template <>
struct  StructTraits<::lens::mojom::BackgroundImageData::DataView,
                                         ::lens::mojom::BackgroundImageDataPtr> {
  static bool IsNull(const ::lens::mojom::BackgroundImageDataPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::BackgroundImageDataPtr* output) { output->reset(); }

  static  decltype(::lens::mojom::BackgroundImageData::background_image)& background_image(
       ::lens::mojom::BackgroundImageDataPtr& input) {
    return input->background_image;
  }

  static const decltype(::lens::mojom::BackgroundImageData::image_size)& image_size(
      const ::lens::mojom::BackgroundImageDataPtr& input) {
    return input->image_size;
  }

  static decltype(::lens::mojom::BackgroundImageData::vertical_padding) vertical_padding(
      const ::lens::mojom::BackgroundImageDataPtr& input) {
    return input->vertical_padding;
  }

  static decltype(::lens::mojom::BackgroundImageData::horizontal_padding) horizontal_padding(
      const ::lens::mojom::BackgroundImageDataPtr& input) {
    return input->horizontal_padding;
  }

  static  decltype(::lens::mojom::BackgroundImageData::text_mask)& text_mask(
       ::lens::mojom::BackgroundImageDataPtr& input) {
    return input->text_mask;
  }

  static bool Read(::lens::mojom::BackgroundImageData::DataView input, ::lens::mojom::BackgroundImageDataPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::TranslatedLine::DataView,
                                         ::lens::mojom::TranslatedLinePtr> {
  static bool IsNull(const ::lens::mojom::TranslatedLinePtr& input) { return !input; }
  static void SetToNull(::lens::mojom::TranslatedLinePtr* output) { output->reset(); }

  static const decltype(::lens::mojom::TranslatedLine::words)& words(
      const ::lens::mojom::TranslatedLinePtr& input) {
    return input->words;
  }

  static const decltype(::lens::mojom::TranslatedLine::translation)& translation(
      const ::lens::mojom::TranslatedLinePtr& input) {
    return input->translation;
  }

  static const decltype(::lens::mojom::TranslatedLine::text_color)& text_color(
      const ::lens::mojom::TranslatedLinePtr& input) {
    return input->text_color;
  }

  static const decltype(::lens::mojom::TranslatedLine::background_primary_color)& background_primary_color(
      const ::lens::mojom::TranslatedLinePtr& input) {
    return input->background_primary_color;
  }

  static  decltype(::lens::mojom::TranslatedLine::background_image_data)& background_image_data(
       ::lens::mojom::TranslatedLinePtr& input) {
    return input->background_image_data;
  }

  static const decltype(::lens::mojom::TranslatedLine::geometry)& geometry(
      const ::lens::mojom::TranslatedLinePtr& input) {
    return input->geometry;
  }

  static bool Read(::lens::mojom::TranslatedLine::DataView input, ::lens::mojom::TranslatedLinePtr* output);
};


template <>
struct  StructTraits<::lens::mojom::TranslatedParagraph::DataView,
                                         ::lens::mojom::TranslatedParagraphPtr> {
  static bool IsNull(const ::lens::mojom::TranslatedParagraphPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::TranslatedParagraphPtr* output) { output->reset(); }

  static  decltype(::lens::mojom::TranslatedParagraph::lines)& lines(
       ::lens::mojom::TranslatedParagraphPtr& input) {
    return input->lines;
  }

  static const decltype(::lens::mojom::TranslatedParagraph::resized_bitmap_size)& resized_bitmap_size(
      const ::lens::mojom::TranslatedParagraphPtr& input) {
    return input->resized_bitmap_size;
  }

  static decltype(::lens::mojom::TranslatedParagraph::alignment) alignment(
      const ::lens::mojom::TranslatedParagraphPtr& input) {
    return input->alignment;
  }

  static decltype(::lens::mojom::TranslatedParagraph::writing_direction) writing_direction(
      const ::lens::mojom::TranslatedParagraphPtr& input) {
    return input->writing_direction;
  }

  static const decltype(::lens::mojom::TranslatedParagraph::content_language)& content_language(
      const ::lens::mojom::TranslatedParagraphPtr& input) {
    return input->content_language;
  }

  static bool Read(::lens::mojom::TranslatedParagraph::DataView input, ::lens::mojom::TranslatedParagraphPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::Paragraph::DataView,
                                         ::lens::mojom::ParagraphPtr> {
  static bool IsNull(const ::lens::mojom::ParagraphPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::ParagraphPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Paragraph::lines)& lines(
      const ::lens::mojom::ParagraphPtr& input) {
    return input->lines;
  }

  static  decltype(::lens::mojom::Paragraph::translation)& translation(
       ::lens::mojom::ParagraphPtr& input) {
    return input->translation;
  }

  static const decltype(::lens::mojom::Paragraph::geometry)& geometry(
      const ::lens::mojom::ParagraphPtr& input) {
    return input->geometry;
  }

  static decltype(::lens::mojom::Paragraph::writing_direction) writing_direction(
      const ::lens::mojom::ParagraphPtr& input) {
    return input->writing_direction;
  }

  static const decltype(::lens::mojom::Paragraph::content_language)& content_language(
      const ::lens::mojom::ParagraphPtr& input) {
    return input->content_language;
  }

  static bool Read(::lens::mojom::Paragraph::DataView input, ::lens::mojom::ParagraphPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::FormulaMetadata::DataView,
                                         ::lens::mojom::FormulaMetadataPtr> {
  static bool IsNull(const ::lens::mojom::FormulaMetadataPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::FormulaMetadataPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::FormulaMetadata::latex)& latex(
      const ::lens::mojom::FormulaMetadataPtr& input) {
    return input->latex;
  }

  static bool Read(::lens::mojom::FormulaMetadata::DataView input, ::lens::mojom::FormulaMetadataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_H_