// chrome/browser/lens/core/mojom/text.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SHARED_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/text.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/lens/core/mojom/text.mojom-data-view.h"




namespace std {

template <>
struct hash<::lens::mojom::WritingDirection>
    : public mojo::internal::EnumHashImpl<::lens::mojom::WritingDirection> {};

template <>
struct hash<::lens::mojom::Alignment>
    : public mojo::internal::EnumHashImpl<::lens::mojom::Alignment> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::WritingDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::WritingDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::WritingDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::Alignment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::Alignment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::Alignment>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::TextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Text_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text_layout(input)) in_text_layout = Traits::text_layout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_layout)::BaseType> text_layout_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::TextLayoutDataView>(
      in_text_layout,
      text_layout_fragment);

    fragment->text_layout.Set(
        text_layout_fragment.is_null() ? nullptr : text_layout_fragment.data());

    decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_language)::BaseType> content_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_language,
      content_language_fragment);

    fragment->content_language.Set(
        content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::Text_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::TextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::TextLayoutDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TextLayoutDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TextLayout_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::paragraphs(input)) in_paragraphs = Traits::paragraphs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->paragraphs)::BaseType>
        paragraphs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& paragraphs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::ParagraphDataView>>(
      in_paragraphs,
      paragraphs_fragment,
      &paragraphs_validate_params);

    fragment->paragraphs.Set(
        paragraphs_fragment.is_null() ? nullptr : paragraphs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->paragraphs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null paragraphs in TextLayout struct");
  }

  static bool Deserialize(::lens::mojom::internal::TextLayout_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::TextLayoutDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::WordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::WordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Word_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::plain_text(input)) in_plain_text = Traits::plain_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->plain_text)::BaseType> plain_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_plain_text,
      plain_text_fragment);

    fragment->plain_text.Set(
        plain_text_fragment.is_null() ? nullptr : plain_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->plain_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null plain_text in Word struct");

    decltype(Traits::text_separator(input)) in_text_separator = Traits::text_separator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_separator)::BaseType> text_separator_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_separator,
      text_separator_fragment);

    fragment->text_separator.Set(
        text_separator_fragment.is_null() ? nullptr : text_separator_fragment.data());

    decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geometry)::BaseType> geometry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::GeometryDataView>(
      in_geometry,
      geometry_fragment);

    fragment->geometry.Set(
        geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
    fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
    if (Traits::writing_direction(input).has_value()) {
      
      mojo::internal::Serialize<::lens::mojom::WritingDirection>(
        Traits::writing_direction(input).value(),
        &fragment->writing_direction_$value);
    } else {
      fragment->writing_direction_$value =
          static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
    }

    decltype(Traits::formula_metadata(input)) in_formula_metadata = Traits::formula_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->formula_metadata)::BaseType> formula_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::FormulaMetadataDataView>(
      in_formula_metadata,
      formula_metadata_fragment);

    fragment->formula_metadata.Set(
        formula_metadata_fragment.is_null() ? nullptr : formula_metadata_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::Word_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::WordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::LineDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::LineDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Line_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::words(input)) in_words = Traits::words(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->words)::BaseType>
        words_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::WordDataView>>(
      in_words,
      words_fragment,
      &words_validate_params);

    fragment->words.Set(
        words_fragment.is_null() ? nullptr : words_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->words.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words in Line struct");

    decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geometry)::BaseType> geometry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::GeometryDataView>(
      in_geometry,
      geometry_fragment);

    fragment->geometry.Set(
        geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::Line_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::LineDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::BackgroundImageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::BackgroundImageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::BackgroundImageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::background_image(input)) in_background_image = Traits::background_image(input);
    mojo::internal::MessageFragment<decltype(fragment->background_image)>
        background_image_fragment(fragment.message());
    background_image_fragment.Claim(&fragment->background_image);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_background_image,
      background_image_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_image in BackgroundImageData struct");

    decltype(Traits::image_size(input)) in_image_size = Traits::image_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_size)::BaseType> image_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_image_size,
      image_size_fragment);

    fragment->image_size.Set(
        image_size_fragment.is_null() ? nullptr : image_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_size in BackgroundImageData struct");

    fragment->vertical_padding = Traits::vertical_padding(input);

    fragment->horizontal_padding = Traits::horizontal_padding(input);

    decltype(Traits::text_mask(input)) in_text_mask = Traits::text_mask(input);
    mojo::internal::MessageFragment<decltype(fragment->text_mask)>
        text_mask_fragment(fragment.message());
    text_mask_fragment.Claim(&fragment->text_mask);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_text_mask,
      text_mask_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_mask.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_mask in BackgroundImageData struct");
  }

  static bool Deserialize(::lens::mojom::internal::BackgroundImageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::BackgroundImageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::TranslatedLineDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TranslatedLineDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TranslatedLine_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::words(input)) in_words = Traits::words(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->words)::BaseType>
        words_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::WordDataView>>(
      in_words,
      words_fragment,
      &words_validate_params);

    fragment->words.Set(
        words_fragment.is_null() ? nullptr : words_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->words.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null words in TranslatedLine struct");

    decltype(Traits::translation(input)) in_translation = Traits::translation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->translation)::BaseType> translation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_translation,
      translation_fragment);

    fragment->translation.Set(
        translation_fragment.is_null() ? nullptr : translation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->translation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null translation in TranslatedLine struct");

    decltype(Traits::text_color(input)) in_text_color = Traits::text_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_color)::BaseType> text_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_text_color,
      text_color_fragment);

    fragment->text_color.Set(
        text_color_fragment.is_null() ? nullptr : text_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_color in TranslatedLine struct");

    decltype(Traits::background_primary_color(input)) in_background_primary_color = Traits::background_primary_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_primary_color)::BaseType> background_primary_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_primary_color,
      background_primary_color_fragment);

    fragment->background_primary_color.Set(
        background_primary_color_fragment.is_null() ? nullptr : background_primary_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_primary_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_primary_color in TranslatedLine struct");

    decltype(Traits::background_image_data(input)) in_background_image_data = Traits::background_image_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_data)::BaseType> background_image_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::BackgroundImageDataDataView>(
      in_background_image_data,
      background_image_data_fragment);

    fragment->background_image_data.Set(
        background_image_data_fragment.is_null() ? nullptr : background_image_data_fragment.data());

    decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geometry)::BaseType> geometry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::GeometryDataView>(
      in_geometry,
      geometry_fragment);

    fragment->geometry.Set(
        geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::TranslatedLine_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::TranslatedLineDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::TranslatedParagraphDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TranslatedParagraphDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TranslatedParagraph_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::lines(input)) in_lines = Traits::lines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lines)::BaseType>
        lines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::TranslatedLineDataView>>(
      in_lines,
      lines_fragment,
      &lines_validate_params);

    fragment->lines.Set(
        lines_fragment.is_null() ? nullptr : lines_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lines.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lines in TranslatedParagraph struct");

    decltype(Traits::resized_bitmap_size(input)) in_resized_bitmap_size = Traits::resized_bitmap_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resized_bitmap_size)::BaseType> resized_bitmap_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_resized_bitmap_size,
      resized_bitmap_size_fragment);

    fragment->resized_bitmap_size.Set(
        resized_bitmap_size_fragment.is_null() ? nullptr : resized_bitmap_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resized_bitmap_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resized_bitmap_size in TranslatedParagraph struct");
    fragment->alignment_$flag = Traits::alignment(input).has_value();
    if (Traits::alignment(input).has_value()) {
      
      mojo::internal::Serialize<::lens::mojom::Alignment>(
        Traits::alignment(input).value(),
        &fragment->alignment_$value);
    } else {
      fragment->alignment_$value =
          static_cast<int32_t>(::lens::mojom::Alignment::kMinValue);
    }
    fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
    if (Traits::writing_direction(input).has_value()) {
      
      mojo::internal::Serialize<::lens::mojom::WritingDirection>(
        Traits::writing_direction(input).value(),
        &fragment->writing_direction_$value);
    } else {
      fragment->writing_direction_$value =
          static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
    }

    decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_language)::BaseType> content_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_language,
      content_language_fragment);

    fragment->content_language.Set(
        content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::TranslatedParagraph_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::TranslatedParagraphDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::ParagraphDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::ParagraphDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Paragraph_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::lines(input)) in_lines = Traits::lines(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lines)::BaseType>
        lines_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::LineDataView>>(
      in_lines,
      lines_fragment,
      &lines_validate_params);

    fragment->lines.Set(
        lines_fragment.is_null() ? nullptr : lines_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lines.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lines in Paragraph struct");

    decltype(Traits::translation(input)) in_translation = Traits::translation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->translation)::BaseType> translation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::TranslatedParagraphDataView>(
      in_translation,
      translation_fragment);

    fragment->translation.Set(
        translation_fragment.is_null() ? nullptr : translation_fragment.data());

    decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->geometry)::BaseType> geometry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::GeometryDataView>(
      in_geometry,
      geometry_fragment);

    fragment->geometry.Set(
        geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
    fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
    if (Traits::writing_direction(input).has_value()) {
      
      mojo::internal::Serialize<::lens::mojom::WritingDirection>(
        Traits::writing_direction(input).value(),
        &fragment->writing_direction_$value);
    } else {
      fragment->writing_direction_$value =
          static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
    }

    decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_language)::BaseType> content_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_language,
      content_language_fragment);

    fragment->content_language.Set(
        content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::Paragraph_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::ParagraphDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::FormulaMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::FormulaMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::FormulaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::latex(input)) in_latex = Traits::latex(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latex)::BaseType> latex_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_latex,
      latex_fragment);

    fragment->latex.Set(
        latex_fragment.is_null() ? nullptr : latex_fragment.data());
  }

  static bool Deserialize(::lens::mojom::internal::FormulaMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::FormulaMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace lens::mojom {

inline void TextDataView::GetTextLayoutDataView(
    TextLayoutDataView* output) {
  auto pointer = data_->text_layout.Get();
  *output = TextLayoutDataView(pointer, message_);
}
inline void TextDataView::GetContentLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TextLayoutDataView::GetParagraphsDataView(
    mojo::ArrayDataView<ParagraphDataView>* output) {
  auto pointer = data_->paragraphs.Get();
  *output = mojo::ArrayDataView<ParagraphDataView>(pointer, message_);
}


inline void WordDataView::GetPlainTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->plain_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WordDataView::GetTextSeparatorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_separator.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WordDataView::GetGeometryDataView(
    ::lens::mojom::GeometryDataView* output) {
  auto pointer = data_->geometry.Get();
  *output = ::lens::mojom::GeometryDataView(pointer, message_);
}
inline void WordDataView::GetFormulaMetadataDataView(
    FormulaMetadataDataView* output) {
  auto pointer = data_->formula_metadata.Get();
  *output = FormulaMetadataDataView(pointer, message_);
}


inline void LineDataView::GetWordsDataView(
    mojo::ArrayDataView<WordDataView>* output) {
  auto pointer = data_->words.Get();
  *output = mojo::ArrayDataView<WordDataView>(pointer, message_);
}
inline void LineDataView::GetGeometryDataView(
    ::lens::mojom::GeometryDataView* output) {
  auto pointer = data_->geometry.Get();
  *output = ::lens::mojom::GeometryDataView(pointer, message_);
}


inline void BackgroundImageDataDataView::GetBackgroundImageDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->background_image;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void BackgroundImageDataDataView::GetImageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->image_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void BackgroundImageDataDataView::GetTextMaskDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->text_mask;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void TranslatedLineDataView::GetWordsDataView(
    mojo::ArrayDataView<WordDataView>* output) {
  auto pointer = data_->words.Get();
  *output = mojo::ArrayDataView<WordDataView>(pointer, message_);
}
inline void TranslatedLineDataView::GetTranslationDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->translation.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TranslatedLineDataView::GetTextColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->text_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void TranslatedLineDataView::GetBackgroundPrimaryColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_primary_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void TranslatedLineDataView::GetBackgroundImageDataDataView(
    BackgroundImageDataDataView* output) {
  auto pointer = data_->background_image_data.Get();
  *output = BackgroundImageDataDataView(pointer, message_);
}
inline void TranslatedLineDataView::GetGeometryDataView(
    ::lens::mojom::GeometryDataView* output) {
  auto pointer = data_->geometry.Get();
  *output = ::lens::mojom::GeometryDataView(pointer, message_);
}


inline void TranslatedParagraphDataView::GetLinesDataView(
    mojo::ArrayDataView<TranslatedLineDataView>* output) {
  auto pointer = data_->lines.Get();
  *output = mojo::ArrayDataView<TranslatedLineDataView>(pointer, message_);
}
inline void TranslatedParagraphDataView::GetResizedBitmapSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->resized_bitmap_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void TranslatedParagraphDataView::GetContentLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ParagraphDataView::GetLinesDataView(
    mojo::ArrayDataView<LineDataView>* output) {
  auto pointer = data_->lines.Get();
  *output = mojo::ArrayDataView<LineDataView>(pointer, message_);
}
inline void ParagraphDataView::GetTranslationDataView(
    TranslatedParagraphDataView* output) {
  auto pointer = data_->translation.Get();
  *output = TranslatedParagraphDataView(pointer, message_);
}
inline void ParagraphDataView::GetGeometryDataView(
    ::lens::mojom::GeometryDataView* output) {
  auto pointer = data_->geometry.Get();
  *output = ::lens::mojom::GeometryDataView(pointer, message_);
}
inline void ParagraphDataView::GetContentLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FormulaMetadataDataView::GetLatexDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->latex.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // lens::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::WritingDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::WritingDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::Alignment> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::Alignment value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SHARED_H_