// chrome/browser/lens/core/mojom/text.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/lens/core/mojom/text.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"

#include "chrome/browser/lens/core/mojom/text.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::lens::mojom::WritingDirection, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::lens::mojom::Alignment, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::TextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Text_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::text_layout(input)) in_text_layout = Traits::text_layout(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_layout)::BaseType> text_layout_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::TextLayoutDataView, send_validation>(
        in_text_layout,
        text_layout_fragment);

      fragment->text_layout.Set(
          text_layout_fragment.is_null() ? nullptr : text_layout_fragment.data());

      decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_language)::BaseType> content_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_language,
        content_language_fragment);

      fragment->content_language.Set(
          content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::TextLayoutDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TextLayoutDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TextLayout_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::paragraphs(input)) in_paragraphs = Traits::paragraphs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->paragraphs)::BaseType>
          paragraphs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& paragraphs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::ParagraphDataView>, send_validation>(
        in_paragraphs,
        paragraphs_fragment,
        &paragraphs_validate_params);

      fragment->paragraphs.Set(
          paragraphs_fragment.is_null() ? nullptr : paragraphs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->paragraphs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null paragraphs in TextLayout struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::WordDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::WordDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Word_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::plain_text(input)) in_plain_text = Traits::plain_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->plain_text)::BaseType> plain_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_plain_text,
        plain_text_fragment);

      fragment->plain_text.Set(
          plain_text_fragment.is_null() ? nullptr : plain_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->plain_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null plain_text in Word struct");

      decltype(Traits::text_separator(input)) in_text_separator = Traits::text_separator(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_separator)::BaseType> text_separator_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_separator,
        text_separator_fragment);

      fragment->text_separator.Set(
          text_separator_fragment.is_null() ? nullptr : text_separator_fragment.data());

      decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geometry)::BaseType> geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::GeometryDataView, send_validation>(
        in_geometry,
        geometry_fragment);

      fragment->geometry.Set(
          geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
      fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
      if (Traits::writing_direction(input).has_value()) {
        
        mojo::internal::Serialize<::lens::mojom::WritingDirection>(
          Traits::writing_direction(input).value(),
          &fragment->writing_direction_$value);
      } else {
        fragment->writing_direction_$value =
            static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
      }

      decltype(Traits::formula_metadata(input)) in_formula_metadata = Traits::formula_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->formula_metadata)::BaseType> formula_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::FormulaMetadataDataView, send_validation>(
        in_formula_metadata,
        formula_metadata_fragment);

      fragment->formula_metadata.Set(
          formula_metadata_fragment.is_null() ? nullptr : formula_metadata_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::LineDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::LineDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Line_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::words(input)) in_words = Traits::words(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->words)::BaseType>
          words_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::WordDataView>, send_validation>(
        in_words,
        words_fragment,
        &words_validate_params);

      fragment->words.Set(
          words_fragment.is_null() ? nullptr : words_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->words.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null words in Line struct");

      decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geometry)::BaseType> geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::GeometryDataView, send_validation>(
        in_geometry,
        geometry_fragment);

      fragment->geometry.Set(
          geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::BackgroundImageDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::BackgroundImageDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::BackgroundImageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::background_image(input)) in_background_image = Traits::background_image(input);
      mojo::internal::MessageFragment<decltype(fragment->background_image)>
          background_image_fragment(fragment.message());
      background_image_fragment.Claim(&fragment->background_image);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_background_image,
        background_image_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->background_image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null background_image in BackgroundImageData struct");

      decltype(Traits::image_size(input)) in_image_size = Traits::image_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_size)::BaseType> image_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_image_size,
        image_size_fragment);

      fragment->image_size.Set(
          image_size_fragment.is_null() ? nullptr : image_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_size in BackgroundImageData struct");

      fragment->vertical_padding = Traits::vertical_padding(input);

      fragment->horizontal_padding = Traits::horizontal_padding(input);

      decltype(Traits::text_mask(input)) in_text_mask = Traits::text_mask(input);
      mojo::internal::MessageFragment<decltype(fragment->text_mask)>
          text_mask_fragment(fragment.message());
      text_mask_fragment.Claim(&fragment->text_mask);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_text_mask,
        text_mask_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_mask.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_mask in BackgroundImageData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::TranslatedLineDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TranslatedLineDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TranslatedLine_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::words(input)) in_words = Traits::words(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->words)::BaseType>
          words_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::WordDataView>, send_validation>(
        in_words,
        words_fragment,
        &words_validate_params);

      fragment->words.Set(
          words_fragment.is_null() ? nullptr : words_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->words.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null words in TranslatedLine struct");

      decltype(Traits::translation(input)) in_translation = Traits::translation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->translation)::BaseType> translation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_translation,
        translation_fragment);

      fragment->translation.Set(
          translation_fragment.is_null() ? nullptr : translation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->translation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null translation in TranslatedLine struct");

      decltype(Traits::text_color(input)) in_text_color = Traits::text_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_color)::BaseType> text_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_text_color,
        text_color_fragment);

      fragment->text_color.Set(
          text_color_fragment.is_null() ? nullptr : text_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_color in TranslatedLine struct");

      decltype(Traits::background_primary_color(input)) in_background_primary_color = Traits::background_primary_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->background_primary_color)::BaseType> background_primary_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_background_primary_color,
        background_primary_color_fragment);

      fragment->background_primary_color.Set(
          background_primary_color_fragment.is_null() ? nullptr : background_primary_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->background_primary_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null background_primary_color in TranslatedLine struct");

      decltype(Traits::background_image_data(input)) in_background_image_data = Traits::background_image_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->background_image_data)::BaseType> background_image_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::BackgroundImageDataDataView, send_validation>(
        in_background_image_data,
        background_image_data_fragment);

      fragment->background_image_data.Set(
          background_image_data_fragment.is_null() ? nullptr : background_image_data_fragment.data());

      decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geometry)::BaseType> geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::GeometryDataView, send_validation>(
        in_geometry,
        geometry_fragment);

      fragment->geometry.Set(
          geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::TranslatedParagraphDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::TranslatedParagraphDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::TranslatedParagraph_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lines(input)) in_lines = Traits::lines(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lines)::BaseType>
          lines_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::TranslatedLineDataView>, send_validation>(
        in_lines,
        lines_fragment,
        &lines_validate_params);

      fragment->lines.Set(
          lines_fragment.is_null() ? nullptr : lines_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lines.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lines in TranslatedParagraph struct");

      decltype(Traits::resized_bitmap_size(input)) in_resized_bitmap_size = Traits::resized_bitmap_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resized_bitmap_size)::BaseType> resized_bitmap_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_resized_bitmap_size,
        resized_bitmap_size_fragment);

      fragment->resized_bitmap_size.Set(
          resized_bitmap_size_fragment.is_null() ? nullptr : resized_bitmap_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resized_bitmap_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resized_bitmap_size in TranslatedParagraph struct");
      fragment->alignment_$flag = Traits::alignment(input).has_value();
      if (Traits::alignment(input).has_value()) {
        
        mojo::internal::Serialize<::lens::mojom::Alignment>(
          Traits::alignment(input).value(),
          &fragment->alignment_$value);
      } else {
        fragment->alignment_$value =
            static_cast<int32_t>(::lens::mojom::Alignment::kMinValue);
      }
      fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
      if (Traits::writing_direction(input).has_value()) {
        
        mojo::internal::Serialize<::lens::mojom::WritingDirection>(
          Traits::writing_direction(input).value(),
          &fragment->writing_direction_$value);
      } else {
        fragment->writing_direction_$value =
            static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
      }

      decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_language)::BaseType> content_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_language,
        content_language_fragment);

      fragment->content_language.Set(
          content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::ParagraphDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::ParagraphDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Paragraph_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lines(input)) in_lines = Traits::lines(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lines)::BaseType>
          lines_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::LineDataView>, send_validation>(
        in_lines,
        lines_fragment,
        &lines_validate_params);

      fragment->lines.Set(
          lines_fragment.is_null() ? nullptr : lines_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lines.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lines in Paragraph struct");

      decltype(Traits::translation(input)) in_translation = Traits::translation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->translation)::BaseType> translation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::TranslatedParagraphDataView, send_validation>(
        in_translation,
        translation_fragment);

      fragment->translation.Set(
          translation_fragment.is_null() ? nullptr : translation_fragment.data());

      decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geometry)::BaseType> geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::lens::mojom::GeometryDataView, send_validation>(
        in_geometry,
        geometry_fragment);

      fragment->geometry.Set(
          geometry_fragment.is_null() ? nullptr : geometry_fragment.data());
      fragment->writing_direction_$flag = Traits::writing_direction(input).has_value();
      if (Traits::writing_direction(input).has_value()) {
        
        mojo::internal::Serialize<::lens::mojom::WritingDirection>(
          Traits::writing_direction(input).value(),
          &fragment->writing_direction_$value);
      } else {
        fragment->writing_direction_$value =
            static_cast<int32_t>(::lens::mojom::WritingDirection::kMinValue);
      }

      decltype(Traits::content_language(input)) in_content_language = Traits::content_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_language)::BaseType> content_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_language,
        content_language_fragment);

      fragment->content_language.Set(
          content_language_fragment.is_null() ? nullptr : content_language_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::FormulaMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::FormulaMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::FormulaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::latex(input)) in_latex = Traits::latex(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latex)::BaseType> latex_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_latex,
        latex_fragment);

      fragment->latex.Set(
          latex_fragment.is_null() ? nullptr : latex_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_SEND_VALIDATION_H_