// chrome/browser/lens/core/mojom/polygon.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SHARED_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/polygon.mojom-shared-internal.h"




#include "chrome/browser/lens/core/mojom/polygon.mojom-data-view.h"




namespace std {

template <>
struct hash<::lens::mojom::Polygon_VertexOrdering>
    : public mojo::internal::EnumHashImpl<::lens::mojom::Polygon_VertexOrdering> {};

template <>
struct hash<::lens::mojom::Polygon_CoordinateType>
    : public mojo::internal::EnumHashImpl<::lens::mojom::Polygon_CoordinateType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::Polygon_VertexOrdering, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::Polygon_VertexOrdering, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::Polygon_VertexOrdering>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::Polygon_CoordinateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::Polygon_CoordinateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::Polygon_CoordinateType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::PolygonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::PolygonDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Polygon_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::vertex(input)) in_vertex = Traits::vertex(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vertex)::BaseType>
        vertex_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& vertex_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::VertexDataView>>(
      in_vertex,
      vertex_fragment,
      &vertex_validate_params);

    fragment->vertex.Set(
        vertex_fragment.is_null() ? nullptr : vertex_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vertex.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vertex in Polygon struct");

    
    mojo::internal::Serialize<::lens::mojom::Polygon_VertexOrdering>(
      Traits::vertex_ordering(input),
      &fragment->vertex_ordering);

    
    mojo::internal::Serialize<::lens::mojom::Polygon_CoordinateType>(
      Traits::coordinate_type(input),
      &fragment->coordinate_type);
  }

  static bool Deserialize(::lens::mojom::internal::Polygon_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::PolygonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::VertexDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::VertexDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Vertex_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);
  }

  static bool Deserialize(::lens::mojom::internal::Vertex_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::VertexDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace lens::mojom {

inline void PolygonDataView::GetVertexDataView(
    mojo::ArrayDataView<VertexDataView>* output) {
  auto pointer = data_->vertex.Get();
  *output = mojo::ArrayDataView<VertexDataView>(pointer, message_);
}





}  // lens::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::Polygon_VertexOrdering> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::Polygon_VertexOrdering value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::Polygon_CoordinateType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::Polygon_CoordinateType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_SHARED_H_